/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.google.common.io.BaseEncoding;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.util.HgVersion;

public final class HgRepositoryReader {
    private static final Logger LOG = Logger.getInstance(HgRepositoryReader.class);
    private static final Pattern HASH_NAME = Pattern.compile("\\s*([0-9a-fA-F]{40})[:?|\\s+](.+)");
    private static final Pattern HASH_STATUS_NAME = Pattern.compile("\\s*([0-9a-fA-F]+)\\s+\\w\\s+(.+)");
    @NotNull
    private final File myHgDir;
    @NotNull
    private File myBranchHeadsFile;
    @NotNull
    private final File myCacheDir;
    @NotNull
    private final File myCurrentBranch;
    @NotNull
    private final File myBookmarksFile;
    @NotNull
    private final File myCurrentBookmark;
    @NotNull
    private final File myTagsFile;
    @NotNull
    private final File myLocalTagsFile;
    @NotNull
    private final File myDirStateFile;
    @NotNull
    private final File mySubrepoFile;
    @NotNull
    private final File myMqInternalDir;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;
    private final boolean myStatusInBranchFile;
    @NotNull
    private final HgVcs myVcs;

    public HgRepositoryReader(@NotNull HgVcs vcs, @NotNull File hgDir) {
        if (vcs == null) {
            HgRepositoryReader.$$$reportNull$$$0(0);
        }
        if (hgDir == null) {
            HgRepositoryReader.$$$reportNull$$$0(1);
        }
        this.myHgDir = hgDir;
        DvcsUtil.assertFileExists((File)this.myHgDir, (String)(".hg directory not found in " + this.myHgDir));
        this.myVcs = vcs;
        HgVersion version = this.myVcs.getVersion();
        this.myStatusInBranchFile = version.hasBranch2();
        this.myCacheDir = new File(this.myHgDir, "cache");
        this.myBranchHeadsFile = HgRepositoryReader.identifyBranchHeadFile(version, this.myCacheDir);
        this.myCurrentBranch = new File(this.myHgDir, "branch");
        this.myBookmarksFile = new File(this.myHgDir, "bookmarks");
        this.myCurrentBookmark = new File(this.myHgDir, "bookmarks.current");
        this.myLocalTagsFile = new File(this.myHgDir, "localtags");
        this.myTagsFile = new File(this.myHgDir.getParentFile(), ".hgtags");
        this.mySubrepoFile = new File(this.myHgDir.getParentFile(), ".hgsubstate");
        this.myDirStateFile = new File(this.myHgDir, "dirstate");
        this.myMqInternalDir = new File(this.myHgDir, "patches");
        this.myVcsObjectsFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)vcs.getProject(), VcsLogObjectsFactory.class);
    }

    @NotNull
    private static File identifyBranchHeadFile(@NotNull HgVersion version, @NotNull File parentCacheFile) {
        if (version == null) {
            HgRepositoryReader.$$$reportNull$$$0(2);
        }
        if (parentCacheFile == null) {
            HgRepositoryReader.$$$reportNull$$$0(3);
        }
        if (version.hasBranch2()) {
            File file = new File(parentCacheFile, "branch2-served");
            return file.exists() ? file : new File(parentCacheFile, "branch2-base");
        }
        if (version.hasBranchHeadsBaseServed()) {
            File file = new File(parentCacheFile, "branchheads-served");
            return file.exists() ? file : new File(parentCacheFile, "branchheads-base");
        }
        return new File(parentCacheFile, "branchheads");
    }

    @Nullable
    public String readCurrentRevision() {
        if (!this.isDirStateInfoAvailable()) {
            return null;
        }
        try {
            return BaseEncoding.base16().lowerCase().encode(HgRepositoryReader.readHashBytesFromFile(this.myDirStateFile));
        }
        catch (IOException e) {
            LOG.error("IOException while trying to read current repository state information.", (Throwable)e);
            return null;
        }
    }

    private static byte @NotNull [] readHashBytesFromFile(@NotNull File file) throws IOException {
        byte[] byArray;
        FileInputStream stream;
        block7: {
            if (file == null) {
                HgRepositoryReader.$$$reportNull$$$0(4);
            }
            stream = (FileInputStream)FileUtilRt.doIOOperation(lastAttempt -> {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    if (lastAttempt) {
                        throw e;
                    }
                    return null;
                }
            });
            byArray = FileUtil.loadBytes((InputStream)Objects.requireNonNull(stream), (int)20);
            if (byArray != null) break block7;
            HgRepositoryReader.$$$reportNull$$$0(5);
        }
        return byArray;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Nullable
    public String readCurrentTipRevision() {
        String[] branchesWithHeads;
        if (!this.isBranchInfoAvailable()) {
            return null;
        }
        try {
            branchesWithHeads = DvcsUtil.tryLoadFile((File)this.myBranchHeadsFile).split("\n");
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
        String head = branchesWithHeads[0];
        Matcher matcher = HASH_NAME.matcher(head);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean isBranchInfoAvailable() {
        this.myBranchHeadsFile = HgRepositoryReader.identifyBranchHeadFile(this.myVcs.getVersion(), this.myCacheDir);
        return !this.isFresh() && this.myBranchHeadsFile.exists();
    }

    private boolean isDirStateInfoAvailable() {
        return this.myDirStateFile.exists();
    }

    @NotNull
    public String readCurrentBranch() {
        return this.branchExist() ? DvcsUtil.tryLoadFileOrReturn((File)this.myCurrentBranch, (String)"default") : "default";
    }

    @NotNull
    public Map<String, LinkedHashSet<Hash>> readBranches() {
        HashMap<String, LinkedHashSet<Hash>> branchesWithHashes = new HashMap<String, LinkedHashSet<Hash>>();
        if (this.isBranchInfoAvailable()) {
            Pattern activeBranchPattern = this.myStatusInBranchFile ? HASH_STATUS_NAME : HASH_NAME;
            String[] branchesWithHeads = DvcsUtil.tryLoadFileOrReturn((File)this.myBranchHeadsFile, (String)"").split("\n");
            for (int i = 1; i < branchesWithHeads.length; ++i) {
                Matcher matcher = activeBranchPattern.matcher(branchesWithHeads[i]);
                if (!matcher.matches()) continue;
                String name = matcher.group(2);
                if (branchesWithHashes.containsKey(name)) {
                    ((LinkedHashSet)branchesWithHashes.get(name)).add(this.myVcsObjectsFactory.createHash(matcher.group(1)));
                    continue;
                }
                LinkedHashSet<Hash> hashes = new LinkedHashSet<Hash>();
                hashes.add(this.myVcsObjectsFactory.createHash(matcher.group(1)));
                branchesWithHashes.put(name, hashes);
            }
        }
        HashMap<String, LinkedHashSet<Hash>> hashMap = branchesWithHashes;
        if (hashMap == null) {
            HgRepositoryReader.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    private boolean isMergeInProgress() {
        return new File(this.myHgDir, "merge").exists();
    }

    private boolean hasSubrepos() {
        return this.mySubrepoFile.exists();
    }

    private boolean isRebaseInProgress() {
        return new File(this.myHgDir, "rebasestate").exists();
    }

    private boolean isCherryPickInProgress() {
        return new File(this.myHgDir, "graftstate").exists();
    }

    @NotNull
    public Repository.State readState() {
        if (this.isRebaseInProgress()) {
            Repository.State state = Repository.State.REBASING;
            if (state == null) {
                HgRepositoryReader.$$$reportNull$$$0(7);
            }
            return state;
        }
        if (this.isCherryPickInProgress()) {
            Repository.State state = Repository.State.GRAFTING;
            if (state == null) {
                HgRepositoryReader.$$$reportNull$$$0(8);
            }
            return state;
        }
        Repository.State state = this.isMergeInProgress() ? Repository.State.MERGING : Repository.State.NORMAL;
        if (state == null) {
            HgRepositoryReader.$$$reportNull$$$0(9);
        }
        return state;
    }

    public boolean isFresh() {
        return !this.myCacheDir.exists();
    }

    private boolean branchExist() {
        return this.myCurrentBranch.exists();
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readBookmarks() {
        return this.readReferences(this.myBookmarksFile);
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readTags() {
        return this.readReferences(this.myTagsFile);
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readLocalTags() {
        return this.readReferences(this.myLocalTagsFile);
    }

    @NotNull
    private Collection<HgNameWithHashInfo> readReferences(@NotNull File fileWithReferences) {
        if (fileWithReferences == null) {
            HgRepositoryReader.$$$reportNull$$$0(10);
        }
        HashSet<HgNameWithHashInfo> result = new HashSet<HgNameWithHashInfo>();
        this.readReferences(fileWithReferences, result);
        HashSet<HgNameWithHashInfo> hashSet = result;
        if (hashSet == null) {
            HgRepositoryReader.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private void readReferences(@NotNull File fileWithReferences, @NotNull Collection<HgNameWithHashInfo> resultRefs) {
        String[] namesWithHashes;
        if (fileWithReferences == null) {
            HgRepositoryReader.$$$reportNull$$$0(12);
        }
        if (resultRefs == null) {
            HgRepositoryReader.$$$reportNull$$$0(13);
        }
        if (!fileWithReferences.exists()) {
            return;
        }
        for (String str : namesWithHashes = DvcsUtil.tryLoadFileOrReturn((File)fileWithReferences, (String)"").split("\n")) {
            Matcher matcher = HASH_NAME.matcher(str);
            if (!matcher.matches()) continue;
            resultRefs.add(new HgNameWithHashInfo(matcher.group(2), this.myVcsObjectsFactory.createHash(matcher.group(1))));
        }
    }

    @Nullable
    public String readCurrentBookmark() {
        return this.myCurrentBookmark.exists() ? DvcsUtil.tryLoadFileOrReturn((File)this.myCurrentBookmark, (String)"") : null;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readSubrepos() {
        if (!this.hasSubrepos()) {
            Set<HgNameWithHashInfo> set = Collections.emptySet();
            if (set == null) {
                HgRepositoryReader.$$$reportNull$$$0(14);
            }
            return set;
        }
        return this.readReferences(this.mySubrepoFile);
    }

    @NotNull
    public List<HgNameWithHashInfo> readMQAppliedPatches() {
        ArrayList<HgNameWithHashInfo> mqPatchRefs = new ArrayList<HgNameWithHashInfo>();
        this.readReferences(new File(this.myMqInternalDir, "status"), mqPatchRefs);
        ArrayList<HgNameWithHashInfo> arrayList = mqPatchRefs;
        if (arrayList == null) {
            HgRepositoryReader.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public List<String> readMqPatchNames() {
        File seriesFile = new File(this.myMqInternalDir, "series");
        List list = seriesFile.exists() ? StringUtil.split((String)DvcsUtil.tryLoadFileOrReturn((File)seriesFile, (String)""), (String)"\n") : ContainerUtil.emptyList();
        if (list == null) {
            HgRepositoryReader.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hgDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCacheFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/repo/HgRepositoryReader";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithReferences";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/repo/HgRepositoryReader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readHashBytesFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readBranches";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readSubrepos";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readMQAppliedPatches";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readMqPatchNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "identifyBranchHeadFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readHashBytesFromFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

