/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.Condition;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.JarBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.service.JpsServiceManager;

public class ArtifactInstructionsBuilderImpl
implements ArtifactInstructionsBuilder {
    private final Map<String, JarInfo> myJarByPath;
    private final List<ArtifactRootDescriptor> myDescriptors;
    private final ModuleExcludeIndex myRootsIndex;
    private final Iterable<ArtifactRootCopyingHandlerProvider> myCopyingHandlerProviders;
    private int myRootIndex;
    private final IgnoredFileIndex myIgnoredFileIndex;
    private final ArtifactBuildTarget myBuildTarget;
    private final JpsModel myModel;
    private final BuildDataPaths myBuildDataPaths;

    public ArtifactInstructionsBuilderImpl(@NotNull ModuleExcludeIndex rootsIndex, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull ArtifactBuildTarget target, @NotNull JpsModel model, @NotNull BuildDataPaths dataPaths) {
        if (rootsIndex == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(0);
        }
        if (ignoredFileIndex == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(1);
        }
        if (target == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(2);
        }
        if (model == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(3);
        }
        if (dataPaths == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(4);
        }
        this.myRootsIndex = rootsIndex;
        this.myIgnoredFileIndex = ignoredFileIndex;
        this.myBuildTarget = target;
        this.myModel = model;
        this.myBuildDataPaths = dataPaths;
        this.myJarByPath = new HashMap<String, JarInfo>();
        this.myDescriptors = new ArrayList<ArtifactRootDescriptor>();
        this.myCopyingHandlerProviders = JpsServiceManager.getInstance().getExtensions(ArtifactRootCopyingHandlerProvider.class);
    }

    public IgnoredFileIndex getIgnoredFileIndex() {
        return this.myIgnoredFileIndex;
    }

    public boolean addDestination(@NotNull ArtifactRootDescriptor descriptor) {
        if (descriptor == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(5);
        }
        this.myDescriptors.add(descriptor);
        return true;
    }

    public ModuleExcludeIndex getRootsIndex() {
        return this.myRootsIndex;
    }

    public boolean registerJarFile(@NotNull JarInfo jarInfo, @NotNull String outputPath) {
        if (jarInfo == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(6);
        }
        if (outputPath == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(7);
        }
        if (this.myJarByPath.containsKey(outputPath)) {
            return false;
        }
        this.myJarByPath.put(outputPath, jarInfo);
        return true;
    }

    @Override
    @NotNull
    public List<ArtifactRootDescriptor> getDescriptors() {
        List<ArtifactRootDescriptor> list = this.myDescriptors;
        if (list == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public FileBasedArtifactRootDescriptor createFileBasedRoot(@NotNull File file, @NotNull SourceFileFilter filter, @NotNull DestinationInfo destinationInfo, FileCopyingHandler handler) {
        if (file == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(10);
        }
        if (destinationInfo == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(11);
        }
        return new FileBasedArtifactRootDescriptor(file, filter, this.myRootIndex++, this.myBuildTarget, destinationInfo, handler);
    }

    @Override
    @NotNull
    public FileCopyingHandler createCopyingHandler(@NotNull File file, @NotNull JpsPackagingElement contextElement) {
        if (file == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(12);
        }
        if (contextElement == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(13);
        }
        for (ArtifactRootCopyingHandlerProvider provider : this.myCopyingHandlerProviders) {
            FileCopyingHandler handler = provider.createCustomHandler(this.myBuildTarget.getArtifact(), file, contextElement, this.myModel, this.myBuildDataPaths);
            if (handler == null) continue;
            FileCopyingHandler fileCopyingHandler = handler;
            if (fileCopyingHandler == null) {
                ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(14);
            }
            return fileCopyingHandler;
        }
        FileCopyingHandler fileCopyingHandler = FileCopyingHandler.DEFAULT;
        if (fileCopyingHandler == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(15);
        }
        return fileCopyingHandler;
    }

    @Override
    @NotNull
    public FileCopyingHandler createCopyingHandler(@NotNull File file, @NotNull JpsPackagingElement contextElement, @NotNull ArtifactCompilerInstructionCreator instructionCreator) {
        File targetDirectory;
        if (file == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(16);
        }
        if (contextElement == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(17);
        }
        if (instructionCreator == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(18);
        }
        if ((targetDirectory = instructionCreator.getTargetDirectory()) == null) {
            FileCopyingHandler fileCopyingHandler = FileCopyingHandler.DEFAULT;
            if (fileCopyingHandler == null) {
                ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(19);
            }
            return fileCopyingHandler;
        }
        for (ArtifactRootCopyingHandlerProvider provider : this.myCopyingHandlerProviders) {
            FileCopyingHandler handler = provider.createCustomHandler(this.myBuildTarget.getArtifact(), file, targetDirectory, contextElement, this.myModel, this.myBuildDataPaths);
            if (handler == null) continue;
            FileCopyingHandler fileCopyingHandler = handler;
            if (fileCopyingHandler == null) {
                ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(20);
            }
            return fileCopyingHandler;
        }
        FileCopyingHandler fileCopyingHandler = FileCopyingHandler.DEFAULT;
        if (fileCopyingHandler == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(21);
        }
        return fileCopyingHandler;
    }

    public JarBasedArtifactRootDescriptor createJarBasedRoot(@NotNull File jarFile, @NotNull String pathInJar, @NotNull SourceFileFilter filter, @NotNull DestinationInfo destinationInfo, @NotNull Condition<? super String> pathInJarFilter) {
        if (jarFile == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(22);
        }
        if (pathInJar == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(23);
        }
        if (filter == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(24);
        }
        if (destinationInfo == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(25);
        }
        if (pathInJarFilter == null) {
            ArtifactInstructionsBuilderImpl.$$$reportNull$$$0(26);
        }
        return new JarBasedArtifactRootDescriptor(jarFile, pathInJar, filter, this.myRootIndex++, this.myBuildTarget, destinationInfo, pathInJarFilter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationInfo";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionCreator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJarFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactInstructionsBuilderImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyingHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDestination";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerJarFile";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFileBasedRoot";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createCopyingHandler";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createJarBasedRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

