/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.impl.CSVReader;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessListUtil {
    private static final Logger LOG = Logger.getInstance(ProcessListUtil.class);
    private static final String WIN_PROCESS_LIST_HELPER_FILENAME = "WinProcessListHelper.exe";

    public static ProcessInfo @NotNull [] getProcessList() {
        List<ProcessInfo> result = ProcessListUtil.doGetProcessList();
        ProcessInfo[] processInfoArray = result.toArray(ProcessInfo.EMPTY_ARRAY);
        if (processInfoArray == null) {
            ProcessListUtil.$$$reportNull$$$0(0);
        }
        return processInfoArray;
    }

    @NotNull
    private static List<ProcessInfo> doGetProcessList() {
        if (SystemInfo.isWindows) {
            List<ProcessInfo> result = ProcessListUtil.getProcessListUsingWinProcessListHelper();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(1);
                }
                return list;
            }
            LOG.info("Cannot get process list via WinProcessListHelper.exe, fallback to wmic");
            result = ProcessListUtil.getProcessListUsingWindowsWMIC();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(2);
                }
                return list;
            }
            LOG.info("Cannot get process list via wmic, fallback to tasklist");
            result = ProcessListUtil.getProcessListUsingWindowsTaskList();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(3);
                }
                return list;
            }
            LOG.error("Cannot get process list via wmic and tasklist");
        } else if (SystemInfo.isUnix) {
            List<ProcessInfo> result = SystemInfo.isMac ? ProcessListUtil.getProcessListOnMac() : ProcessListUtil.getProcessListOnUnix();
            if (result != null) {
                List<ProcessInfo> list = result;
                if (list == null) {
                    ProcessListUtil.$$$reportNull$$$0(4);
                }
                return list;
            }
            LOG.error("Cannot get process list");
        } else {
            LOG.error("Cannot get process list, unexpected platform: " + SystemInfo.OS_NAME);
        }
        List<ProcessInfo> list = Collections.emptyList();
        if (list == null) {
            ProcessListUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private static List<ProcessInfo> parseCommandOutput(@NotNull List<@NlsSafe String> command, @NotNull NullableFunction<? super String, ? extends List<ProcessInfo>> parser) {
        if (command == null) {
            ProcessListUtil.$$$reportNull$$$0(6);
        }
        if (parser == null) {
            ProcessListUtil.$$$reportNull$$$0(7);
        }
        return ProcessListUtil.parseCommandOutput(command, parser, null);
    }

    @Nullable
    private static List<ProcessInfo> parseCommandOutput(@NotNull List<@NlsSafe String> command, @NotNull NullableFunction<? super String, ? extends List<ProcessInfo>> parser, @Nullable Charset charset) {
        String output;
        if (command == null) {
            ProcessListUtil.$$$reportNull$$$0(8);
        }
        if (parser == null) {
            ProcessListUtil.$$$reportNull$$$0(9);
        }
        try {
            ProcessOutput processOutput;
            int exitCode;
            GeneralCommandLine commandLine = new GeneralCommandLine(command);
            if (charset != null) {
                commandLine.withCharset(charset);
            }
            if ((exitCode = (processOutput = ExecUtil.execAndGetOutput(commandLine)).getExitCode()) != 0) {
                LOG.error("Cannot get process list, command '" + StringUtil.join(command, (String)" ") + "' exited with code " + exitCode + ", stdout:\n" + processOutput.getStdout() + "\nstderr:\n" + processOutput.getStderr());
            }
            output = processOutput.getStdout();
        }
        catch (ExecutionException e) {
            LOG.error("Cannot get process list", (Throwable)e);
            return null;
        }
        return (List)parser.fun((Object)output);
    }

    @Nullable
    private static List<ProcessInfo> getProcessListOnUnix() {
        File proc = new File("/proc");
        File[] processes = proc.listFiles();
        if (processes == null) {
            LOG.error("Cannot read /proc, not mounted?");
            return null;
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (File each : processes) {
            List cmdline;
            int pid = StringUtil.parseInt((String)each.getName(), (int)-1);
            if (pid == -1) continue;
            try (FileInputStream stream = new FileInputStream(new File(each, "cmdline"));){
                String cmdlineString = new String(FileUtil.loadBytes((InputStream)stream), StandardCharsets.UTF_8);
                cmdline = StringUtil.split((String)cmdlineString, (String)"\u0000");
            }
            catch (IOException e) {
                continue;
            }
            if (cmdline.isEmpty()) continue;
            String executablePath = null;
            try {
                File exe = new File(each, "exe");
                if (!exe.getAbsolutePath().equals(exe.getCanonicalPath())) {
                    executablePath = exe.getCanonicalPath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add(new ProcessInfo(pid, StringUtil.join((Collection)cmdline, (String)" "), PathUtil.getFileName((String)((String)cmdline.get(0))), StringUtil.join(cmdline.subList(1, cmdline.size()), (String)" "), executablePath));
        }
        return result;
    }

    @Nullable
    private static List<ProcessInfo> getProcessListOnMac() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,comm"), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)commandOnly -> ProcessListUtil.parseCommandOutput(Arrays.asList("/bin/ps", "-a", "-x", "-o", "pid,state,user,command"), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)full -> ProcessListUtil.parseMacOutput(commandOnly, full)))));
    }

    @Nullable
    public static List<ProcessInfo> parseMacOutput(@NotNull String commandOnly, @NotNull String full) {
        if (commandOnly == null) {
            ProcessListUtil.$$$reportNull$$$0(10);
        }
        if (full == null) {
            ProcessListUtil.$$$reportNull$$$0(11);
        }
        List<MacProcessInfo> commands = ProcessListUtil.doParseMacOutput(commandOnly);
        List<MacProcessInfo> fulls = ProcessListUtil.doParseMacOutput(full);
        if (commands == null || fulls == null) {
            return null;
        }
        Int2ObjectOpenHashMap idToCommand = new Int2ObjectOpenHashMap();
        for (MacProcessInfo each : commands) {
            idToCommand.put(each.pid, (Object)each.commandLine);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (MacProcessInfo each : fulls) {
            String command;
            if (!idToCommand.containsKey(each.pid) || !each.commandLine.equals(command = (String)idToCommand.get(each.pid)) && !each.commandLine.startsWith(command + " ")) continue;
            String name = PathUtil.getFileName((String)command);
            String args = each.commandLine.substring(command.length()).trim();
            result.add(new ProcessInfo(each.pid, each.commandLine, name, args, command));
        }
        return result;
    }

    @Nullable
    public static List<ProcessInfo> parseLinuxOutputMacStyle(@NotNull String commandOnly, @NotNull String full) {
        if (commandOnly == null) {
            ProcessListUtil.$$$reportNull$$$0(12);
        }
        if (full == null) {
            ProcessListUtil.$$$reportNull$$$0(13);
        }
        List<MacProcessInfo> commands = ProcessListUtil.doParseMacOutput(commandOnly);
        List<MacProcessInfo> fulls = ProcessListUtil.doParseMacOutput(full);
        if (commands == null || fulls == null) {
            return null;
        }
        Int2ObjectOpenHashMap idToCommand = new Int2ObjectOpenHashMap();
        for (MacProcessInfo each : commands) {
            idToCommand.put(each.pid, (Object)each.commandLine);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        for (MacProcessInfo each : fulls) {
            if (!idToCommand.containsKey(each.pid)) continue;
            String command = (String)idToCommand.get(each.pid);
            String name = PathUtil.getFileName((String)command);
            String args = each.commandLine.startsWith(command) ? each.commandLine.substring(command.length()).trim() : each.commandLine;
            result.add(new ProcessInfo(each.pid, each.commandLine, name, args, command));
        }
        return result;
    }

    @Nullable
    private static List<MacProcessInfo> doParseMacOutput(@NlsSafe String output) {
        ArrayList<MacProcessInfo> result = new ArrayList<MacProcessInfo>();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        @NlsSafe String header = lines[0];
        int pidStart = header.indexOf("PID");
        if (pidStart == -1) {
            return null;
        }
        int statStart = header.indexOf("S", pidStart);
        if (statStart == -1) {
            return null;
        }
        int userStart = header.indexOf("USER", statStart);
        if (userStart == -1) {
            return null;
        }
        int commandStart = header.indexOf("COMM", userStart);
        if (commandStart == -1) {
            return null;
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            try {
                String state;
                int pid = StringUtil.parseInt((String)line.substring(0, statStart).trim(), (int)-1);
                if (pid == -1 || (state = line.substring(statStart, userStart).trim()).contains("Z")) continue;
                String user = line.substring(userStart, commandStart).trim();
                String commandLine = line.substring(commandStart).trim();
                result.add(new MacProcessInfo(pid, commandLine, user, state));
                continue;
            }
            catch (Exception e) {
                LOG.error("Can't parse line '" + line + "'", (Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    private static List<ProcessInfo> getProcessListUsingWinProcessListHelper() {
        Path exeFile = ProcessListUtil.findWinProcessListHelperFile();
        if (exeFile == null) {
            return null;
        }
        return ProcessListUtil.parseCommandOutput(Collections.singletonList(exeFile.toAbsolutePath().toString()), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)ProcessListUtil::parseWinProcessListHelperOutput), StandardCharsets.UTF_8);
    }

    private static void logErrorTestSafe(@NonNls String message) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            LOG.warn(message);
        } else {
            LOG.error(message);
        }
    }

    @Nullable
    private static String unescapeString(@Nullable String str) {
        if (str == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < str.length(); ++index) {
            if (str.charAt(index) == '\\') {
                if (index == str.length() - 1) {
                    ProcessListUtil.logErrorTestSafe("Invalid escaped string: backslash at the last position");
                    LOG.debug(str);
                    return null;
                }
                switch (str.charAt(index + 1)) {
                    case '\\': {
                        builder.append('\\');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    default: {
                        ProcessListUtil.logErrorTestSafe("Invalid character after an escape symbol: " + str.charAt(index + 1));
                        LOG.debug(str);
                        return null;
                    }
                }
                ++index;
                continue;
            }
            builder.append(str.charAt(index));
        }
        return builder.toString();
    }

    @Nullable
    private static String removePrefix(String str, @NonNls String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        ProcessListUtil.logErrorTestSafe("Can't remove prefix \"" + prefix + "\"");
        LOG.debug(str);
        return null;
    }

    @Nullable
    static List<ProcessInfo> parseWinProcessListHelperOutput(@NotNull String output) {
        if (output == null) {
            ProcessListUtil.$$$reportNull$$$0(14);
        }
        String[] lines = StringUtil.splitByLines((String)output, (boolean)false);
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        if (lines.length % 3 != 0) {
            ProcessListUtil.logErrorTestSafe("Broken output of WinProcessListHelper.exe: output line count is not a multiple of 3");
            LOG.debug(output);
            return null;
        }
        int processCount = lines.length / 3;
        for (int i = 0; i < processCount; ++i) {
            String args;
            int offset = i * 3;
            String idString = ProcessListUtil.removePrefix(lines[offset], "pid:");
            int id = StringUtil.parseInt((String)idString, (int)-1);
            if (id == -1) {
                ProcessListUtil.logErrorTestSafe("Broken output of WinProcessListHelper.exe: process ID is not a number: " + lines[offset]);
                LOG.debug(output);
                return null;
            }
            if (id == 0) continue;
            String name = ProcessListUtil.unescapeString(ProcessListUtil.removePrefix(lines[offset + 1], "name:"));
            if (name == null) {
                ProcessListUtil.logErrorTestSafe("Failed to read a process name: " + lines[offset + 1]);
                LOG.debug(output);
                return null;
            }
            if (name.isEmpty()) continue;
            String commandLine = ProcessListUtil.unescapeString(ProcessListUtil.removePrefix(lines[offset + 2], "cmd:"));
            if (commandLine == null) {
                ProcessListUtil.logErrorTestSafe("Failed to read a process command line: " + lines[offset + 2]);
                LOG.debug(output);
                return null;
            }
            if (commandLine.isEmpty()) {
                commandLine = name;
                args = "";
            } else {
                args = ProcessListUtil.extractCommandLineArgs(commandLine, name);
            }
            result.add(new ProcessInfo(id, commandLine, name, args));
        }
        return result;
    }

    @NotNull
    private static String extractCommandLineArgs(@NotNull String fullCommandLine, @NotNull String executableName) {
        List commandLineList;
        if (fullCommandLine == null) {
            ProcessListUtil.$$$reportNull$$$0(15);
        }
        if (executableName == null) {
            ProcessListUtil.$$$reportNull$$$0(16);
        }
        if ((commandLineList = StringUtil.splitHonorQuotes((String)fullCommandLine, (char)' ')).isEmpty()) {
            return "";
        }
        String first = StringUtil.unquoteString((String)((String)commandLineList.get(0)));
        if (StringUtil.endsWithIgnoreCase((String)first, (String)executableName)) {
            List argsList = commandLineList.subList(1, commandLineList.size());
            String string = StringUtil.join(argsList, (String)" ");
            if (string == null) {
                ProcessListUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        return "";
    }

    @Nullable
    private static Path findWinProcessListHelperFile() {
        try {
            return PathManager.findBinFileWithException((String)WIN_PROCESS_LIST_HELPER_FILENAME);
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    static List<ProcessInfo> getProcessListUsingWindowsWMIC() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("wmic.exe", "path", "win32_process", "get", "Caption,Processid,Commandline,ExecutablePath"), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)ProcessListUtil::parseWMICOutput));
    }

    @Nullable
    static List<ProcessInfo> parseWMICOutput(@NotNull String output) {
        if (output == null) {
            ProcessListUtil.$$$reportNull$$$0(18);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        String[] lines = StringUtil.splitByLinesDontTrim((String)output);
        if (lines.length == 0) {
            return null;
        }
        String header = lines[0];
        int commandLineStart = header.indexOf("CommandLine");
        if (commandLineStart == -1) {
            return null;
        }
        int pidStart = header.indexOf("ProcessId");
        if (pidStart == -1) {
            return null;
        }
        int executablePathStart = header.indexOf("ExecutablePath");
        if (executablePathStart == -1) {
            return null;
        }
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            int pid = StringUtil.parseInt((String)line.substring(pidStart).trim(), (int)-1);
            if (pid == -1 || pid == 0) continue;
            String executablePath = line.substring(executablePathStart, pidStart).trim();
            String name = line.substring(0, commandLineStart).trim();
            if (name.isEmpty()) continue;
            String commandLine = line.substring(commandLineStart, executablePathStart).trim();
            String args = "";
            if (commandLine.isEmpty()) {
                commandLine = name;
            } else {
                args = ProcessListUtil.extractCommandLineArgs(commandLine, name);
            }
            result.add(new ProcessInfo(pid, commandLine, name, args, executablePath));
        }
        return result;
    }

    @Nullable
    static List<ProcessInfo> getProcessListUsingWindowsTaskList() {
        return ProcessListUtil.parseCommandOutput(Arrays.asList("tasklist.exe", "/fo", "csv", "/nh", "/v"), (NullableFunction<? super String, ? extends List<ProcessInfo>>)((NullableFunction)ProcessListUtil::parseListTasksOutput));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static List<ProcessInfo> parseListTasksOutput(@NotNull String output) {
        if (output == null) {
            ProcessListUtil.$$$reportNull$$$0(19);
        }
        ArrayList<ProcessInfo> result = new ArrayList<ProcessInfo>();
        CSVReader reader = new CSVReader(new StringReader(output));
        try {
            while (true) {
                String[] next;
                if ((next = reader.readNext()) != null) {
                    String name;
                    if (next.length < 2) {
                        List<ProcessInfo> list = null;
                        return list;
                    }
                    int pid = StringUtil.parseInt((String)next[1], (int)-1);
                    if (pid == -1 || (name = next[0]).isEmpty()) continue;
                    result.add(new ProcessInfo(pid, name, name, ""));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.error("Cannot parse listtasks output", (Throwable)e);
            List<ProcessInfo> list = null;
            return list;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/impl/ProcessListUtil";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandOnly";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "full";
                break;
            }
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCommandLine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetProcessList";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/impl/ProcessListUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCommandLineArgs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandOutput";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseMacOutput";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseLinuxOutputMacStyle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseWinProcessListHelperOutput";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractCommandLineArgs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseWMICOutput";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseListTasksOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MacProcessInfo {
        final int pid;
        final String commandLine;
        final String user;
        final String state;

        MacProcessInfo(int pid, String commandLine, String user, String state) {
            this.pid = pid;
            this.commandLine = commandLine;
            this.user = user;
            this.state = state;
        }
    }
}

