/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.action.lombok;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.rename.RenameProcessor;
import de.plushnikov.intellij.plugin.action.lombok.BaseLombokHandler;
import de.plushnikov.intellij.plugin.processor.clazz.log.AbstractLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.CommonsLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.CustomLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.FloggerProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.JBossLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.Log4j2Processor;
import de.plushnikov.intellij.plugin.processor.clazz.log.Log4jProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.LogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.Slf4jProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.XSlf4jProcessor;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LombokLoggerHandler
extends BaseLombokHandler {
    @Override
    protected void processClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LombokLoggerHandler.$$$reportNull$$$0(0);
        }
        List<AbstractLogProcessor> logProcessors = Arrays.asList((AbstractLogProcessor)ApplicationManager.getApplication().getService(CommonsLogProcessor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(JBossLogProcessor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(Log4jProcessor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(Log4j2Processor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(LogProcessor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(Slf4jProcessor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(XSlf4jProcessor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(FloggerProcessor.class), (AbstractLogProcessor)ApplicationManager.getApplication().getService(CustomLogProcessor.class));
        String lombokLoggerName = AbstractLogProcessor.getLoggerName(psiClass);
        boolean lombokLoggerIsStatic = AbstractLogProcessor.isLoggerStatic(psiClass);
        for (AbstractLogProcessor logProcessor : logProcessors) {
            for (PsiField psiField : psiClass.getFields()) {
                String loggerType = logProcessor.getLoggerType(psiClass);
                if (loggerType == null || !psiField.getType().equalsToText(loggerType) || !this.checkLoggerField(psiField, lombokLoggerName, lombokLoggerIsStatic)) continue;
                this.processLoggerField(psiField, psiClass, logProcessor, lombokLoggerName);
            }
        }
    }

    private void processLoggerField(@NotNull PsiField psiField, @NotNull PsiClass psiClass, @NotNull AbstractLogProcessor logProcessor, @NotNull String lombokLoggerName) {
        if (psiField == null) {
            LombokLoggerHandler.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            LombokLoggerHandler.$$$reportNull$$$0(2);
        }
        if (logProcessor == null) {
            LombokLoggerHandler.$$$reportNull$$$0(3);
        }
        if (lombokLoggerName == null) {
            LombokLoggerHandler.$$$reportNull$$$0(4);
        }
        if (!lombokLoggerName.equals(psiField.getName())) {
            RenameProcessor processor = new RenameProcessor(psiField.getProject(), (PsiElement)psiField, lombokLoggerName, false, false);
            processor.doRun();
        }
        this.addAnnotation(psiClass, logProcessor.getSupportedAnnotationClasses()[0]);
        psiField.delete();
    }

    private boolean checkLoggerField(@NotNull PsiField psiField, @NotNull String lombokLoggerName, boolean lombokLoggerIsStatic) {
        if (psiField == null) {
            LombokLoggerHandler.$$$reportNull$$$0(5);
        }
        if (lombokLoggerName == null) {
            LombokLoggerHandler.$$$reportNull$$$0(6);
        }
        if (!this.isValidLoggerField(psiField, lombokLoggerName, lombokLoggerIsStatic)) {
            String messageText = String.format("Logger field: \"%s\" Is not private %sfinal field named \"%s\". Refactor anyway?", psiField.getName(), lombokLoggerIsStatic ? "static " : "", lombokLoggerName);
            int result = Messages.showOkCancelDialog((String)messageText, (String)"Attention!", (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon());
            return 0 == result;
        }
        return true;
    }

    private boolean isValidLoggerField(@NotNull PsiField psiField, @NotNull String lombokLoggerName, boolean lombokLoggerIsStatic) {
        if (psiField == null) {
            LombokLoggerHandler.$$$reportNull$$$0(7);
        }
        if (lombokLoggerName == null) {
            LombokLoggerHandler.$$$reportNull$$$0(8);
        }
        boolean isPrivate = psiField.hasModifierProperty("private");
        boolean isStatic = lombokLoggerIsStatic == psiField.hasModifierProperty("static");
        boolean isFinal = psiField.hasModifierProperty("final");
        boolean isProperlyNamed = lombokLoggerName.equals(psiField.getName());
        return isPrivate && isStatic && isFinal && isProperlyNamed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lombokLoggerName";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/action/lombok/LombokLoggerHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processLoggerField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLoggerField";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidLoggerField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

