/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection.modifiers;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.fixes.RemoveModifierFix;
import de.plushnikov.intellij.plugin.inspection.modifiers.RedundantModifiersInfo;
import de.plushnikov.intellij.plugin.inspection.modifiers.RedundantModifiersInfoType;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LombokRedundantModifierInspection
extends AbstractBaseJavaLocalInspectionTool {
    private final String supportedAnnotation;
    private final RedundantModifiersInfo[] redundantModifiersInfo;

    public LombokRedundantModifierInspection(@Nullable String supportedAnnotation, RedundantModifiersInfo ... redundantModifiersInfo) {
        this.supportedAnnotation = supportedAnnotation;
        this.redundantModifiersInfo = redundantModifiersInfo;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LombokRedundantModifierInspection.$$$reportNull$$$0(0);
        }
        return new LombokRedundantModifiersVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/modifiers/LombokRedundantModifierInspection", "buildVisitor"));
    }

    private class LombokRedundantModifiersVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokRedundantModifiersVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            this.visit((PsiModifierListOwner)aClass);
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            this.visit((PsiModifierListOwner)field);
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            this.visit((PsiModifierListOwner)method);
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            this.visit((PsiModifierListOwner)variable);
        }

        public void visitParameter(PsiParameter parameter) {
            super.visitParameter(parameter);
            this.visit((PsiModifierListOwner)parameter);
        }

        private void visit(PsiModifierListOwner psiModifierListOwner) {
            for (RedundantModifiersInfo redundantModifiersInfo : LombokRedundantModifierInspection.this.redundantModifiersInfo) {
                PsiModifierList psiModifierList;
                RedundantModifiersInfoType infoType = redundantModifiersInfo.getType();
                PsiModifierListOwner parentModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiModifierListOwner.class, (infoType != RedundantModifiersInfoType.CLASS && infoType != RedundantModifiersInfoType.VARIABLE ? 1 : 0) != 0);
                if (parentModifierListOwner == null || infoType == RedundantModifiersInfoType.VARIABLE && !(parentModifierListOwner instanceof PsiLocalVariable) && !(parentModifierListOwner instanceof PsiParameter) || infoType != RedundantModifiersInfoType.VARIABLE && !(parentModifierListOwner instanceof PsiClass) || LombokRedundantModifierInspection.this.supportedAnnotation != null && !parentModifierListOwner.hasAnnotation(LombokRedundantModifierInspection.this.supportedAnnotation) || !redundantModifiersInfo.getType().getSupportedClass().isAssignableFrom(psiModifierListOwner.getClass()) || (psiModifierList = psiModifierListOwner.getModifierList()) == null || redundantModifiersInfo.getDontRunOnModifier() != null && psiModifierList.hasExplicitModifier(redundantModifiersInfo.getDontRunOnModifier()) || !redundantModifiersInfo.shouldCheck(psiModifierListOwner)) continue;
                for (String modifier : redundantModifiersInfo.getModifiers()) {
                    if (!psiModifierList.hasExplicitModifier(modifier)) continue;
                    Optional<PsiElement> psiModifier = Arrays.stream(psiModifierList.getChildren()).filter(psiElement -> modifier.equals(psiElement.getText())).findFirst();
                    psiModifier.ifPresent(psiElement -> this.holder.registerProblem(psiElement, redundantModifiersInfo.getDescription(), ProblemHighlightType.WARNING, new LocalQuickFix[]{new RemoveModifierFix(modifier)}));
                }
            }
        }
    }
}

