/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.constructor;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.AbstractConstructorClassProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NoArgsConstructorProcessor
extends AbstractConstructorClassProcessor {
    public NoArgsConstructorProcessor() {
        super("lombok.NoArgsConstructor", PsiMethod.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(2);
        }
        boolean result = super.validate(psiAnnotation, psiClass, builder);
        String staticConstructorName = this.getStaticConstructorName(psiAnnotation);
        return result &= this.validateIsConstructorNotDefined(psiClass, staticConstructorName, Collections.emptyList(), builder);
    }

    @NotNull
    public Collection<PsiMethod> createNoArgsConstructor(@NotNull PsiClass psiClass, @NotNull String methodVisibility, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(3);
        }
        if (methodVisibility == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(4);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(5);
        }
        boolean forceConstructorWithJavaDefaults = this.isForceConstructor(psiAnnotation);
        Collection<PsiMethod> collection = this.createNoArgsConstructor(psiClass, methodVisibility, psiAnnotation, forceConstructorWithJavaDefaults);
        if (collection == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiMethod> createNoArgsConstructor(@NotNull PsiClass psiClass, @NotNull String methodVisibility, @NotNull PsiAnnotation psiAnnotation, boolean withJavaDefaults) {
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(7);
        }
        if (methodVisibility == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(8);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(9);
        }
        Collection<PsiField> params = this.getConstructorFields(psiClass, withJavaDefaults);
        Collection<PsiMethod> collection = this.createConstructorMethod(psiClass, methodVisibility, psiAnnotation, withJavaDefaults, params);
        if (collection == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private boolean isForceConstructor(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(11);
        }
        return PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "force", false);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        String methodVisibility;
        if (psiClass == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(13);
        }
        if (target == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(14);
        }
        if (null != (methodVisibility = LombokProcessorUtil.getAccessVisibility(psiAnnotation))) {
            target.addAll(this.createNoArgsConstructor(psiClass, methodVisibility, psiAnnotation));
        }
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        boolean forceConstructorWithJavaDefaults;
        Collection<PsiField> params;
        PsiClass containingClass;
        if (psiField == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(15);
        }
        if (psiAnnotation == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(16);
        }
        if (null != (containingClass = psiField.getContainingClass()) && PsiClassUtil.getNames(params = this.getConstructorFields(containingClass, forceConstructorWithJavaDefaults = this.isForceConstructor(psiAnnotation))).contains(psiField.getName())) {
            return LombokPsiElementUsage.WRITE;
        }
        return LombokPsiElementUsage.NONE;
    }

    @NotNull
    private Collection<PsiField> getConstructorFields(PsiClass containingClass, boolean forceConstructorWithJavaDefaults) {
        Collection<PsiField> params = forceConstructorWithJavaDefaults ? this.getRequiredFields(containingClass) : Collections.emptyList();
        List<PsiField> list = params;
        if (list == null) {
            NoArgsConstructorProcessor.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodVisibility";
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/NoArgsConstructorProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/constructor/NoArgsConstructorProcessor";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoArgsConstructor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNoArgsConstructor";
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isForceConstructor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

