/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.thirdparty;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class LombokUtils {
    public static final String LOMBOK_INTERN_FIELD_MARKER = "$";
    public static final Pattern NON_NULL_PATTERN = Pattern.compile("^(?:nonnull)$", 2);
    public static final Pattern NULLABLE_PATTERN = Pattern.compile("^(?:nullable|checkfornull)$", 2);
    public static final Pattern DEPRECATED_PATTERN = Pattern.compile("^(?:deprecated)$", 2);

    public static String getGetterName(@NotNull PsiField psiField) {
        if (psiField == null) {
            LombokUtils.$$$reportNull$$$0(0);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.build(psiField);
        String psiFieldName = psiField.getName();
        boolean isBoolean = PsiType.BOOLEAN.equals((Object)psiField.getType());
        return LombokUtils.toGetterName(accessorsInfo, psiFieldName, isBoolean);
    }

    public static String getSetterName(@NotNull PsiField psiField) {
        if (psiField == null) {
            LombokUtils.$$$reportNull$$$0(1);
        }
        return LombokUtils.getSetterName(psiField, PsiType.BOOLEAN.equals((Object)psiField.getType()));
    }

    public static String getSetterName(@NotNull PsiField psiField, boolean isBoolean) {
        if (psiField == null) {
            LombokUtils.$$$reportNull$$$0(2);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.build(psiField);
        return LombokUtils.toSetterName(accessorsInfo, psiField.getName(), isBoolean);
    }

    public static String toGetterName(AccessorsInfo accessors, String fieldName, boolean isBoolean) {
        return LombokUtils.toAccessorName(accessors, fieldName, isBoolean, "is", "get");
    }

    public static String toSetterName(AccessorsInfo accessors, String fieldName, boolean isBoolean) {
        return LombokUtils.toAccessorName(accessors, fieldName, isBoolean, "set", "set");
    }

    public static String toWitherName(AccessorsInfo accessors, String fieldName, boolean isBoolean) {
        if (accessors.isFluent()) {
            throw new IllegalArgumentException("@Wither does not support @Accessors(fluent=true)");
        }
        return LombokUtils.toAccessorName(accessors, fieldName, isBoolean, "with", "with");
    }

    private static String toAccessorName(AccessorsInfo accessorsInfo, String fieldName, boolean isBoolean, String booleanPrefix, String normalPrefix) {
        String result;
        boolean useBooleanPrefix;
        fieldName = accessorsInfo.removePrefix(fieldName);
        if (accessorsInfo.isFluent()) {
            return fieldName;
        }
        boolean bl = useBooleanPrefix = isBoolean && !accessorsInfo.isDoNotUseIsPrefix();
        if (useBooleanPrefix) {
            if (fieldName.startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
                String baseName = fieldName.substring(2);
                result = LombokUtils.buildName(booleanPrefix, baseName);
            } else {
                result = LombokUtils.buildName(booleanPrefix, fieldName);
            }
        } else {
            result = LombokUtils.buildName(normalPrefix, fieldName);
        }
        return result;
    }

    public static Collection<String> toAllGetterNames(AccessorsInfo accessorsInfo, String fieldName, boolean isBoolean) {
        return LombokUtils.toAllAccessorNames(accessorsInfo, fieldName, isBoolean, "is", "get");
    }

    public static Collection<String> toAllSetterNames(AccessorsInfo accessorsInfo, String fieldName, boolean isBoolean) {
        return LombokUtils.toAllAccessorNames(accessorsInfo, fieldName, isBoolean, "set", "set");
    }

    public static Collection<String> toAllWitherNames(AccessorsInfo accessorsInfo, String fieldName, boolean isBoolean) {
        if (accessorsInfo.isFluent()) {
            throw new IllegalArgumentException("@Wither does not support @Accessors(fluent=true)");
        }
        return LombokUtils.toAllAccessorNames(accessorsInfo, fieldName, isBoolean, "with", "with");
    }

    private static Collection<String> toAllAccessorNames(AccessorsInfo accessorsInfo, String fieldName, boolean isBoolean, String booleanPrefix, String normalPrefix) {
        HashSet<String> result = new HashSet<String>();
        fieldName = accessorsInfo.removePrefix(fieldName);
        if (accessorsInfo.isFluent()) {
            result.add(StringUtil.decapitalize((String)fieldName));
            return result;
        }
        if (isBoolean) {
            result.add(LombokUtils.buildName(normalPrefix, fieldName));
            result.add(LombokUtils.buildName(booleanPrefix, fieldName));
            if (fieldName.startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
                String baseName = fieldName.substring(2);
                result.add(LombokUtils.buildName(normalPrefix, baseName));
                result.add(LombokUtils.buildName(booleanPrefix, baseName));
            }
        } else {
            result.add(LombokUtils.buildName(normalPrefix, fieldName));
        }
        return result;
    }

    public static String buildAccessorName(String prefix, String suffix) {
        if (prefix.isEmpty()) {
            return suffix;
        }
        if (suffix.isEmpty()) {
            return prefix;
        }
        return LombokUtils.buildName(prefix, suffix);
    }

    private static String buildName(String prefix, String suffix) {
        return prefix + StringUtil.capitalize((String)suffix);
    }

    public static String camelCaseToConstant(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(Character.toUpperCase(fieldName.charAt(0)));
        for (int i = 1; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                b.append('_');
            }
            b.append(Character.toUpperCase(c));
        }
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiField";
        objectArray2[1] = "de/plushnikov/intellij/plugin/thirdparty/LombokUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getGetterName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSetterName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

