/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationSearchUtil {
    private static final Key<String> LOMBOK_ANNOTATION_FQN_KEY = Key.create((String)"LOMBOK_ANNOTATION_FQN");

    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull String annotationFQN) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(1);
        }
        return PsiAnnotationSearchUtil.findAnnotationQuick((PsiAnnotationOwner)psiModifierListOwner.getModifierList(), annotationFQN);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationFQNs) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(2);
        }
        if (annotationFQNs == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(3);
        }
        return PsiAnnotationSearchUtil.findAnnotationQuick((PsiAnnotationOwner)psiModifierListOwner.getModifierList(), annotationFQNs);
    }

    @Nullable
    private static PsiAnnotation findAnnotationQuick(@Nullable PsiAnnotationOwner annotationOwner, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(4);
        }
        if (annotationOwner == null) {
            return null;
        }
        PsiAnnotation[] annotations = annotationOwner.getAnnotations();
        if (annotations.length == 0) {
            return null;
        }
        String shortName = StringUtil.getShortName((String)qualifiedName);
        for (PsiAnnotation annotation : annotations) {
            String possibleFullQualifiedName;
            String referenceName;
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (null == referenceElement || !shortName.equals(referenceName = referenceElement.getReferenceName())) continue;
            if (referenceElement.isQualified() && referenceElement instanceof SourceJavaCodeReference && qualifiedName.equals(possibleFullQualifiedName = ((SourceJavaCodeReference)referenceElement).getClassNameText())) {
                return annotation;
            }
            String annotationQualifiedName = PsiAnnotationSearchUtil.getAndCacheFQN(annotation, referenceName);
            if (null == annotationQualifiedName || !qualifiedName.endsWith(annotationQualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationQuick(@Nullable PsiAnnotationOwner annotationOwner, String ... qualifiedNames) {
        if (qualifiedNames == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(5);
        }
        if (annotationOwner == null || qualifiedNames.length == 0) {
            return null;
        }
        PsiAnnotation[] annotations = annotationOwner.getAnnotations();
        if (annotations.length == 0) {
            return null;
        }
        Object[] shortNames = new String[qualifiedNames.length];
        for (int i = 0; i < qualifiedNames.length; ++i) {
            shortNames[i] = StringUtil.getShortName((String)qualifiedNames[i]);
        }
        for (PsiAnnotation annotation : annotations) {
            String possibleFullQualifiedName;
            String referenceName;
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (null == referenceElement || ArrayUtil.find((Object[])shortNames, (Object)(referenceName = referenceElement.getReferenceName())) <= -1) continue;
            if (referenceElement.isQualified() && referenceElement instanceof SourceJavaCodeReference && ArrayUtil.find((Object[])qualifiedNames, (Object)(possibleFullQualifiedName = ((SourceJavaCodeReference)referenceElement).getClassNameText())) > -1) {
                return annotation;
            }
            String annotationQualifiedName = PsiAnnotationSearchUtil.getAndCacheFQN(annotation, referenceName);
            if (ArrayUtil.find((Object[])qualifiedNames, (Object)annotationQualifiedName) <= -1) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    private static String getAndCacheFQN(@NotNull PsiAnnotation annotation, @Nullable String referenceName) {
        String annotationQualifiedName;
        if (annotation == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(6);
        }
        if ((null == (annotationQualifiedName = (String)annotation.getCopyableUserData(LOMBOK_ANNOTATION_FQN_KEY)) || null != referenceName && !annotationQualifiedName.endsWith(".".concat(referenceName))) && null != (annotationQualifiedName = annotation.getQualifiedName()) && annotationQualifiedName.indexOf(46) > -1) {
            annotation.putCopyableUserData(LOMBOK_ANNOTATION_FQN_KEY, (Object)annotationQualifiedName);
        }
        return annotationQualifiedName;
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull String annotationTypeName) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(7);
        }
        if (annotationTypeName == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(8);
        }
        return null != PsiAnnotationSearchUtil.findAnnotation(psiModifierListOwner, annotationTypeName);
    }

    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String annotationTypeName) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(9);
        }
        return !PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, annotationTypeName);
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationTypes) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(10);
        }
        if (annotationTypes == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(11);
        }
        return null != PsiAnnotationSearchUtil.findAnnotation(psiModifierListOwner, annotationTypes);
    }

    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationTypes) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(12);
        }
        if (annotationTypes == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(13);
        }
        return !PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, annotationTypes);
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull Pattern annotationPattern) {
        PsiModifierList psiModifierList;
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(14);
        }
        if (annotationPattern == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(15);
        }
        if ((psiModifierList = psiModifierListOwner.getModifierList()) != null) {
            for (PsiAnnotation psiAnnotation : psiModifierList.getAnnotations()) {
                String suspect = PsiAnnotationSearchUtil.getSimpleNameOf(psiAnnotation);
                if (!annotationPattern.matcher(suspect).matches()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getSimpleNameOf(@NotNull PsiAnnotation psiAnnotation) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiAnnotation == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(16);
        }
        String string = StringUtil.notNullize((String)(null == (referenceElement = psiAnnotation.getNameReferenceElement()) ? null : referenceElement.getReferenceName()));
        if (string == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean checkAnnotationsSimpleNameExistsIn(@NotNull PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        PsiModifierList modifierList;
        if (modifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(18);
        }
        if (annotationNames == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(19);
        }
        if (null != (modifierList = modifierListOwner.getModifierList())) {
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                String simpleName = PsiAnnotationSearchUtil.getSimpleNameOf(psiAnnotation);
                if (!annotationNames.contains(simpleName)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQNs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTypeName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTypes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationPattern";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/PsiAnnotationSearchUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/PsiAnnotationSearchUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleNameOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationQuick";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndCacheFQN";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedWith";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNotAnnotatedWith";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleNameOf";
                break;
            }
            case 17: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationsSimpleNameExistsIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

