/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalActionProviderBase;
import com.jediterm.terminal.ui.TerminalWidgetListener;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public final class TerminalSessionEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(TerminalSessionEditor.class);
    private final Project myProject;
    private final TerminalSessionVirtualFileImpl myFile;
    private final TerminalWidgetListener myListener;
    private final Disposable myWidgetParentDisposable;

    public TerminalSessionEditor(Project project, @NotNull TerminalSessionVirtualFileImpl terminalFile) {
        if (terminalFile == null) {
            TerminalSessionEditor.$$$reportNull$$$0(0);
        }
        this.myWidgetParentDisposable = Disposer.newDisposable((String)"terminal widget parent");
        this.myProject = project;
        this.myFile = terminalFile;
        terminalFile.getTerminalWidget().moveDisposable(this.myWidgetParentDisposable);
        final TabbedSettingsProvider settings = this.myFile.getSettingsProvider();
        this.myFile.getTerminalWidget().setNextProvider((TerminalActionProvider)new TerminalActionProviderBase(){

            public List<TerminalAction> getActions() {
                return Collections.singletonList(new TerminalAction(settings.getCloseSessionActionPresentation(), input -> {
                    TerminalSessionEditor.this.handleCloseSession();
                    return true;
                }).withMnemonicKey(Integer.valueOf(83)));
            }
        });
        this.myListener = widget -> ApplicationManager.getApplication().invokeLater(() -> FileEditorManagerEx.getInstanceEx((Project)this.myProject).closeFile((VirtualFile)this.myFile), this.myProject.getDisposed());
        this.myFile.getTerminalWidget().addListener(this.myListener);
    }

    private void handleCloseSession() {
        this.myFile.getTerminalWidget().terminateProcess();
    }

    @NotNull
    public JComponent getComponent() {
        JBTerminalWidget jBTerminalWidget = this.myFile.getTerminalWidget();
        if (jBTerminalWidget == null) {
            TerminalSessionEditor.$$$reportNull$$$0(1);
        }
        return jBTerminalWidget;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myFile.getTerminalWidget();
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            TerminalSessionEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TerminalSessionEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TerminalSessionEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TerminalSessionEditor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        this.myFile.getTerminalWidget().removeListener(this.myListener);
        if (Boolean.TRUE.equals(this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean disposedBefore = Disposer.isDisposed((Disposable)this.myFile.getTerminalWidget());
                Disposer.dispose((Disposable)this.myWidgetParentDisposable);
                boolean disposedAfter = Disposer.isDisposed((Disposable)this.myFile.getTerminalWidget());
                if (disposedBefore != disposedAfter) {
                    LOG.error(JBTerminalWidget.class.getSimpleName() + " parent disposable hasn't been changed (disposed before: " + disposedBefore + ", disposed after: " + disposedAfter + ")");
                }
            });
        } else {
            Disposer.dispose((Disposable)this.myWidgetParentDisposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

