/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.application.options.XmlSettings;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.daemon.impl.analysis.ImportNSAction;
import com.intellij.codeInsight.daemon.impl.analysis.XmlNSRenderer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNSDeclarationIntentionFix
implements HintAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(CreateNSDeclarationIntentionFix.class);
    private final String myNamespacePrefix;
    private final PsiAnchor myElement;
    private final PsiAnchor myToken;

    @NotNull
    private XmlFile getFile() {
        XmlFile xmlFile = (XmlFile)this.myElement.getFile();
        if (xmlFile == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(0);
        }
        return xmlFile;
    }

    protected CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix) {
        if (element == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(1);
        }
        if (namespacePrefix == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(2);
        }
        this(element, namespacePrefix, null);
    }

    public CreateNSDeclarationIntentionFix(@NotNull PsiElement element, @NotNull String namespacePrefix, @Nullable XmlToken token) {
        if (element == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(3);
        }
        if (namespacePrefix == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(4);
        }
        this.myNamespacePrefix = namespacePrefix;
        this.myElement = PsiAnchor.create((PsiElement)element);
        this.myToken = token == null ? null : PsiAnchor.create((PsiElement)token);
    }

    @NotNull
    public String getText() {
        String alias = this.getXmlNamespaceHelper().getNamespaceAlias(this.getFile());
        String string = XmlPsiBundle.message((String)"xml.quickfix.create.namespace.declaration.text", (Object[])new Object[]{alias});
        if (string == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private XmlNamespaceHelper getXmlNamespaceHelper() {
        return XmlNamespaceHelper.getHelper((PsiFile)this.getFile());
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlPsiBundle.message((String)"xml.quickfix.create.namespace.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file;
        if (project == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(8);
        }
        PsiFile containingFile = descriptor.getPsiElement().getContainingFile();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        PsiFile psiFile = file = editor != null ? PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) : null;
        if (file == null || !Comparing.equal((Object)file.getVirtualFile(), (Object)containingFile.getVirtualFile())) {
            return;
        }
        try {
            this.invoke(project, editor, containingFile);
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(9);
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        PsiElement element = this.myElement.retrieve();
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        return element != null && rootTag != null && !PsiUtilCore.hasErrorElementChild((PsiElement)rootTag);
    }

    @NotNull
    private List<String> getNamespaces(PsiElement element, XmlFile xmlFile) {
        Set<String> set;
        String match;
        if (element instanceof XmlAttribute) {
            element = element.getParent();
        }
        if ((match = CreateNSDeclarationIntentionFix.getUnboundNamespaceForPrefix(this.myNamespacePrefix, xmlFile, set = this.getXmlNamespaceHelper().guessUnboundNamespaces(element, xmlFile))) != null) {
            List<String> list = Collections.singletonList(match);
            if (list == null) {
                CreateNSDeclarationIntentionFix.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<String> namespaces = new ArrayList<String>(set);
        Collections.sort(namespaces);
        ArrayList<String> arrayList = namespaces;
        if (arrayList == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final @NotNull PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(12);
        }
        if (file == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(13);
        }
        if ((element = this.myElement.retrieve()) == null) {
            return;
        }
        final XmlFile xmlFile = this.getFile();
        String[] namespaces = ArrayUtilRt.toStringArray(this.getNamespaces(element, xmlFile));
        CreateNSDeclarationIntentionFix.runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(namespaces, project, new StringToAttributeProcessor(){

            @Override
            public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NotNull String namespace) throws IncorrectOperationException {
                String prefix;
                if (namespace == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtil.isEmpty((String)(prefix = CreateNSDeclarationIntentionFix.this.myNamespacePrefix))) {
                    XmlFile xmlFile2 = XmlExtension.getExtension(file).getContainingFile(element);
                    prefix = ExtendedTagInsertHandler.getPrefixByNamespace(xmlFile2, namespace);
                    if (StringUtil.isNotEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, element);
                        return;
                    }
                    prefix = ExtendedTagInsertHandler.suggestPrefix(xmlFile2, namespace);
                    if (!StringUtil.isEmpty((String)prefix)) {
                        ExtendedTagInsertHandler.qualifyWithPrefix(prefix, element);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    }
                }
                int offset = editor.getCaretModel().getOffset();
                RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
                XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper((PsiFile)xmlFile);
                helper.insertNamespaceDeclaration(xmlFile, editor, Collections.singleton(namespace), prefix, __ -> {
                    if (!namespace.isEmpty()) {
                        editor.getCaretModel().moveToOffset(marker.getStartOffset());
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix$1", "doSomethingWithGivenStringToProduceXmlAttributeNowPlease"));
            }
        }, this.getSelectNSActionTitle(), (IntentionAction)this, editor);
    }

    @Nullable
    public static String getUnboundNamespaceForPrefix(String prefix, XmlFile xmlFile, Set<String> namespaces) {
        List providers = XmlSchemaProvider.getAvailableProviders((XmlFile)xmlFile);
        for (XmlSchemaProvider provider : providers) {
            for (String namespace : namespaces) {
                if (!prefix.equals(provider.getDefaultPrefix(namespace, xmlFile))) continue;
                return namespace;
            }
        }
        return null;
    }

    @NlsContexts.PopupTitle
    private String getSelectNSActionTitle() {
        return XmlPsiBundle.message((String)"xml.action.select.namespace.title", (Object[])new Object[]{StringUtil.capitalize((String)this.getXmlNamespaceHelper().getNamespaceAlias(this.getFile()))});
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(14);
        }
        XmlToken token = null;
        if (this.myToken != null && (token = (XmlToken)this.myToken.retrieve()) == null) {
            return false;
        }
        if (!XmlSettings.getInstance().SHOW_XML_ADD_IMPORT_HINTS || this.myNamespacePrefix.isEmpty()) {
            return false;
        }
        PsiElement element = this.myElement.retrieve();
        if (element == null) {
            return false;
        }
        List<String> namespaces = this.getNamespaces(element, this.getFile());
        if (!namespaces.isEmpty()) {
            String message = ShowAutoImportPass.getMessage((namespaces.size() > 1 ? 1 : 0) != 0, (String)namespaces.iterator().next());
            String title = this.getSelectNSActionTitle();
            ImportNSAction action = new ImportNSAction(namespaces, this.getFile(), element, editor, title);
            if (element instanceof XmlTag && token != null) {
                if (VisibleHighlightingPassFactory.calculateVisibleRange((Editor)editor).contains(token.getTextRange())) {
                    HintManager.getInstance().showQuestionHint(editor, message, token.getTextOffset(), token.getTextOffset() + this.myNamespacePrefix.length(), (QuestionAction)action);
                    return true;
                }
            } else {
                HintManager.getInstance().showQuestionHint(editor, message, element.getTextOffset(), element.getTextRange().getEndOffset(), (QuestionAction)action);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfGivenXmlHasTheseWords(String name, XmlFile tldFileByUri) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        List list = StringUtil.getWordsIn((String)name);
        final String[] words = ArrayUtilRt.toStringArray((Collection)list);
        final boolean[] wordsFound = new boolean[words.length];
        final int[] wordsFoundCount = new int[1];
        IdTableBuilding.ScanWordProcessor wordProcessor = new IdTableBuilding.ScanWordProcessor(){

            public void run(CharSequence chars, char @Nullable [] charsArray, int start, int end) {
                if (wordsFoundCount[0] == words.length) {
                    return;
                }
                int foundWordLen = end - start;
                block0: for (int i = 0; i < words.length; ++i) {
                    String localName = words[i];
                    if (wordsFound[i] || localName.length() != foundWordLen) continue;
                    for (int j = 0; j < localName.length(); ++j) {
                        if (chars.charAt(start + j) != localName.charAt(j)) continue block0;
                    }
                    wordsFound[i] = true;
                    wordsFoundCount[0] = wordsFoundCount[0] + 1;
                    break;
                }
            }
        };
        CharSequence contents = tldFileByUri.getViewProvider().getContents();
        IdTableBuilding.scanWords((IdTableBuilding.ScanWordProcessor)wordProcessor, (CharSequence)contents, (int)0, (int)contents.length());
        return wordsFoundCount[0] == words.length;
    }

    public static void runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne(String @NotNull [] namespacesToChooseFrom, Project project, StringToAttributeProcessor onSelection, @NlsContexts.PopupTitle String title, IntentionAction requestor, Editor editor) throws IncorrectOperationException {
        if (namespacesToChooseFrom == null) {
            CreateNSDeclarationIntentionFix.$$$reportNull$$$0(15);
        }
        if (namespacesToChooseFrom.length > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])namespacesToChooseFrom)).setRenderer((ListCellRenderer)((Object)new XmlNSRenderer())).setTitle(title).setItemChosenCallback(selectedValue -> {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease((String)selectedValue);
                    }
                    catch (IncorrectOperationException ex) {
                        throw new RuntimeException(ex);
                    }
                }), requestor.getText(), (Object)requestor.getFamilyName());
            }).createPopup().showInBestPositionFor(editor);
        } else {
            WriteAction.run(() -> {
                String attrName = namespacesToChooseFrom.length == 0 ? "" : namespacesToChooseFrom[0];
                onSelection.doSomethingWithGivenStringToProduceXmlAttributeNowPlease(attrName);
            });
        }
    }

    public static void processExternalUris(MetaHandler metaHandler, PsiFile file, ExternalUriProcessor processor) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> CreateNSDeclarationIntentionFix.processExternalUrisImpl(metaHandler, file, processor)), XmlPsiBundle.message((String)"xml.progress.finding.acceptable.uri", (Object[])new Object[0]), false, file.getProject());
    }

    private static void processExternalUrisImpl(MetaHandler metaHandler, PsiFile file, ExternalUriProcessor processor) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        String searchFor = metaHandler.searchFor();
        if (pi != null) {
            pi.setText(XmlPsiBundle.message((String)"xml.progress.looking.in.schemas", (Object[])new Object[0]));
            pi.setIndeterminate(false);
        }
        ExternalResourceManager instanceEx = ExternalResourceManager.getInstance();
        String[] availableUrls = instanceEx.getResourceUrls(null, true);
        int i = 0;
        for (String url : availableUrls) {
            String defaultNamespace;
            boolean wordFound;
            XmlFile xmlFile;
            if (pi != null) {
                pi.setFraction((double)i / (double)availableUrls.length);
                pi.setText2(url);
                ++i;
            }
            if ((xmlFile = XmlUtil.findNamespace(file, url)) == null || !(wordFound = CreateNSDeclarationIntentionFix.checkIfGivenXmlHasTheseWords(searchFor, xmlFile))) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            PsiMetaData metaData = document.getMetaData();
            if (!metaHandler.isAcceptableMetaData(metaData, url)) continue;
            XmlNSDescriptorImpl descriptor = metaData instanceof XmlNSDescriptorImpl ? (XmlNSDescriptorImpl)metaData : null;
            String string = defaultNamespace = descriptor != null ? descriptor.getDefaultNamespace() : url;
            if ("http://www.w3.org/1999/XMLSchema".equals(defaultNamespace) || "http://www.w3.org/2000/10/XMLSchema".equals(defaultNamespace)) continue;
            processor.process(defaultNamespace, url);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacesToChooseFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/CreateNSDeclarationIntentionFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runActionOverSeveralAttributeValuesAfterLettingUserSelectTheNeededOne";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ExternalUriProcessor {
        public void process(@NotNull String var1, @Nullable String var2);
    }

    public static class TagMetaHandler
    implements MetaHandler {
        private final String myName;

        public TagMetaHandler(String name) {
            this.myName = name;
        }

        @Override
        public boolean isAcceptableMetaData(PsiMetaData metaData, String url) {
            if (metaData instanceof XmlNSDescriptorImpl) {
                XmlNSDescriptorImpl nsDescriptor = (XmlNSDescriptorImpl)metaData;
                XmlElementDescriptor descriptor = nsDescriptor.getElementDescriptor(this.searchFor(), url);
                return descriptor != null && !(descriptor instanceof AnyXmlElementDescriptor);
            }
            return false;
        }

        @Override
        public String searchFor() {
            return this.myName;
        }
    }

    public static interface MetaHandler {
        public boolean isAcceptableMetaData(PsiMetaData var1, String var2);

        public String searchFor();
    }

    public static interface StringToAttributeProcessor {
        public void doSomethingWithGivenStringToProduceXmlAttributeNowPlease(@NonNls @NotNull String var1) throws IncorrectOperationException;
    }
}

