/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MdnDocumentationUtil {
    private static final Logger LOG = Logger.getInstance(MdnDocumentationUtil.class);
    private static final String[] HTTP_PREFIXES = new String[]{"http://", "https://"};
    private static final List<String> VISIBLE_BROWSERS = Arrays.asList("chrome", "chrome_android", "edge", "firefox", "ie", "opera", "safari", "safari_ios");

    @NotNull
    private static String getFormattedCompatibilityData(@Nullable Map data) {
        Map support;
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null && (support = (Map)((Map)compat).get("support")) != null) {
            boolean everywhere = true;
            LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
            for (Object key : support.keySet()) {
                String browserId = key.toString();
                if (!VISIBLE_BROWSERS.contains(browserId)) continue;
                Object browserInfos = support.get(key);
                Map browserInfo = (Map)(browserInfos instanceof ArrayList ? ((ArrayList)browserInfos).get(0) : browserInfos);
                Object versionAdded = browserInfo.get("version_added");
                String version = versionAdded != null ? versionAdded.toString() : "";
                everywhere &= MdnDocumentationUtil.anyVersion(browserId, version);
                if (StringUtil.isEmpty((String)version) || "false".equals(version)) continue;
                versions.put(browserId, version);
            }
            if (everywhere) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (Map.Entry entry : versions.entrySet()) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(MdnDocumentationUtil.getReadableBrowserName((String)entry.getKey()));
                String version = (String)entry.getValue();
                if (MdnDocumentationUtil.anyVersion((String)entry.getKey(), version)) continue;
                result.append(" ").append(version);
            }
            String string = result.toString();
            if (string == null) {
                MdnDocumentationUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        return "";
    }

    private static boolean anyVersion(String browser, String version) {
        if (browser.startsWith("edge") && "12".equals(version)) {
            return true;
        }
        if (browser.equals("firefox_android") && "4".equals(version)) {
            return true;
        }
        if (browser.equals("chrome_android") && "18".equals(version)) {
            return true;
        }
        return "true".equals(version) || "1".equals(version);
    }

    private static String getReadableBrowserName(String key) {
        if ("webview_android".equals(key)) {
            return "Android WebView";
        }
        if ("safari_ios".equals(key)) {
            return "Safari iOS";
        }
        if ("ie".equals(key)) {
            return "IE";
        }
        if ("samsunginternet_android".equals(key)) {
            return "Samsung Internet";
        }
        return StringUtil.capitalizeWords((String)key.replace('_', ' '), (boolean)true);
    }

    @Nullable
    public static String getMdnUrl(@Nullable Map data) {
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null) {
            Object mdnUrl = ((Map)compat).get("mdn_url");
            return mdnUrl != null ? mdnUrl.toString() : null;
        }
        return null;
    }

    public static boolean isDeprecated(@Nullable Map data) {
        Object status;
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null && (status = ((Map)compat).get("status")) != null) {
            return "true".equals(((Map)status).get("deprecated").toString());
        }
        return false;
    }

    @Nullable
    public static String fetchExternalDocumentation(List<String> docUrls, Supplier<String> defaultDocProducer) {
        block12: {
            Object url = null;
            for (String urlCandidate : docUrls) {
                if (!urlCandidate.contains("developer.mozilla.org")) continue;
                url = urlCandidate;
            }
            if (url == null || ((String)url).contains("#attr-")) {
                return null;
            }
            File targetDir = PathManager.getConfigDir().resolve("mdn").toFile();
            url = (String)url + "/index.json";
            File targetFile = new File(targetDir, MdnDocumentationUtil.makeUniqueFileName((String)url));
            try {
                String jsonContent;
                String text;
                block13: {
                    text = defaultDocProducer.get();
                    if (text != null && text.contains("<div class='content'>")) break block12;
                    if (!targetFile.exists() || targetFile.lastModified() < System.currentTimeMillis() + 2592000000L) {
                        try {
                            DownloadUtil.downloadAtomically((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (String)url, (File)targetFile);
                        }
                        catch (IOException e) {
                            if (targetFile.exists()) break block13;
                            Throwable cause = e.getCause();
                            if (!(cause instanceof HttpRequests.HttpStatusException)) {
                                throw e;
                            }
                            if (((HttpRequests.HttpStatusException)cause).getStatusCode() != 404) {
                                throw e;
                            }
                            LOG.warn("Mdn broken url: " + (String)url);
                            if (targetFile.createNewFile()) break block13;
                            throw e;
                        }
                    }
                }
                if ((jsonContent = FileUtil.loadFile((File)targetFile, (Charset)StandardCharsets.UTF_8)).isEmpty()) {
                    return null;
                }
                String mdnDecorated = MdnDocumentationUtil.extractAndDecorateSummary(jsonContent, (String)url);
                if (text == null) {
                    return mdnDecorated;
                }
                int definitionEnd = text.indexOf("</pre></div>");
                assert (definitionEnd > 0);
                return text.substring(0, definitionEnd += "</pre></div>".length()) + "<div class='content'>" + mdnDecorated + "</div>" + (definitionEnd < text.length() ? text.substring(definitionEnd) : "");
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private static String extractAndDecorateSummary(@NotNull String jsonContent, String url) {
        if (jsonContent == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(1);
        }
        JsonReader reader = new JsonReader((Reader)new StringReader(jsonContent));
        reader.setLenient(true);
        return ((StreamEx)((StreamEx)StreamEx.of((Object)JsonParser.parseReader((JsonReader)reader)).select(JsonObject.class).map(obj -> obj.get("doc")).select(JsonObject.class).map(obj -> obj.get("body")).select(JsonArray.class).flatMap(arr -> StreamEx.of((Spliterator)arr.spliterator())).select(JsonObject.class).filter(entry -> {
            JsonPrimitive type = (JsonPrimitive)ObjectUtils.tryCast((Object)entry.get("type"), JsonPrimitive.class);
            return type != null && type.isString() && type.getAsString().equals("prose");
        })).map(entry -> entry.get("value")).select(JsonObject.class).map(entry -> entry.get("content")).select(JsonPrimitive.class).filter(JsonPrimitive::isString)).map(JsonPrimitive::getAsString).map(MdnDocumentationUtil::fixSummary).map(MdnDocumentationUtil::fixLinks).map(summary -> MdnDocumentationUtil.decorate(summary, url)).findFirst().orElse(null);
    }

    @NotNull
    private static String fixSummary(@NotNull String summary) {
        if (summary == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(2);
        }
        String string = summary.replaceAll("<iframe.*</iframe>|<p[^<>]*class=['\"]hidden['\"].*</p>|<div[^<>]*class=['\"]hidden['\"].*</div>", "").replaceAll("<table[^<>]*class=['\"]properties['\"]>", "<table class=\"sections\">").replaceAll("<td>(.*)</td>", "<td valign='top'>$1</td>").replaceAll("<th scope=['\"]row['\"]>(.*)</th>", "<td valign='top' class='section'><p>$1</td>").replaceAll("&apos;", "'");
        if (string == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String decorate(String mdnDoc, String url) {
        return mdnDoc + "<div style='padding-top: 5px'>By <a href='" + url + "$history'>Mozilla Contributors</a>, <a href='http://creativecommons.org/licenses/by-sa/2.5/'>CC BY-SA 2.5</a></div>";
    }

    private static String fixLinks(String s) {
        return s.replaceAll("href=\"/", "href=\"https://developer.mozilla.org/");
    }

    private static String makeUniqueFileName(String filePath) {
        String path = filePath;
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            path = filePath.replace(prefix, "http_");
            break;
        }
        return path.replace('/', '_').replace('\\', '_').replace(':', '_');
    }

    @NotNull
    public static String buildDoc(@NotNull String name, @NotNull String description, @Nullable Map mdnCompatData) {
        if (name == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(4);
        }
        if (description == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(5);
        }
        return MdnDocumentationUtil.buildDoc(name, description, mdnCompatData, null);
    }

    @NotNull
    public static String buildDoc(@NotNull String name, @NotNull String description, @Nullable Map mdnCompatData, @Nullable List<? extends Couple<String>> additionalData) {
        if (name == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(6);
        }
        if (description == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(7);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<div class='definition'><pre>").append(name).append("</pre></div>");
        buf.append("<div class='content'>");
        buf.append(StringUtil.capitalize((String)description));
        buf.append("</div>");
        String compatibilityData = MdnDocumentationUtil.getFormattedCompatibilityData(mdnCompatData);
        boolean deprecated = MdnDocumentationUtil.isDeprecated(mdnCompatData);
        if (deprecated || !compatibilityData.isEmpty() || !ContainerUtil.isEmpty(additionalData)) {
            buf.append("<table class='sections'>");
        }
        if (!ContainerUtil.isEmpty(additionalData)) {
            for (Couple<String> couple : additionalData) {
                buf.append("<tr><td valign='top' class='section'><p>").append((String)couple.first);
                buf.append("</td><td valign='top'>").append((String)couple.second);
                buf.append("</td>");
            }
        }
        if (deprecated) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Deprecated");
            buf.append("</td>");
        }
        if (!compatibilityData.isEmpty()) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Supported by:");
            buf.append("</td><td valign='top'>").append(compatibilityData);
            buf.append("</td>");
        }
        if (deprecated || !compatibilityData.isEmpty() || !ContainerUtil.isEmpty(additionalData)) {
            buf.append("</table>");
        }
        String string = buf.toString();
        if (string == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/documentation/MdnDocumentationUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonContent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattedCompatibilityData";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/documentation/MdnDocumentationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fixSummary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDoc";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractAndDecorateSummary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixSummary";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildDoc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

