/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;

public interface WithEstimatedSize {
    public int estimatedSize();

    public static class Estimates {
        public static <T> int estimateSizeOf(Collection<T> collection2) {
            if (Estimates.isKnownToHaveConstantTimeSizeMethod(collection2)) {
                return collection2.size();
            }
            if (collection2 instanceof WithEstimatedSize) {
                return ((WithEstimatedSize)((Object)collection2)).estimatedSize();
            }
            return 10;
        }

        public static <T> boolean isKnownToHaveConstantTimeSizeMethod(Collection<T> collection2) {
            Class<?> clazz = collection2.getClass();
            return clazz == HashSet.class || clazz == ArrayList.class || clazz == LinkedList.class || clazz == TreeSet.class;
        }
    }
}

