/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.type;

import java.io.File;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.artifacts.type.DefaultArtifactTypeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.reflect.Instantiator;

public class DefaultArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final Instantiator instantiator;
    private final ImmutableAttributesFactory attributesFactory;
    private final CollectionCallbackActionDecorator callbackActionDecorator;
    private ArtifactTypeContainer artifactTypeDefinitions;

    public DefaultArtifactTypeRegistry(Instantiator instantiator, ImmutableAttributesFactory attributesFactory, CollectionCallbackActionDecorator callbackActionDecorator) {
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.callbackActionDecorator = callbackActionDecorator;
    }

    @Override
    public ArtifactTypeContainer create() {
        if (this.artifactTypeDefinitions == null) {
            this.artifactTypeDefinitions = this.instantiator.newInstance(DefaultArtifactTypeContainer.class, this.instantiator, this.attributesFactory, this.callbackActionDecorator);
        }
        return this.artifactTypeDefinitions;
    }

    @Override
    public ImmutableAttributes mapAttributesFor(File file) {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        if (file.isDirectory()) {
            attributes = this.attributesFactory.of(ArtifactAttributes.ARTIFACT_FORMAT, "directory");
        } else {
            String extension = Files.getFileExtension((String)file.getName());
            if (this.artifactTypeDefinitions != null) {
                attributes = this.applyForExtension(attributes, extension);
            }
            attributes = this.attributesFactory.concat(this.attributesFactory.of(ArtifactAttributes.ARTIFACT_FORMAT, extension), attributes);
        }
        return attributes;
    }

    @Override
    public ImmutableAttributes mapAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts) {
        if (this.artifactTypeDefinitions != null) {
            String extension = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateExtension = componentArtifactMetadata.getName().getExtension();
                if (extension == null) {
                    extension = candidateExtension;
                    continue;
                }
                if (extension.equals(candidateExtension)) continue;
                extension = null;
                break;
            }
            if (extension != null) {
                attributes = this.applyForExtension(attributes, extension);
            }
        }
        if (!attributes.contains(ArtifactAttributes.ARTIFACT_FORMAT)) {
            String format = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateFormat = componentArtifactMetadata.getName().getType();
                if (format == null) {
                    format = candidateFormat;
                    continue;
                }
                if (format.equals(candidateFormat)) continue;
                format = null;
                break;
            }
            if (format != null) {
                attributes = this.attributesFactory.concat(attributes.asImmutable(), ArtifactAttributes.ARTIFACT_FORMAT, format);
            }
        }
        return attributes;
    }

    private ImmutableAttributes applyForExtension(ImmutableAttributes attributes, String extension) {
        ArtifactTypeDefinition definition = (ArtifactTypeDefinition)this.artifactTypeDefinitions.findByName(extension);
        if (definition != null) {
            attributes = this.attributesFactory.concat(((AttributeContainerInternal)definition.getAttributes()).asImmutable(), attributes);
        }
        return attributes;
    }
}

