/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.AbstractClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;

public class DefaultClassLoaderScope
extends AbstractClassLoaderScope {
    public static final String STRICT_MODE_PROPERTY = "org.gradle.classloaderscope.strict";
    private final ClassLoaderScope parent;
    private boolean locked;
    protected ClassPath export = ClassPath.EMPTY;
    private List<ClassLoader> exportLoaders;
    private ClassPath local = ClassPath.EMPTY;
    private List<ClassLoader> ownLoaders;
    private MultiParentClassLoader exportingClassLoader;
    private MultiParentClassLoader localClassLoader;
    private ClassLoader effectiveLocalClassLoader;
    private ClassLoader effectiveExportClassLoader;

    public DefaultClassLoaderScope(ClassLoaderScopeIdentifier id, ClassLoaderScope parent, ClassLoaderCache classLoaderCache, ClassLoaderScopeRegistryListener listener) {
        super(id, classLoaderCache, listener);
        this.parent = parent;
        listener.childScopeCreated(parent.getId(), id);
    }

    private ClassLoader loader(ClassLoaderId id, ClassLoader parent, ClassPath classPath, @Nullable List<ClassLoader> additionalLoaders) {
        if (additionalLoaders == null) {
            return this.loader(id, parent, classPath);
        }
        return new CachingClassLoader(this.multiLoader(id, parent, classPath, additionalLoaders));
    }

    private MultiParentClassLoader multiLoader(ClassLoaderId id, ClassLoader parent, ClassPath classPath, @Nullable List<ClassLoader> additionalLoaders) {
        int numParents = 1;
        if (additionalLoaders != null) {
            numParents += additionalLoaders.size();
        }
        if (!classPath.isEmpty()) {
            ++numParents;
        }
        ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>(numParents);
        parents.add(parent);
        if (additionalLoaders != null) {
            parents.addAll(additionalLoaders);
        }
        if (!classPath.isEmpty()) {
            parents.add(this.loader(id, parent, classPath));
        }
        return new MultiParentClassLoader(parents);
    }

    private ClassLoader localLoader(ClassLoaderId classLoaderId, ClassLoader parent, ClassPath classPath) {
        return this.loader(classLoaderId, parent, classPath);
    }

    private void buildEffectiveLoaders() {
        if (this.effectiveLocalClassLoader == null) {
            boolean hasLocals;
            boolean hasExports = !this.export.isEmpty() || this.exportLoaders != null;
            boolean bl = hasLocals = !this.local.isEmpty();
            if (this.locked) {
                if (hasExports && hasLocals) {
                    this.effectiveExportClassLoader = this.loader(this.id.exportId(), this.parent.getExportClassLoader(), this.export, this.exportLoaders);
                    this.effectiveLocalClassLoader = this.localLoader(this.id.localId(), this.effectiveExportClassLoader, this.local);
                } else if (hasLocals) {
                    this.classLoaderCache.remove(this.id.exportId());
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                    this.effectiveLocalClassLoader = this.localLoader(this.id.localId(), this.effectiveExportClassLoader, this.local);
                } else if (hasExports) {
                    this.classLoaderCache.remove(this.id.localId());
                    this.effectiveLocalClassLoader = this.effectiveExportClassLoader = this.loader(this.id.exportId(), this.parent.getExportClassLoader(), this.export, this.exportLoaders);
                } else {
                    this.classLoaderCache.remove(this.id.localId());
                    this.classLoaderCache.remove(this.id.exportId());
                    this.effectiveLocalClassLoader = this.parent.getExportClassLoader();
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                }
            } else {
                if (Boolean.getBoolean(STRICT_MODE_PROPERTY)) {
                    throw new IllegalStateException("Attempt to define scope class loader before scope is locked, scope identifier is " + this.id);
                }
                this.exportingClassLoader = this.multiLoader(this.id.exportId(), this.parent.getExportClassLoader(), this.export, this.exportLoaders);
                this.effectiveExportClassLoader = new CachingClassLoader(this.exportingClassLoader);
                this.localClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.loader(this.id.localId(), this.effectiveExportClassLoader, this.local)});
                this.effectiveLocalClassLoader = new CachingClassLoader(this.localClassLoader);
            }
            this.exportLoaders = null;
        }
    }

    @Override
    public ClassLoader getExportClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveExportClassLoader;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveLocalClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this.parent;
    }

    @Override
    public boolean defines(Class<?> clazz) {
        if (this.ownLoaders != null) {
            for (ClassLoader ownLoader : this.ownLoaders) {
                if (!ownLoader.equals(clazz.getClassLoader())) continue;
                return true;
            }
        }
        return false;
    }

    protected ClassLoader loader(ClassLoaderId classLoaderId, ClassLoader parent, ClassPath classPath) {
        if (classPath.isEmpty()) {
            return parent;
        }
        ClassLoader classLoader = this.classLoaderCache.get(classLoaderId, classPath, parent, null);
        this.listener.classloaderCreated(this.id, classLoaderId, classLoader, classPath, null);
        if (this.ownLoaders == null) {
            this.ownLoaders = new ArrayList<ClassLoader>();
        }
        this.ownLoaders.add(classLoader);
        return classLoader;
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.localClassLoader != null) {
            ClassLoader loader = this.loader(this.id.localId(), this.effectiveExportClassLoader, classPath);
            this.localClassLoader.addParent(loader);
        } else {
            this.local = this.local.plus(classPath);
        }
        return this;
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.exportingClassLoader != null) {
            this.exportingClassLoader.addParent(this.loader(this.id.exportId(), this.parent.getExportClassLoader(), classPath));
        } else {
            this.export = this.export.plus(classPath);
        }
        return this;
    }

    @Override
    public ClassLoaderScope export(ClassLoader classLoader) {
        this.assertNotLocked();
        if (this.exportingClassLoader != null) {
            this.exportingClassLoader.addParent(classLoader);
        } else {
            if (this.exportLoaders == null) {
                this.exportLoaders = new ArrayList<ClassLoader>(1);
            }
            this.exportLoaders.add(classLoader);
        }
        return this;
    }

    private void assertNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("class loader scope is locked, scope identifier is " + this.id);
        }
    }

    @Override
    public ClassLoaderScope lock() {
        this.locked = true;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void onReuse() {
        this.parent.onReuse();
        this.listener.childScopeCreated(this.parent.getId(), this.id);
        if (!this.export.isEmpty()) {
            this.listener.classloaderCreated(this.id, this.id.exportId(), this.effectiveExportClassLoader, this.export, null);
        }
        if (!this.local.isEmpty()) {
            this.listener.classloaderCreated(this.id, this.id.localId(), this.effectiveLocalClassLoader, this.export, null);
        }
    }
}

