/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.metadata.InvalidPublicationChecker;
import org.gradle.api.publish.internal.metadata.ModuleMetadataJsonWriter;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpec;
import org.gradle.api.publish.internal.metadata.ModuleMetadataSpecBuilder;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.impldep.com.google.gson.stream.JsonWriter;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;

public class GradleModuleMetadataWriter {
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final ChecksumService checksumService;

    public GradleModuleMetadataWriter(BuildInvocationScopeId buildInvocationScopeId, ProjectDependencyPublicationResolver projectDependencyResolver, ChecksumService checksumService) {
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.projectDependencyResolver = projectDependencyResolver;
        this.checksumService = checksumService;
    }

    public void writeTo(Writer writer, PublicationInternal<?> publication, Collection<? extends PublicationInternal<?>> publications) throws IOException {
        this.writeTo(writer, this.moduleMetadataSpecFor(publication, publications));
    }

    public void writeTo(Writer writer, ModuleMetadataSpec metadata) throws IOException {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setIndent("  ");
        new ModuleMetadataJsonWriter(jsonWriter, metadata, metadata.mustIncludeBuildId ? this.buildInvocationScopeId.getId().asString() : null, this.checksumService).write();
        jsonWriter.flush();
        writer.append('\n');
    }

    public ModuleMetadataSpec moduleMetadataSpecFor(PublicationInternal<?> publication, Collection<? extends PublicationInternal<?>> publications) {
        InvalidPublicationChecker checker = new InvalidPublicationChecker(publication.getName());
        ModuleMetadataSpec spec = new ModuleMetadataSpecBuilder(publication, publications, checker, this.projectDependencyResolver).build();
        checker.validate();
        return spec;
    }
}

