/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.BuildType;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.deployment.internal.DefaultDeploymentRegistry;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.BuildOptionBuildOperationProgressEventsEmitter;
import org.gradle.initialization.ConfigurationCache;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InternalBuildFinishedListener;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.BuildScopeListenerManagerAction;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.internal.time.Time;
import org.gradle.invocation.DefaultGradle;

public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry;
    private final CrossBuildSessionState crossBuildSessionState;
    private DefaultGradleLauncher rootBuild;

    public DefaultGradleLauncherFactory(GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry, CrossBuildSessionState crossBuildSessionState) {
        this.userHomeDirServiceRegistry = userHomeDirServiceRegistry;
        this.crossBuildSessionState = crossBuildSessionState;
    }

    @Override
    public GradleLauncher newInstance(BuildDefinition buildDefinition, RootBuildState build, BuildTreeState owner) {
        DefaultGradleLauncher launcher;
        if (this.rootBuild != null) {
            throw new IllegalStateException("Cannot have a current root build");
        }
        this.rootBuild = launcher = this.doNewInstance(buildDefinition, build, null, owner, (List<?>)ImmutableList.of(() -> {
            this.rootBuild = null;
        }));
        final DefaultDeploymentRegistry deploymentRegistry = owner.getServices().get(DefaultDeploymentRegistry.class);
        launcher.getGradle().addBuildListener(new InternalBuildAdapter(){

            @Override
            public void buildFinished(BuildResult result) {
                deploymentRegistry.buildFinished(result);
            }
        });
        return launcher;
    }

    private DefaultGradleLauncher doNewInstance(BuildDefinition buildDefinition, BuildState owner, @Nullable GradleLauncher parent, BuildTreeState buildTree, List<?> servicesToStop) {
        BuildScopeServices serviceRegistry = new BuildScopeServices(buildTree.getServices());
        serviceRegistry.add(BuildDefinition.class, buildDefinition);
        serviceRegistry.add(BuildState.class, owner);
        NestedBuildFactoryImpl nestedBuildFactory = new NestedBuildFactoryImpl(buildTree);
        serviceRegistry.add(NestedBuildFactory.class, nestedBuildFactory);
        ListenerManager listenerManager = serviceRegistry.get(ListenerManager.class);
        for (Action action : serviceRegistry.getAll(BuildScopeListenerManagerAction.class)) {
            action.execute(listenerManager);
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener(usageLocationReporter);
        StartParameter startParameter = buildDefinition.getStartParameter();
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(false);
            }
        }
        DeprecationLogger.init(usageLocationReporter, startParameter.getWarningMode(), serviceRegistry.get(BuildOperationProgressEventEmitter.class));
        GradleInternal parentBuild = parent == null ? null : parent.getGradle();
        SettingsPreparer settingsPreparer = serviceRegistry.get(SettingsPreparer.class);
        GradleInternal gradle = serviceRegistry.get(Instantiator.class).newInstance(DefaultGradle.class, parentBuild, startParameter, serviceRegistry.get(ServiceRegistryFactory.class));
        IncludedBuildControllers includedBuildControllers = gradle.getServices().get(IncludedBuildControllers.class);
        TaskExecutionPreparer taskExecutionPreparer = gradle.getServices().get(TaskExecutionPreparer.class);
        DefaultGradleLauncher gradleLauncher = new DefaultGradleLauncher(gradle, serviceRegistry.get(ProjectsPreparer.class), serviceRegistry.get(ExceptionAnalyser.class), gradle.getBuildListenerBroadcaster(), listenerManager.getBroadcaster(BuildCompletionListener.class), listenerManager.getBroadcaster(InternalBuildFinishedListener.class), gradle.getServices().get(BuildWorkExecutor.class), serviceRegistry, servicesToStop, includedBuildControllers, settingsPreparer, taskExecutionPreparer, gradle.getServices().get(ConfigurationCache.class), new BuildOptionBuildOperationProgressEventsEmitter(gradle.getServices().get(BuildOperationProgressEventEmitter.class)));
        nestedBuildFactory.setParent(gradleLauncher);
        nestedBuildFactory.setBuildCancellationToken(buildTree.getServices().get(BuildCancellationToken.class));
        return gradleLauncher;
    }

    private class NestedBuildFactoryImpl
    implements NestedBuildFactory {
        private final BuildTreeState buildTree;
        private DefaultGradleLauncher parent;
        private BuildCancellationToken buildCancellationToken;

        NestedBuildFactoryImpl(BuildTreeState buildTree) {
            this.buildTree = buildTree;
        }

        @Override
        public GradleLauncher nestedInstance(BuildDefinition buildDefinition, NestedBuildState build) {
            return DefaultGradleLauncherFactory.this.doNewInstance(buildDefinition, build, this.parent, this.buildTree, (List)ImmutableList.of());
        }

        @Override
        public GradleLauncher nestedBuildTree(BuildDefinition buildDefinition, NestedRootBuild build) {
            StartParameter startParameter = buildDefinition.getStartParameter();
            DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
            BuildSessionState buildSessionState = new BuildSessionState(DefaultGradleLauncherFactory.this.userHomeDirServiceRegistry, DefaultGradleLauncherFactory.this.crossBuildSessionState, startParameter, buildRequestMetaData, ClassPath.EMPTY, this.buildCancellationToken, buildRequestMetaData.getClient(), new NoOpBuildEventConsumer());
            BuildTreeState nestedBuildTree = new BuildTreeState(buildSessionState.getServices(), BuildType.TASKS);
            return DefaultGradleLauncherFactory.this.doNewInstance(buildDefinition, build, this.parent, nestedBuildTree, (List)ImmutableList.of((Object)nestedBuildTree, (Object)buildSessionState));
        }

        private void setParent(DefaultGradleLauncher parent) {
            this.parent = parent;
        }

        private void setBuildCancellationToken(BuildCancellationToken buildCancellationToken) {
            this.buildCancellationToken = buildCancellationToken;
        }
    }
}

