/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Collection;
import java.util.Map;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultFileCollectionFingerprinterRegistry
implements FileCollectionFingerprinterRegistry {
    private final Map<Class<? extends FileNormalizer>, FileCollectionFingerprinter> fingerprinters;

    public DefaultFileCollectionFingerprinterRegistry(Collection<FileCollectionFingerprinter> fingerprinters) {
        this.fingerprinters = ImmutableMap.copyOf((Map)Maps.uniqueIndex(fingerprinters, (Function)new Function<FileCollectionFingerprinter, Class<? extends FileNormalizer>>(){

            public Class<? extends FileNormalizer> apply(FileCollectionFingerprinter fingerprinter) {
                return fingerprinter.getRegisteredType();
            }
        }));
    }

    @Override
    public FileCollectionFingerprinter getFingerprinter(Class<? extends FileNormalizer> type) {
        FileCollectionFingerprinter fingerprinter = this.fingerprinters.get(type);
        if (fingerprinter == null) {
            throw new IllegalStateException(String.format("No fingerprinter registered with type '%s'", type.getName()));
        }
        return fingerprinter;
    }
}

