/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.overlap.impl;

import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.overlap.OverlappingOutputDetector;
import org.gradle.internal.fingerprint.overlap.OverlappingOutputs;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;

public class DefaultOverlappingOutputDetector
implements OverlappingOutputDetector {
    @Override
    @Nullable
    public OverlappingOutputs detect(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        for (Map.Entry entry : current.entrySet()) {
            String propertyName = (String)entry.getKey();
            FileSystemSnapshot beforeExecution = (FileSystemSnapshot)entry.getValue();
            FileCollectionFingerprint afterPreviousExecution = DefaultOverlappingOutputDetector.getFingerprintAfterPreviousExecution(previous, propertyName);
            OverlappingOutputs overlappingOutputs = DefaultOverlappingOutputDetector.detect(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            return overlappingOutputs;
        }
        return null;
    }

    private static FileCollectionFingerprint getFingerprintAfterPreviousExecution(@Nullable ImmutableSortedMap<String, FileCollectionFingerprint> previous, String propertyName) {
        FileCollectionFingerprint afterPreviousExecution;
        if (previous != null && (afterPreviousExecution = (FileCollectionFingerprint)previous.get((Object)propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionFingerprint.EMPTY;
    }

    @Nullable
    private static OverlappingOutputs detect(String propertyName, FileCollectionFingerprint previous, FileSystemSnapshot before) {
        Map<String, FileSystemLocationFingerprint> previousFingerprints = previous.getFingerprints();
        OverlappingOutputsDetectingVisitor outputsDetectingVisitor = new OverlappingOutputsDetectingVisitor(previousFingerprints);
        before.accept(outputsDetectingVisitor);
        String overlappingPath = outputsDetectingVisitor.getOverlappingPath();
        return overlappingPath == null ? null : new OverlappingOutputs(propertyName, overlappingPath);
    }

    private static boolean changedSincePreviousExecution(HashCode contentHash, HashCode previousContentHash) {
        return !contentHash.equals(previousContentHash);
    }

    private static boolean createdSincePreviousExecution(@Nullable HashCode previousContentHash) {
        return previousContentHash == null;
    }

    private static class OverlappingOutputsDetectingVisitor
    implements FileSystemSnapshotVisitor {
        private final Map<String, FileSystemLocationFingerprint> previousFingerprints;
        private int treeDepth = 0;
        private String overlappingPath;

        public OverlappingOutputsDetectingVisitor(Map<String, FileSystemLocationFingerprint> previousFingerprints) {
            this.previousFingerprints = previousFingerprints;
        }

        @Override
        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            ++this.treeDepth;
            if (this.overlappingPath == null) {
                this.overlappingPath = this.detectOverlappingPath(directorySnapshot);
            }
            return this.overlappingPath == null;
        }

        @Override
        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
            if (this.overlappingPath == null) {
                this.overlappingPath = this.detectOverlappingPath(fileSnapshot);
            }
        }

        @Override
        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            --this.treeDepth;
        }

        @Nullable
        private String detectOverlappingPath(CompleteFileSystemLocationSnapshot beforeSnapshot) {
            HashCode previousContentHash;
            String path = beforeSnapshot.getAbsolutePath();
            HashCode contentHash = beforeSnapshot.getHash();
            FileSystemLocationFingerprint previousFingerprint = this.previousFingerprints.get(path);
            HashCode hashCode = previousContentHash = previousFingerprint == null ? null : previousFingerprint.getNormalizedContentHash();
            if ((!this.isRoot() || beforeSnapshot.getType() != FileType.Missing) && (DefaultOverlappingOutputDetector.createdSincePreviousExecution(previousContentHash) || beforeSnapshot.getType() != previousFingerprint.getType() || beforeSnapshot.getType() == FileType.RegularFile && DefaultOverlappingOutputDetector.changedSincePreviousExecution(contentHash, previousContentHash))) {
                return path;
            }
            return null;
        }

        private boolean isRoot() {
            return this.treeDepth == 0;
        }

        @Nullable
        public String getOverlappingPath() {
            return this.overlappingPath;
        }
    }
}

