/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.io.NullOutputStream;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.process.internal.ExecHandleBuilder;
import org.gradle.process.internal.ExecHandleFactory;

public class DefaultJvmVersionDetector
implements JvmVersionDetector {
    private final ExecHandleFactory execHandleFactory;

    public DefaultJvmVersionDetector(ExecHandleFactory execHandleFactory) {
        this.execHandleFactory = execHandleFactory;
    }

    @Override
    public JavaVersion getJavaVersion(JavaInfo jvm) {
        return this.getJavaVersion(jvm.getJavaExecutable().getPath());
    }

    @Override
    public JavaVersion getJavaVersion(String javaCommand) {
        StreamByteBuffer buffer = new StreamByteBuffer();
        ExecHandleBuilder builder = this.execHandleFactory.newExec();
        builder.setWorkingDir(new File(".").getAbsolutePath());
        builder.setCommandLine(javaCommand, "-version");
        builder.setStandardOutput(NullOutputStream.INSTANCE);
        builder.setErrorOutput(buffer.getOutputStream());
        builder.build().start().waitForFinish().assertNormalExitValue();
        return this.parseJavaVersionCommandOutput(javaCommand, new BufferedReader(new InputStreamReader(buffer.getInputStream())));
    }

    private JavaVersion parseJavaVersionCommandOutput(String javaExecutable, BufferedReader reader) {
        try {
            String versionStr = reader.readLine();
            while (versionStr != null) {
                Matcher matcher = Pattern.compile("(?:java|openjdk) version \"(.+?)\"( \\d{4}-\\d{2}-\\d{2}( LTS)?)?").matcher(versionStr);
                if (matcher.matches()) {
                    return JavaVersion.toVersion(matcher.group(1));
                }
                versionStr = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new GradleException(String.format("Could not determine Java version using executable %s.", javaExecutable));
    }
}

