/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.slf4j;

import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;
import org.gradle.internal.logging.slf4j.BuildOperationAwareLogger;
import org.gradle.internal.logging.slf4j.ContextAwareTaskLogger;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class DefaultContextAwareTaskLogger
implements ContextAwareTaskLogger {
    private BuildOperationAwareLogger delegate;
    private OperationIdentifier fallbackOperationIdentifier = null;

    public DefaultContextAwareTaskLogger(Logger delegate) {
        this.delegate = Cast.cast(BuildOperationAwareLogger.class, delegate);
    }

    @Override
    public void setFallbackBuildOperationId(OperationIdentifier operationIdentifier) {
        this.fallbackOperationIdentifier = operationIdentifier;
    }

    @Override
    public boolean isLifecycleEnabled() {
        return this.delegate.isLifecycleEnabled();
    }

    @Override
    public boolean isQuietEnabled() {
        return this.delegate.isQuietEnabled();
    }

    @Override
    public boolean isEnabled(LogLevel level) {
        return this.delegate.isEnabled(level);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    public void trace(String msg) {
    }

    public void trace(String format, Object arg) {
    }

    public void trace(String format, Object arg1, Object arg2) {
    }

    public void trace(String format, Object ... arguments) {
    }

    public void trace(String msg, Throwable t) {
    }

    public void trace(Marker marker, String msg) {
    }

    public void trace(Marker marker, String format, Object arg) {
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
    }

    public void trace(Marker marker, String format, Object ... argArray) {
    }

    public void trace(Marker marker, String msg, Throwable t) {
    }

    private void log(LogLevel logLevel, Throwable throwable, String message2) {
        OperationIdentifier buildOperationId = CurrentBuildOperationRef.instance().getId();
        if (buildOperationId == null) {
            buildOperationId = this.fallbackOperationIdentifier;
        }
        this.delegate.log(logLevel, throwable, message2, buildOperationId);
    }

    private void log(LogLevel logLevel, Throwable throwable, String format, Object arg) {
        this.log(logLevel, throwable, format, new Object[]{arg});
    }

    private void log(LogLevel logLevel, Throwable throwable, String format, Object arg1, Object arg2) {
        this.log(logLevel, throwable, format, new Object[]{arg1, arg2});
    }

    private void log(LogLevel logLevel, Throwable throwable, String format, Object[] args) {
        FormattingTuple tuple = MessageFormatter.arrayFormat((String)format, (Object[])args);
        Throwable loggedThrowable = throwable == null ? tuple.getThrowable() : throwable;
        this.log(logLevel, loggedThrowable, tuple.getMessage());
    }

    public void debug(String message2) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, null, message2);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, null, format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, null, format, arg1, arg2);
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, (Throwable)null, format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log(LogLevel.DEBUG, t, msg);
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, null, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, null, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, null, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... argArray) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, (Throwable)null, format, argArray);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            this.log(LogLevel.DEBUG, t, msg);
        }
    }

    public void info(String message2) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, null, message2);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, null, format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, null, format, arg1, arg2);
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, (Throwable)null, format, arguments);
        }
    }

    @Override
    public void lifecycle(String message2) {
        if (this.isLifecycleEnabled()) {
            this.log(LogLevel.LIFECYCLE, null, message2);
        }
    }

    @Override
    public void lifecycle(String message2, Object ... objects) {
        if (this.isLifecycleEnabled()) {
            this.log(LogLevel.LIFECYCLE, (Throwable)null, message2, objects);
        }
    }

    @Override
    public void lifecycle(String message2, Throwable throwable) {
        if (this.isLifecycleEnabled()) {
            this.log(LogLevel.LIFECYCLE, throwable, message2);
        }
    }

    @Override
    public void quiet(String message2) {
        if (this.isQuietEnabled()) {
            this.log(LogLevel.QUIET, null, message2);
        }
    }

    @Override
    public void quiet(String message2, Object ... objects) {
        if (this.isQuietEnabled()) {
            this.log(LogLevel.QUIET, (Throwable)null, message2, objects);
        }
    }

    @Override
    public void quiet(String message2, Throwable throwable) {
        if (this.isQuietEnabled()) {
            this.log(LogLevel.QUIET, throwable, message2);
        }
    }

    @Override
    public void log(LogLevel level, String message2) {
        if (this.isEnabled(level)) {
            this.log(level, null, message2);
        }
    }

    @Override
    public void log(LogLevel level, String message2, Object ... objects) {
        if (this.isEnabled(level)) {
            this.log(level, (Throwable)null, message2, objects);
        }
    }

    @Override
    public void log(LogLevel level, String message2, Throwable throwable) {
        if (this.isEnabled(level)) {
            this.log(level, throwable, message2);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(LogLevel.INFO, t, msg);
        }
    }

    private LogLevel toLogLevel(Marker marker) {
        if (marker == null) {
            return LogLevel.INFO;
        }
        if (marker == Logging.LIFECYCLE) {
            return LogLevel.LIFECYCLE;
        }
        if (marker == Logging.QUIET) {
            return LogLevel.QUIET;
        }
        return LogLevel.INFO;
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            this.log(this.toLogLevel(marker), null, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            this.log(this.toLogLevel(marker), null, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            this.log(this.toLogLevel(marker), null, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... argArray) {
        if (this.isInfoEnabled(marker)) {
            this.log(this.toLogLevel(marker), (Throwable)null, format, argArray);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            this.log(this.toLogLevel(marker), t, msg);
        }
    }

    public void warn(String message2) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, null, message2);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, null, format, arg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, null, format, arg1, arg2);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, (Throwable)null, format, arguments);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(LogLevel.WARN, t, msg);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, null, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, null, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, null, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... argArray) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, (Throwable)null, format, argArray);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            this.log(LogLevel.WARN, t, msg);
        }
    }

    public void error(String message2) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, null, message2);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, null, format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, null, format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, (Throwable)null, format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(LogLevel.ERROR, t, msg);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, null, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, null, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, null, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... argArray) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, (Throwable)null, format, argArray);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            this.log(LogLevel.ERROR, t, msg);
        }
    }
}

