/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scopeids;

import java.io.File;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.Factory;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.scopeids.PersistentScopeIdLoader;
import org.gradle.internal.scopeids.PersistentScopeIdStoreFactory;
import org.gradle.internal.scopeids.id.UserScopeId;
import org.gradle.internal.scopeids.id.WorkspaceScopeId;

class DefaultPersistentScopeIdLoader
implements PersistentScopeIdLoader {
    private static final String USER_ID_FILENAME = "user-id.txt";
    private static final String WORKSPACE_ID_FILENAME = "workspace-id.txt";
    private final ProjectCacheDir projectCacheDir;
    private final CacheScopeMapping cacheScopeMapping;
    private final Factory<UniqueId> generator;
    private final PersistentScopeIdStoreFactory storeFactory;

    DefaultPersistentScopeIdLoader(ProjectCacheDir projectCacheDir, CacheScopeMapping cacheScopeMapping, PersistentScopeIdStoreFactory storeFactory, Factory<UniqueId> generator) {
        this.projectCacheDir = projectCacheDir;
        this.cacheScopeMapping = cacheScopeMapping;
        this.generator = generator;
        this.storeFactory = storeFactory;
    }

    @Override
    public UserScopeId getUser() {
        UniqueId uniqueId = this.get(new ScopeParams(this.userScopeCacheScopeMarker(), USER_ID_FILENAME, "User ID"));
        return new UserScopeId(uniqueId);
    }

    @Override
    public WorkspaceScopeId getWorkspace() {
        UniqueId uniqueId = this.get(new ScopeParams(this.workspaceScopeCacheScopeMarker(), WORKSPACE_ID_FILENAME, "Workspace ID"));
        return new WorkspaceScopeId(uniqueId);
    }

    private Object userScopeCacheScopeMarker() {
        return null;
    }

    private File workspaceScopeCacheScopeMarker() {
        return this.projectCacheDir.getDir();
    }

    private UniqueId get(ScopeParams params) {
        PersistentStateCache<UniqueId> store = this.store(params);
        return store.maybeUpdate(new PersistentStateCache.UpdateAction<UniqueId>(){

            @Override
            public UniqueId update(UniqueId oldValue) {
                if (oldValue == null) {
                    return (UniqueId)DefaultPersistentScopeIdLoader.this.generator.create();
                }
                return oldValue;
            }
        });
    }

    private PersistentStateCache<UniqueId> store(ScopeParams params) {
        File file = this.cacheScopeMapping.getBaseDirectory(params.cacheScopeMarker, params.fileName, VersionStrategy.SharedCache);
        return this.storeFactory.create(file, params.description);
    }

    private static class ScopeParams {
        private final Object cacheScopeMarker;
        private final String fileName;
        private final String description;

        private ScopeParams(Object cacheScopeMarker, String fileName, String description) {
            this.cacheScopeMarker = cacheScopeMarker;
            this.fileName = fileName;
            this.description = description;
        }
    }
}

