/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;
import org.gradle.internal.snapshot.SnapshottingFilter;

public class FileSystemSnapshotFilter {
    private FileSystemSnapshotFilter() {
    }

    public static FileSystemSnapshot filterSnapshot(SnapshottingFilter.FileSystemSnapshotPredicate predicate, FileSystemSnapshot unfiltered) {
        MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        AtomicBoolean hasBeenFiltered = new AtomicBoolean(false);
        unfiltered.accept(new FilteringVisitor(predicate, builder, hasBeenFiltered));
        if (builder.getResult() == null) {
            return FileSystemSnapshot.EMPTY;
        }
        return hasBeenFiltered.get() ? builder.getResult() : unfiltered;
    }

    private static class FilteringVisitor
    implements FileSystemSnapshotVisitor {
        private final RelativePathSegmentsTracker relativePathTracker;
        private final SnapshottingFilter.FileSystemSnapshotPredicate predicate;
        private final FileSystemSnapshotVisitor delegate;
        private final AtomicBoolean hasBeenFiltered;

        public FilteringVisitor(SnapshottingFilter.FileSystemSnapshotPredicate predicate, FileSystemSnapshotVisitor delegate, AtomicBoolean hasBeenFiltered) {
            this.predicate = predicate;
            this.delegate = delegate;
            this.hasBeenFiltered = hasBeenFiltered;
            this.relativePathTracker = new RelativePathSegmentsTracker();
        }

        @Override
        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            boolean root = this.relativePathTracker.isRoot();
            this.relativePathTracker.enter(directorySnapshot);
            if (root || this.predicate.test(directorySnapshot, this.relativePathTracker.getRelativePath())) {
                this.delegate.preVisitDirectory(directorySnapshot);
                return true;
            }
            this.hasBeenFiltered.set(true);
            this.relativePathTracker.leave();
            return false;
        }

        @Override
        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
            Object relativePathForFiltering;
            boolean root = this.relativePathTracker.isRoot();
            this.relativePathTracker.enter(fileSnapshot);
            Object object = relativePathForFiltering = root ? ImmutableList.of((Object)fileSnapshot.getName()) : this.relativePathTracker.getRelativePath();
            if (this.predicate.test(fileSnapshot, (Iterable<String>)relativePathForFiltering)) {
                this.delegate.visitFile(fileSnapshot);
            } else {
                this.hasBeenFiltered.set(true);
            }
            this.relativePathTracker.leave();
        }

        @Override
        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            this.relativePathTracker.leave();
            this.delegate.postVisitDirectory(directorySnapshot);
        }
    }
}

