/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.install.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdoptOpenJdkDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdoptOpenJdkDownloader.class);
    private final RepositoryTransportFactory repositoryTransportFactory;

    public AdoptOpenJdkDownloader(RepositoryTransportFactory repositoryTransportFactory) {
        this.repositoryTransportFactory = repositoryTransportFactory;
    }

    public void download(URI source, File tmpFile) {
        ExternalResource resource = this.getTransport(source).getRepository().withProgressLogging().resource(new ExternalResourceName(source));
        try {
            this.downloadResource(source, tmpFile, resource);
        }
        catch (MissingResourceException e) {
            throw new MissingResourceException(source, "Unable to download toolchain. This might indicate that the combination (version, architecture, release/early access, ...) for the requested JDK is not available.", e);
        }
    }

    private void downloadResource(URI source, File tmpFile, ExternalResource resource) {
        resource.withContent(inputStream -> {
            LOGGER.info("Downloading {} to {}", (Object)resource.getDisplayName(), (Object)tmpFile);
            this.copyIntoFile(source, (InputStream)inputStream, tmpFile);
        });
    }

    private void copyIntoFile(URI source, InputStream inputStream, File destination) {
        try (FileOutputStream outputStream = new FileOutputStream(destination);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed(source, e);
        }
    }

    private RepositoryTransport getTransport(URI source) {
        HttpRedirectVerifier redirectVerifier;
        try {
            redirectVerifier = HttpRedirectVerifierFactory.create(new URI(source.getScheme(), source.getAuthority(), null, null, null), false, () -> {
                throw new InvalidUserCodeException("Attempting to download a JDK from an insecure URI " + source + ". This is not supported, use a secure URI instead.");
            }, uri -> {
                throw new InvalidUserCodeException("Attempting to download a JDK from an insecure URI " + uri + ". This URI was reached as a redirect from " + source + ". This is not supported, make sure no insecure URIs appear in the redirect");
            });
        }
        catch (URISyntaxException e) {
            throw new InvalidUserCodeException("Cannot extract host information from specified URI " + source);
        }
        return this.repositoryTransportFactory.createTransport("https", "adoptopenjdk toolchains", Collections.emptyList(), redirectVerifier);
    }
}

