/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.internal.BuildDefinition;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.launcher.exec.BuildTreeBuildActionExecutor;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class InProcessBuildActionExecuter
implements BuildTreeBuildActionExecutor {
    private final BuildActionRunner buildActionRunner;
    private final BuildStateRegistry buildStateRegistry;
    private final PayloadSerializer payloadSerializer;
    private final BuildOperationNotificationValve buildOperationNotificationValve;
    private final BuildCancellationToken buildCancellationToken;

    public InProcessBuildActionExecuter(BuildStateRegistry buildStateRegistry, PayloadSerializer payloadSerializer, BuildOperationNotificationValve buildOperationNotificationValve, BuildCancellationToken buildCancellationToken, BuildActionRunner buildActionRunner) {
        this.buildActionRunner = buildActionRunner;
        this.buildStateRegistry = buildStateRegistry;
        this.payloadSerializer = payloadSerializer;
        this.buildOperationNotificationValve = buildOperationNotificationValve;
        this.buildCancellationToken = buildCancellationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildTreeContext buildTree) {
        this.buildOperationNotificationValve.start();
        try {
            RootBuildState rootBuild = this.buildStateRegistry.createRootBuild(BuildDefinition.fromStartParameter(action.getStartParameter(), null));
            BuildActionResult buildActionResult = rootBuild.run(buildController -> {
                BuildActionRunner.Result result = this.buildActionRunner.run(action, (BuildController)buildController);
                if (result.getBuildFailure() == null) {
                    return BuildActionResult.of(this.payloadSerializer.serialize(result.getClientResult()));
                }
                if (this.buildCancellationToken.isCancellationRequested()) {
                    return BuildActionResult.cancelled(this.payloadSerializer.serialize(result.getBuildFailure()));
                }
                return BuildActionResult.failed(this.payloadSerializer.serialize(result.getClientFailure()));
            });
            return buildActionResult;
        }
        finally {
            this.buildOperationNotificationValve.stop();
        }
    }
}

