/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.nativeplatform.StaticLibraryBinary;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.AbstractNativeLibraryBinarySpec;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.internal.BinaryTasksCollectionWrapper;

public class DefaultStaticLibraryBinarySpec
extends AbstractNativeLibraryBinarySpec
implements StaticLibraryBinary,
StaticLibraryBinarySpecInternal {
    private final List<FileCollection> additionalLinkFiles = new ArrayList<FileCollection>();
    private final DefaultTasksCollection tasks = new DefaultTasksCollection(super.getTasks());
    private File staticLibraryFile;

    @Override
    public File getStaticLibraryFile() {
        return this.staticLibraryFile;
    }

    @Override
    public void setStaticLibraryFile(File staticLibraryFile) {
        this.staticLibraryFile = staticLibraryFile;
    }

    @Override
    public File getPrimaryOutput() {
        return this.getStaticLibraryFile();
    }

    @Override
    public void additionalLinkFiles(FileCollection files2) {
        this.additionalLinkFiles.add(files2);
    }

    @Override
    public FileCollection getLinkFiles() {
        return this.getFileCollectionFactory().create(new StaticLibraryLinkOutputs());
    }

    @Override
    public FileCollection getRuntimeFiles() {
        return this.getFileCollectionFactory().empty("Runtime files for " + this.getDisplayName());
    }

    @Override
    protected ObjectFilesToBinary getCreateOrLink() {
        return this.tasks.getCreateStaticLib();
    }

    @Override
    public StaticLibraryBinarySpec.TasksCollection getTasks() {
        return this.tasks;
    }

    private class StaticLibraryLinkOutputs
    extends AbstractNativeLibraryBinarySpec.LibraryOutputs {
        private StaticLibraryLinkOutputs() {
        }

        @Override
        public String getDisplayName() {
            return "Link files for " + DefaultStaticLibraryBinarySpec.this.getDisplayName();
        }

        @Override
        protected boolean hasOutputs() {
            return DefaultStaticLibraryBinarySpec.this.hasSources() || !DefaultStaticLibraryBinarySpec.this.additionalLinkFiles.isEmpty();
        }

        @Override
        protected Set<File> getOutputs() {
            LinkedHashSet<File> allFiles = new LinkedHashSet<File>();
            if (DefaultStaticLibraryBinarySpec.this.hasSources()) {
                allFiles.add(DefaultStaticLibraryBinarySpec.this.getStaticLibraryFile());
            }
            for (FileCollection resourceSet : DefaultStaticLibraryBinarySpec.this.additionalLinkFiles) {
                allFiles.addAll(resourceSet.getFiles());
            }
            return allFiles;
        }
    }

    static class DefaultTasksCollection
    extends BinaryTasksCollectionWrapper
    implements StaticLibraryBinarySpec.TasksCollection {
        public DefaultTasksCollection(BinaryTasksCollection delegate) {
            super(delegate);
        }

        @Override
        public CreateStaticLibrary getCreateStaticLib() {
            return this.findSingleTaskWithType(CreateStaticLibrary.class);
        }
    }
}

