/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LegacyWindowsSdkInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.platform.base.internal.toolchain.ComponentFound;
import org.gradle.platform.base.internal.toolchain.ComponentNotFound;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyWindowsSdkLocator
implements WindowsSdkLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyWindowsSdkLocator.class);
    private static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    private static final String REGISTRY_ROOTPATH_SDK = "Microsoft\\Microsoft SDKs\\Windows";
    private static final String REGISTRY_ROOTPATH_KIT = "Microsoft\\Windows Kits\\Installed Roots";
    private static final String REGISTRY_FOLDER = "InstallationFolder";
    private static final String REGISTRY_VERSION = "ProductVersion";
    private static final String REGISTRY_NAME = "ProductName";
    private static final String REGISTRY_KIT_8 = "KitsRoot";
    private static final String REGISTRY_KIT_81 = "KitsRoot81";
    private static final String VERSION_KIT_8 = "8.0";
    private static final String VERSION_KIT_81 = "8.1";
    private static final String VERSION_USER = "user";
    private static final String NAME_USER = "User-provided Windows SDK";
    private static final String NAME_KIT = "Windows Kit";
    private static final String[] RESOURCE_PATHS = new String[]{"bin/x86/", "bin/"};
    private static final String[] KERNEL32_PATHS = new String[]{"lib/winv6.3/um/x86/", "lib/win8/um/x86/", "lib/"};
    private static final String RESOURCE_FILENAME = "rc.exe";
    private static final String KERNEL32_FILENAME = "kernel32.lib";
    private final Map<File, WindowsSdkInstall> foundSdks = new HashMap<File, WindowsSdkInstall>();
    private final OperatingSystem os;
    private final WindowsRegistry windowsRegistry;
    private WindowsSdkInstall pathSdk;
    private boolean initialised;

    public LegacyWindowsSdkLocator(OperatingSystem os, WindowsRegistry windowsRegistry) {
        this.os = os;
        this.windowsRegistry = windowsRegistry;
    }

    @Override
    public SearchResult<WindowsSdkInstall> locateComponent(@Nullable File candidate) {
        this.initializeWindowsSdks();
        if (candidate != null) {
            return this.locateUserSpecifiedSdk(candidate);
        }
        return this.locateDefaultSdk();
    }

    @Override
    public List<? extends WindowsSdkInstall> locateAllComponents() {
        this.initializeWindowsSdks();
        return Lists.newArrayList(this.foundSdks.values());
    }

    private void initializeWindowsSdks() {
        if (!this.initialised) {
            this.locateSdksInRegistry();
            this.locateKitsInRegistry();
            this.locateSdkInPath();
            this.initialised = true;
        }
    }

    private void locateSdksInRegistry() {
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateSdksInRegistry(baseKey);
        }
    }

    private void locateSdksInRegistry(String baseKey) {
        try {
            List<String> subkeys = this.windowsRegistry.getSubkeys(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_SDK);
            for (String subkey : subkeys) {
                try {
                    String basePath = baseKey + REGISTRY_ROOTPATH_SDK + "\\" + subkey;
                    File sdkDir = FileUtils.canonicalize(new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, basePath, REGISTRY_FOLDER)));
                    String version = LegacyWindowsSdkLocator.formatVersion(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, basePath, REGISTRY_VERSION));
                    String name = this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, basePath, REGISTRY_NAME);
                    if (LegacyWindowsSdkLocator.isWindowsSdk(sdkDir)) {
                        LOGGER.debug("Found Windows SDK {} at {}", (Object)version, (Object)sdkDir);
                        this.addSdk(sdkDir, version, name);
                        continue;
                    }
                    LOGGER.debug("Ignoring candidate Windows SDK directory {} as it does not look like a Windows SDK installation.", (Object)sdkDir);
                }
                catch (MissingRegistryEntryException missingRegistryEntryException) {}
            }
        }
        catch (MissingRegistryEntryException missingRegistryEntryException) {
            // empty catch block
        }
    }

    private void locateKitsInRegistry() {
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateKitsInRegistry(baseKey);
        }
    }

    private void locateKitsInRegistry(String baseKey) {
        String[] versions = new String[]{VERSION_KIT_8, VERSION_KIT_81};
        String[] keys = new String[]{REGISTRY_KIT_8, REGISTRY_KIT_81};
        for (int i = 0; i != keys.length; ++i) {
            try {
                File kitDir = FileUtils.canonicalize(new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_KIT, keys[i])));
                if (LegacyWindowsSdkLocator.isWindowsSdk(kitDir)) {
                    LOGGER.debug("Found Windows Kit {} at {}", (Object)versions[i], (Object)kitDir);
                    this.addSdk(kitDir, versions[i], "Windows Kit " + versions[i]);
                    continue;
                }
                LOGGER.debug("Ignoring candidate Windows Kit directory {} as it does not look like a Windows Kit installation.", (Object)kitDir);
                continue;
            }
            catch (MissingRegistryEntryException missingRegistryEntryException) {
                // empty catch block
            }
        }
    }

    private void locateSdkInPath() {
        File resourceCompiler = this.os.findInPath(RESOURCE_FILENAME);
        if (resourceCompiler == null) {
            LOGGER.debug("Could not find Windows resource compiler in system path.");
            return;
        }
        File sdkDir = FileUtils.canonicalize(resourceCompiler.getParentFile().getParentFile());
        if (!LegacyWindowsSdkLocator.isWindowsSdk(sdkDir) && !LegacyWindowsSdkLocator.isWindowsSdk(sdkDir = sdkDir.getParentFile())) {
            LOGGER.debug("Ignoring candidate Windows SDK for {} as it does not look like a Windows SDK installation.", (Object)resourceCompiler);
        }
        LOGGER.debug("Found Windows SDK {} using system path", (Object)sdkDir);
        if (!this.foundSdks.containsKey(sdkDir)) {
            this.addSdk(sdkDir, "path", "Path-resolved Windows SDK");
        }
        this.pathSdk = this.foundSdks.get(sdkDir);
    }

    private SearchResult<WindowsSdkInstall> locateUserSpecifiedSdk(File candidate) {
        File sdkDir = FileUtils.canonicalize(candidate);
        if (!LegacyWindowsSdkLocator.isWindowsSdk(sdkDir)) {
            return new ComponentNotFound<WindowsSdkInstall>(String.format("The specified installation directory '%s' does not appear to contain a Windows SDK installation.", candidate));
        }
        if (!this.foundSdks.containsKey(sdkDir)) {
            this.addSdk(sdkDir, VERSION_USER, NAME_USER);
        }
        return new ComponentFound<WindowsSdkInstall>(this.foundSdks.get(sdkDir));
    }

    private SearchResult<WindowsSdkInstall> locateDefaultSdk() {
        if (this.pathSdk != null) {
            return new ComponentFound<WindowsSdkInstall>(this.pathSdk);
        }
        WindowsSdkInstall candidate = null;
        for (WindowsSdkInstall windowsSdk : this.foundSdks.values()) {
            if (candidate != null && windowsSdk.getVersion().compareTo(candidate.getVersion()) <= 0) continue;
            candidate = windowsSdk;
        }
        return candidate == null ? new ComponentNotFound("Could not locate a Windows SDK installation, using the Windows registry and system path.") : new ComponentFound<Object>(candidate);
    }

    private void addSdk(File path, String version, String name) {
        this.foundSdks.put(path, new LegacyWindowsSdkInstall(path, VersionNumber.parse(version), name));
    }

    private static boolean isWindowsSdk(File candidate) {
        boolean hasResourceCompiler = false;
        boolean hasKernel32Lib = false;
        for (String path : RESOURCE_PATHS) {
            if (!new File(candidate, path + RESOURCE_FILENAME).isFile()) continue;
            hasResourceCompiler = true;
            break;
        }
        for (String path : KERNEL32_PATHS) {
            if (!new File(candidate, path + KERNEL32_FILENAME).isFile()) continue;
            hasKernel32Lib = true;
            break;
        }
        return hasResourceCompiler && hasKernel32Lib;
    }

    private static String formatVersion(String version) {
        int index = StringUtils.ordinalIndexOf((String)version, (String)".", (int)2);
        if (index != -1) {
            version = version.substring(0, index);
        }
        return version;
    }
}

