/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.BuildableComponentSpec;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractBuildableComponentSpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.javascript.JavaScriptSourceSet;
import org.gradle.language.javascript.internal.DefaultJavaScriptSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.scala.internal.DefaultScalaJvmAssembly;
import org.gradle.language.scala.internal.DefaultScalaLanguageSourceSet;
import org.gradle.language.scala.internal.ScalaJvmAssembly;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;
import org.gradle.play.JvmClasses;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.PublicAssets;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.util.CollectionUtils;

public class DefaultPlayApplicationBinarySpec
extends BaseBinarySpec
implements PlayApplicationBinarySpecInternal {
    private final DefaultScalaJvmAssembly jvmAssembly = new DefaultScalaJvmAssembly(this.getIdentifier().child("assembly"));
    private final PublicAssets assets = new DefaultPublicAssets(this.getIdentifier().child("publicAssets"));
    private Map<LanguageSourceSet, ScalaLanguageSourceSet> generatedScala = Maps.newHashMap();
    private Map<LanguageSourceSet, JavaScriptSourceSet> generatedJavaScript = Maps.newHashMap();
    private PlayPlatform platform;
    private PlayToolChainInternal toolChain;
    private File jarFile;
    private File assetsJarFile;
    private FileCollection classpath;

    @Override
    protected String getTypeName() {
        return "Play Application Jar";
    }

    @Override
    public PlayApplicationSpec getApplication() {
        return this.getComponentAs(PlayApplicationSpec.class);
    }

    @Override
    public PlayPlatform getTargetPlatform() {
        return this.platform;
    }

    @Override
    public PlayToolChainInternal getToolChain() {
        return this.toolChain;
    }

    @Override
    public ScalaJvmAssembly getAssembly() {
        return this.jvmAssembly;
    }

    @Override
    public File getJarFile() {
        return this.jarFile;
    }

    @Override
    public void setTargetPlatform(PlayPlatform platform) {
        this.platform = platform;
        this.jvmAssembly.setTargetPlatform(platform.getJavaPlatform());
        this.jvmAssembly.setScalaPlatform(platform.getScalaPlatform());
    }

    @Override
    public void setToolChain(PlayToolChainInternal toolChain) {
        this.toolChain = toolChain;
    }

    @Override
    public void setJarFile(File file) {
        this.jarFile = file;
    }

    @Override
    public File getAssetsJarFile() {
        return this.assetsJarFile;
    }

    @Override
    public void setAssetsJarFile(File assetsJarFile) {
        this.assetsJarFile = assetsJarFile;
    }

    @Override
    public JvmClasses getClasses() {
        return new JvmClassesAdapter(this.jvmAssembly);
    }

    @Override
    public PublicAssets getAssets() {
        return this.assets;
    }

    @Override
    public Map<LanguageSourceSet, ScalaLanguageSourceSet> getGeneratedScala() {
        return this.generatedScala;
    }

    @Override
    public void addGeneratedScala(LanguageSourceSet input, ObjectFactory objectFactory) {
        String lssName = input.getName() + "ScalaSources";
        ScalaLanguageSourceSet generatedScalaSources = BaseLanguageSourceSet.create(ScalaLanguageSourceSet.class, DefaultScalaLanguageSourceSet.class, this.getIdentifier().child(lssName), objectFactory);
        generatedScalaSources.builtBy(new Object[0]);
        this.generatedScala.put(input, generatedScalaSources);
    }

    @Override
    public Map<LanguageSourceSet, JavaScriptSourceSet> getGeneratedJavaScript() {
        return this.generatedJavaScript;
    }

    @Override
    public void addGeneratedJavaScript(LanguageSourceSet input, ObjectFactory objectFactory) {
        String lssName = input.getName() + "JavaScript";
        JavaScriptSourceSet javaScript = BaseLanguageSourceSet.create(JavaScriptSourceSet.class, DefaultJavaScriptSourceSet.class, this.getIdentifier().child(lssName), objectFactory);
        javaScript.builtBy(new Object[0]);
        this.generatedJavaScript.put(input, javaScript);
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Override
    public BinaryBuildAbility getBinaryBuildAbility() {
        return new ToolSearchBuildAbility(this.getToolChain().select(this.getTargetPlatform()));
    }

    @Override
    public boolean hasCodependentSources() {
        return true;
    }

    private static class DefaultPublicAssets
    extends AbstractBuildableComponentSpec
    implements PublicAssets {
        private Set<File> resourceDirs = Sets.newLinkedHashSet();

        public DefaultPublicAssets(ComponentSpecIdentifier identifier) {
            super(identifier, (Class<? extends BuildableComponentSpec>)PublicAssets.class);
        }

        @Override
        public Set<File> getAssetDirs() {
            return this.resourceDirs;
        }

        @Override
        public void addAssetDir(File assetDir) {
            this.resourceDirs.add(assetDir);
        }
    }

    private static class JvmClassesAdapter
    implements JvmClasses {
        private final JvmAssembly jvmAssembly;

        private JvmClassesAdapter(JvmAssembly jvmAssembly) {
            this.jvmAssembly = jvmAssembly;
        }

        @Override
        public String getDisplayName() {
            return this.jvmAssembly.getDisplayName();
        }

        @Override
        public String getProjectPath() {
            return this.jvmAssembly.getProjectPath();
        }

        @Override
        public String getName() {
            return this.jvmAssembly.getName();
        }

        @Override
        public File getClassesDir() {
            return CollectionUtils.single(this.jvmAssembly.getClassDirectories());
        }

        @Override
        public void setClassesDir(File classesDir) {
            BaseBinarySpec.replaceSingleDirectory(this.jvmAssembly.getClassDirectories(), classesDir);
        }

        @Override
        public Set<File> getResourceDirs() {
            return this.jvmAssembly.getResourceDirectories();
        }

        @Override
        public void addResourceDir(File resourceDir) {
            this.jvmAssembly.getResourceDirectories().add(resourceDir);
        }

        @Override
        public void builtBy(Object ... tasks) {
            this.jvmAssembly.builtBy(tasks);
        }

        @Override
        @Nullable
        public Task getBuildTask() {
            return this.jvmAssembly.getBuildTask();
        }

        @Override
        public void setBuildTask(@Nullable Task lifecycleTask) {
            this.jvmAssembly.setBuildTask(lifecycleTask);
        }

        @Override
        public boolean hasBuildDependencies() {
            return this.jvmAssembly.hasBuildDependencies();
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return this.jvmAssembly.getBuildDependencies();
        }
    }
}

