/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;

public class IssueLinkRenderer {
    private final SimpleColoredComponent myColoredComponent;
    private final IssueNavigationConfiguration myIssueNavigationConfiguration;

    public IssueLinkRenderer(Project project, SimpleColoredComponent coloredComponent) {
        this.myColoredComponent = coloredComponent;
        this.myIssueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
    }

    public List<String> appendTextWithLinks(@Nls String text2) {
        return this.appendTextWithLinks(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public List<String> appendTextWithLinks(@Nls String text2, SimpleTextAttributes baseStyle) {
        return this.appendTextWithLinks(text2, baseStyle, (Consumer<? super String>)((Consumer)s -> this.append((String)s, baseStyle)));
    }

    public List<String> appendTextWithLinks(@Nls String text2, SimpleTextAttributes baseStyle, Consumer<? super String> consumer) {
        ArrayList<String> pieces = new ArrayList<String>();
        List list = this.myIssueNavigationConfiguration.findIssueLinks((CharSequence)text2);
        int pos = 0;
        SimpleTextAttributes linkAttributes = IssueLinkRenderer.getLinkAttributes(baseStyle);
        for (IssueNavigationConfiguration.LinkMatch match : list) {
            String piece;
            TextRange textRange = match.getRange();
            if (pos > textRange.getStartOffset()) continue;
            if (textRange.getStartOffset() > pos) {
                piece = text2.substring(pos, textRange.getStartOffset());
                pieces.add(piece);
                consumer.consume((Object)piece);
            }
            piece = textRange.substring(text2);
            pieces.add(piece);
            this.append(piece, linkAttributes, match);
            pos = textRange.getEndOffset();
        }
        if (pos < text2.length()) {
            String piece = text2.substring(pos);
            pieces.add(piece);
            consumer.consume((Object)piece);
        }
        return pieces;
    }

    private void append(@Nls String piece, SimpleTextAttributes baseStyle) {
        this.myColoredComponent.append(piece, baseStyle);
    }

    private void append(@Nls String piece, SimpleTextAttributes baseStyle, IssueNavigationConfiguration.LinkMatch match) {
        this.myColoredComponent.append(piece, baseStyle, (Object)new SimpleColoredComponent.BrowserLauncherTag(match.getTargetUrl()));
    }

    private static SimpleTextAttributes getLinkAttributes(SimpleTextAttributes baseStyle) {
        Color color = baseStyle.getFgColor();
        int alpha = color != null ? color.getAlpha() : 255;
        Color linkColor = JBUI.CurrentTheme.Link.linkColor();
        Color resultColor = new Color(linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue(), alpha);
        return new SimpleTextAttributes(baseStyle.getStyle() | 0x10, resultColor);
    }
}

