/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.codereview;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.codereview.InlineIconButton;
import com.intellij.util.ui.codereview.OpenReviewButtonViewModel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J(\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/ui/codereview/OpenReviewButton;", "", "()V", "createOpenReviewButton", "Ljavax/swing/JPanel;", "tooltip", "", "installOpenButtonListeners", "", "list", "Lcom/intellij/ui/components/JBList;", "openButtonViewModel", "Lcom/intellij/util/ui/codereview/OpenReviewButtonViewModel;", "onClickActionProvider", "Lkotlin/Function0;", "Lcom/intellij/openapi/actionSystem/AnAction;", "isInsideButton", "", "cellBounds", "Ljava/awt/Rectangle;", "point", "Ljava/awt/Point;", "intellij.platform.vcs.codeReview"})
public final class OpenReviewButton {
    public static final OpenReviewButton INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JPanel createOpenReviewButton(@NotNull String tooltip) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        JPanel jPanel = new JPanel(new GridBagLayout());
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply2 = jPanel;
        boolean bl3 = false;
        $this$apply2.setOpaque(false);
        $this$apply2.setBackground(JBUI.CurrentTheme.ActionButton.pressedBackground());
        Icon icon2 = AllIcons.General.ArrowRight;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.General.ArrowRight");
        InlineIconButton inlineIconButton = new InlineIconButton(icon2, null, null, null, null, 30, null);
        boolean bl4 = false;
        boolean bl5 = false;
        InlineIconButton inlineIconButton2 = inlineIconButton;
        JPanel jPanel2 = $this$apply2;
        boolean bl6 = false;
        $this$apply.setToolTipText(tooltip);
        Unit unit = Unit.INSTANCE;
        jPanel2.add(inlineIconButton);
        return jPanel;
    }

    public final void installOpenButtonListeners(@NotNull JBList<?> list, @NotNull OpenReviewButtonViewModel openButtonViewModel, @NotNull Function0<? extends AnAction> onClickActionProvider) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)openButtonViewModel, (String)"openButtonViewModel");
        Intrinsics.checkNotNullParameter(onClickActionProvider, (String)"onClickActionProvider");
        list.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(list, openButtonViewModel){
            final /* synthetic */ JBList $list;
            final /* synthetic */ OpenReviewButtonViewModel $openButtonViewModel;

            public void mouseMoved(@NotNull MouseEvent e) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                int index = this.$list.locationToIndex(point);
                Rectangle cellBounds = this.$list.getCellBounds(index, index);
                if (cellBounds == null || !cellBounds.contains(point)) {
                    index = -1;
                }
                this.$openButtonViewModel.setHoveredRowIndex(index);
                if (index == -1) {
                    bl = false;
                } else {
                    Rectangle rectangle = cellBounds;
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"cellBounds");
                    Point point2 = point;
                    Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"point");
                    bl = OpenReviewButton.access$isInsideButton(OpenReviewButton.INSTANCE, rectangle, point2);
                }
                this.$openButtonViewModel.setButtonHovered(bl);
                this.$list.repaint();
            }
            {
                this.$list = $captured_local_variable$0;
                this.$openButtonViewModel = $captured_local_variable$1;
            }
        });
        new ClickListener(list, onClickActionProvider){
            final /* synthetic */ JBList $list;
            final /* synthetic */ Function0 $onClickActionProvider;

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Point point = event.getPoint();
                int index = this.$list.locationToIndex(point);
                Rectangle cellBounds = this.$list.getCellBounds(index, index);
                if (cellBounds == null || !cellBounds.contains(point)) {
                    return false;
                }
                Point point2 = point;
                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"point");
                if (OpenReviewButton.access$isInsideButton(OpenReviewButton.INSTANCE, cellBounds, point2)) {
                    AnAction action = (AnAction)this.$onClickActionProvider.invoke();
                    ActionUtil.invokeAction((AnAction)action, (Component)((Component)this.$list), (String)"unknown", (InputEvent)event, null);
                    return true;
                }
                return false;
            }
            {
                this.$list = $captured_local_variable$0;
                this.$onClickActionProvider = $captured_local_variable$1;
            }
        }.installOn((Component)list);
    }

    private final boolean isInsideButton(Rectangle cellBounds, Point point) {
        Icon icon2 = EmptyIcon.ICON_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EmptyIcon.ICON_16");
        int iconSize = icon2.getIconWidth();
        int rendererRelativeX = point.x - cellBounds.x;
        return cellBounds.width - rendererRelativeX <= iconSize;
    }

    private OpenReviewButton() {
    }

    static {
        OpenReviewButton openReviewButton;
        INSTANCE = openReviewButton = new OpenReviewButton();
    }

    public static final /* synthetic */ boolean access$isInsideButton(OpenReviewButton $this, Rectangle cellBounds, Point point) {
        return $this.isInsideButton(cellBounds, point);
    }
}

