/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class LightProjectDescriptor {
    public static final LightProjectDescriptor EMPTY_PROJECT_DESCRIPTOR = new LightProjectDescriptor();
    public static final String TEST_MODULE_NAME = "light_idea_test_case";

    public void setUpProject(@NotNull Project project2, @NotNull SetupHandler handler) throws Exception {
        if (project2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            LightProjectDescriptor.$$$reportNull$$$0(1);
        }
        WriteAction.run(() -> {
            Module module = this.createMainModule(project2);
            handler.moduleCreated(module);
            VirtualFile sourceRoot = this.createDirForSources(module);
            if (sourceRoot != null) {
                handler.sourceRootCreated(sourceRoot);
                this.createContentEntry(module, sourceRoot);
            }
        });
    }

    public void registerSdk(Disposable disposable) {
        Sdk sdk = this.getSdk();
        if (sdk != null) {
            LightProjectDescriptor.registerJdk(sdk, disposable);
        }
    }

    @NotNull
    public Module createMainModule(@NotNull Project project2) {
        if (project2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(2);
        }
        Module module = this.createModule(project2, Paths.get(FileUtil.getTempDirectory(), "light_idea_test_case.iml"));
        if (module == null) {
            LightProjectDescriptor.$$$reportNull$$$0(3);
        }
        return module;
    }

    protected final Module createModule(@NotNull Project project2, @NotNull String moduleFilePath) {
        if (project2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(4);
        }
        if (moduleFilePath == null) {
            LightProjectDescriptor.$$$reportNull$$$0(5);
        }
        return this.createModule(project2, Paths.get(moduleFilePath, new String[0]));
    }

    protected Module createModule(@NotNull Project project2, @NotNull Path moduleFile) {
        if (project2 == null) {
            LightProjectDescriptor.$$$reportNull$$$0(6);
        }
        if (moduleFile == null) {
            LightProjectDescriptor.$$$reportNull$$$0(7);
        }
        try {
            Files.deleteIfExists(moduleFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)project2).newModule(moduleFile, this.getModuleTypeId()));
    }

    @NotNull
    public String getModuleTypeId() {
        return "EMPTY_MODULE";
    }

    @Nullable
    public VirtualFile createDirForSources(@NotNull Module module) {
        if (module == null) {
            LightProjectDescriptor.$$$reportNull$$$0(8);
        }
        return this.createSourceRoot(module, "src");
    }

    protected boolean markDirForSourcesAsSourceRoot() {
        return true;
    }

    protected VirtualFile createSourceRoot(@NotNull Module module, String srcPath) {
        if (module == null) {
            LightProjectDescriptor.$$$reportNull$$$0(9);
        }
        VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        assert (dummyRoot != null);
        dummyRoot.refresh(false, false);
        VirtualFile srcRoot = this.doCreateSourceRoot(dummyRoot, srcPath);
        this.registerSourceRoot(module.getProject(), srcRoot);
        return srcRoot;
    }

    protected VirtualFile doCreateSourceRoot(VirtualFile root, String srcPath) {
        VirtualFile srcRoot;
        try {
            srcRoot = root.createChildDirectory((Object)this, srcPath);
            this.cleanSourceRoot(srcRoot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return srcRoot;
    }

    protected void registerSourceRoot(final Project project2, final VirtualFile srcRoot) {
        IndexableFileSet indexableFileSet = new IndexableFileSet(){

            public boolean isInSet(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file2.getFileSystem() == srcRoot.getFileSystem() && project2.isOpen();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$1", "isInSet"));
            }
        };
        FileBasedIndex.getInstance().registerIndexableSet(indexableFileSet, project2);
        Disposer.register((Disposable)project2, () -> FileBasedIndex.getInstance().removeIndexableSet(indexableFileSet));
    }

    protected void createContentEntry(@NotNull Module module, @NotNull VirtualFile srcRoot) {
        if (module == null) {
            LightProjectDescriptor.$$$reportNull$$$0(10);
        }
        if (srcRoot == null) {
            LightProjectDescriptor.$$$reportNull$$$0(11);
        }
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            Sdk sdk = this.getSdk();
            if (sdk != null) {
                model.setSdk(sdk);
            }
            ContentEntry contentEntry = model.addContentEntry(srcRoot);
            if (this.markDirForSourcesAsSourceRoot()) {
                contentEntry.addSourceFolder(srcRoot, this.getSourceRootType());
            }
            this.configureModule(module, (ModifiableRootModel)model, contentEntry);
        });
    }

    private static void registerJdk(Sdk jdk, Disposable parentDisposable) {
        WriteAction.run(() -> {
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            ((ProjectJdkTableImpl)jdkTable).addTestJdk(jdk, parentDisposable);
        });
    }

    @NotNull
    protected JpsModuleSourceRootType<?> getSourceRootType() {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        if (javaSourceRootType == null) {
            LightProjectDescriptor.$$$reportNull$$$0(12);
        }
        return javaSourceRootType;
    }

    @Nullable
    public Sdk getSdk() {
        return null;
    }

    private void cleanSourceRoot(@NotNull VirtualFile contentRoot) throws IOException {
        if (contentRoot == null) {
            LightProjectDescriptor.$$$reportNull$$$0(13);
        }
        TempFileSystem tempFs = (TempFileSystem)contentRoot.getFileSystem();
        for (VirtualFile child : contentRoot.getChildren()) {
            if (!tempFs.exists(child)) {
                tempFs.createChildFile((Object)this, contentRoot, child.getName());
            }
            child.delete((Object)this);
        }
    }

    protected void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
        if (module == null) {
            LightProjectDescriptor.$$$reportNull$$$0(14);
        }
        if (model == null) {
            LightProjectDescriptor.$$$reportNull$$$0(15);
        }
        if (contentEntry == null) {
            LightProjectDescriptor.$$$reportNull$$$0(16);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightProjectDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRoot";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMainModule";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDirForSources";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRoot";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createContentEntry";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanSourceRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configureModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SetupHandler {
        default public void moduleCreated(@NotNull Module module) {
            if (module == null) {
                SetupHandler.$$$reportNull$$$0(0);
            }
        }

        default public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
            if (sourceRoot == null) {
                SetupHandler.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRoot";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/LightProjectDescriptor$SetupHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moduleCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceRootCreated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

