/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.SkipInHeadlessEnvironment;
import com.intellij.testFramework.SkipSlowTestLocally;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.fixtures.BareTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@TestOnly
public abstract class BareTestFixtureTestCase {
    @Rule
    public final TestName myNameRule = new TestName();
    private BareTestFixture myFixture;
    @Rule
    public TestRule testLoggerWatcher = TestLoggerFactory.createTestWatcher();

    @Before
    public final void setupFixture() throws Exception {
        ApplicationInfoImpl.setInStressTest((boolean)TestFrameworkUtil.isPerformanceTest(null, (String)this.getClass().getName()));
        boolean headless = TestFrameworkUtil.SKIP_HEADLESS && this.getClass().getAnnotation(SkipInHeadlessEnvironment.class) != null;
        Assume.assumeFalse((String)("Class '" + this.getClass().getName() + "' is skipped because it requires working UI environment"), (boolean)headless);
        boolean slow = TestFrameworkUtil.SKIP_SLOW && this.getClass().getAnnotation(SkipSlowTestLocally.class) != null;
        Assume.assumeFalse((String)("Class '" + this.getClass().getName() + "' is skipped because it is dog slow"), (boolean)slow);
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createBareFixture();
        this.myFixture.setUp();
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> ApplicationInfoImpl.setInStressTest((boolean)false));
    }

    @After
    public final void tearDownFixture() throws Exception {
        if (this.myFixture != null) {
            this.myFixture.tearDown();
            this.myFixture = null;
        }
    }

    @NotNull
    protected final String getTestName(boolean lowercaseFirstLetter) {
        String string = PlatformTestUtil.getTestName(this.myNameRule.getMethodName(), lowercaseFirstLetter);
        if (string == null) {
            BareTestFixtureTestCase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public final Disposable getTestRootDisposable() {
        Disposable disposable = this.myFixture.getTestRootDisposable();
        if (disposable == null) {
            BareTestFixtureTestCase.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/testFramework/fixtures/BareTestFixtureTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

