/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0001J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R0\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/io/impl/DirectorySpecBase;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "()V", "children", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getChildren", "()Ljava/util/LinkedHashMap;", "addChild", "", "name", "spec", "generateInDirectory", "target", "Ljava/io/File;", "generateInTempDir", "Ljava/nio/file/Path;", "", "mergeWith", "other", "Lcom/intellij/util/io/DirectoryContentSpec;", "intellij.platform.testFramework"})
public abstract class DirectorySpecBase
extends DirectoryContentSpecImpl {
    @NotNull
    private final LinkedHashMap<String, DirectoryContentSpecImpl> children = new LinkedHashMap();

    @NotNull
    protected final LinkedHashMap<String, DirectoryContentSpecImpl> getChildren() {
        return this.children;
    }

    public final void addChild(@NotNull String name, @NotNull DirectoryContentSpecImpl spec) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Map map = this.children;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(name)) {
            DirectoryContentSpecImpl existing = this.children.get(name);
            if (spec instanceof DirectorySpecBase && existing instanceof DirectorySpecBase) {
                Map map3 = ((DirectorySpecBase)existing).children;
                map2 = ((DirectorySpecBase)spec).children;
                bl2 = false;
                map3.putAll(map2);
                return;
            }
            throw (Throwable)new IllegalArgumentException('\'' + name + "' already exists");
        }
        ((Map)this.children).put(name, spec);
    }

    /*
     * WARNING - void declaration
     */
    protected final void generateInDirectory(@NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object object = this.children;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)entry2.getValue();
            child.generate(new File(target, (String)name));
        }
    }

    @Override
    @NotNull
    public Path generateInTempDir() {
        File file2 = FileUtil.createTempDirectory((String)"directory-by-spec", null, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempDirec\u2026ory-by-spec\", null, true)");
        File target = file2;
        this.generate(target);
        Path path = target.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"target.toPath()");
        return path;
    }

    @NotNull
    public final Map<String, DirectoryContentSpecImpl> getChildren() {
        Map<String, DirectoryContentSpecImpl> map = Collections.unmodifiableMap((Map)this.children);
        Intrinsics.checkNotNullExpressionValue(map, (String)"Collections.unmodifiableMap(children)");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DirectoryContentSpecImpl mergeWith(@NotNull DirectoryContentSpec other) {
        DirectorySpecBase directorySpecBase;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean bl = Intrinsics.areEqual(other.getClass(), this.getClass());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        DirectorySpecBase cfr_ignored_0 = (DirectorySpecBase)other;
        Object object = other;
        if (object instanceof DirectorySpec) {
            directorySpecBase = new DirectorySpec();
        } else if (object instanceof ZipSpec) {
            directorySpecBase = new ZipSpec();
        } else {
            bl3 = false;
            throw (Throwable)new IllegalStateException(other.toString());
        }
        DirectorySpecBase result = directorySpecBase;
        result.children.putAll((Map<String, DirectoryContentSpecImpl>)this.children);
        Object object2 = ((DirectorySpecBase)other).children;
        boolean bl6 = false;
        Iterator iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            void name;
            Object object3 = object = iterator.next();
            boolean bl7 = false;
            object2 = (String)object3.getKey();
            object3 = object;
            bl7 = false;
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)object3.getValue();
            DirectoryContentSpecImpl oldChild = this.children.get(name);
            Map map = result.children;
            DirectoryContentSpecImpl directoryContentSpecImpl = oldChild;
            if (directoryContentSpecImpl == null || (directoryContentSpecImpl = directoryContentSpecImpl.mergeWith(child)) == null) {
                directoryContentSpecImpl = child;
            }
            map.put(name, directoryContentSpecImpl);
        }
        return result;
    }

    public DirectorySpecBase() {
        super(null);
    }
}

