/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u001c\u0010\u000f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u0012\u0010\u0010\u001a\u00020\r*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003\u00a8\u0006\u0012"}, d2={"findMethodCalls", "", "Lcom/intellij/psi/PsiMethodCallExpression;", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "method", "Lcom/intellij/psi/PsiMethod;", "scope", "Lcom/intellij/psi/PsiElement;", "findVariableUsages", "Lcom/intellij/psi/PsiReferenceExpression;", "variable", "Lcom/intellij/psi/PsiVariable;", "hasWriteAccesses", "", "searcher", "isInVariableInitializer", "isVar", "Lcom/intellij/psi/PsiField;", "kotlin.j2k.old"})
public final class ReferenceSearcherKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<PsiReferenceExpression> findVariableUsages(@NotNull ReferenceSearcher $this$findVariableUsages, @NotNull PsiVariable variable, @NotNull PsiElement scope) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findVariableUsages, (String)"$this$findVariableUsages");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Iterable $this$filterIsInstance$iv = $this$findVariableUsages.findLocalUsages((PsiElement)variable, scope);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiReferenceExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<PsiMethodCallExpression> findMethodCalls(@NotNull ReferenceSearcher $this$findMethodCalls, @NotNull PsiMethod method, @NotNull PsiElement scope) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findMethodCalls, (String)"$this$findMethodCalls");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Iterable $this$mapNotNull$iv = $this$findMethodCalls.findLocalUsages((PsiElement)method, scope);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiReference it = (PsiReference)element$iv$iv;
            boolean bl2 = false;
            if (it instanceof PsiReferenceExpression) {
                PsiMethodCallExpression methodCall;
                PsiElement psiElement = ((PsiReferenceExpression)it).getParent();
                if (!(psiElement instanceof PsiMethodCallExpression)) {
                    psiElement = null;
                }
                PsiMethodCallExpression psiMethodCallExpression = methodCall = (PsiMethodCallExpression)psiElement;
                object = Intrinsics.areEqual((Object)(psiMethodCallExpression != null ? psiMethodCallExpression.getMethodExpression() : null), (Object)it) ? methodCall : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            PsiMethodCallExpression psiMethodCallExpression = object;
            boolean bl3 = false;
            boolean bl4 = false;
            PsiMethodCallExpression it$iv$iv = psiMethodCallExpression;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isVar(@NotNull PsiField $this$isVar, @NotNull ReferenceSearcher searcher) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isVar, (String)"$this$isVar");
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        if ($this$isVar.hasModifierProperty("final")) {
            return false;
        }
        if (!$this$isVar.hasModifierProperty("private")) {
            return true;
        }
        PsiClass psiClass = $this$isVar.getContainingClass();
        if (psiClass == null) return true;
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"containingClass ?: return true");
        PsiClass containingClass = psiClass;
        Iterable $this$filter$iv = ReferenceSearcherKt.findVariableUsages(searcher, (PsiVariable)$this$isVar, (PsiElement)containingClass);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiReferenceExpression it = (PsiReferenceExpression)element$iv$iv;
            boolean bl = false;
            if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List writes = (List)destination$iv$iv;
        if (writes.size() == 0) {
            return false;
        }
        if (writes.size() > 1) {
            return true;
        }
        PsiReferenceExpression write = (PsiReferenceExpression)CollectionsKt.single((List)writes);
        PsiElement parent = write.getParent();
        if (!(parent instanceof PsiAssignmentExpression)) return true;
        PsiJavaToken psiJavaToken = ((PsiAssignmentExpression)parent).getOperationSign();
        Intrinsics.checkNotNullExpressionValue((Object)psiJavaToken, (String)"parent.operationSign");
        if (!Intrinsics.areEqual((Object)psiJavaToken.getTokenType(), (Object)JavaTokenType.EQ)) return true;
        if (!UtilsKt.isQualifierEmptyOrThis(write)) return true;
        PsiMethod constructor = UtilsKt.getContainingConstructor((PsiElement)write);
        if (constructor == null) return true;
        if (Intrinsics.areEqual((Object)constructor.getContainingClass(), (Object)containingClass) ^ true) return true;
        if (!(((PsiAssignmentExpression)parent).getParent() instanceof PsiExpressionStatement)) return true;
        PsiElement psiElement = ((PsiAssignmentExpression)parent).getParent();
        if (!(Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getParent() : null), (Object)constructor.getBody()) ^ true)) return false;
        return true;
    }

    public static final boolean hasWriteAccesses(@NotNull PsiVariable $this$hasWriteAccesses, @NotNull ReferenceSearcher searcher, @Nullable PsiElement scope) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$hasWriteAccesses, (String)"$this$hasWriteAccesses");
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            if (scope != null) {
                Iterable $this$any$iv = ReferenceSearcherKt.findVariableUsages(searcher, $this$hasWriteAccesses, scope);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiReferenceExpression it = (PsiReferenceExpression)element$iv;
                        boolean bl2 = false;
                        if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)it))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInVariableInitializer(@NotNull PsiVariable $this$isInVariableInitializer, @NotNull ReferenceSearcher searcher, @Nullable PsiElement scope) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$isInVariableInitializer, (String)"$this$isInVariableInitializer");
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            if (scope != null) {
                Iterable $this$any$iv = ReferenceSearcherKt.findVariableUsages(searcher, $this$isInVariableInitializer, scope);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiReferenceExpression it = (PsiReferenceExpression)element$iv;
                        boolean bl2 = false;
                        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)((PsiElement)it), (Class[])new Class[]{PsiParenthesizedExpression.class});
                        boolean bl3 = parent instanceof PsiVariable && Intrinsics.areEqual((Object)((PsiVariable)parent).getInitializer(), (Object)it);
                        if (!bl3) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }
}

