/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.DynamicBundle;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.ReportStatusDispatcher;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.ReportStatus;
import org.gradle.launcher.daemon.protocol.Status;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.registry.DaemonStopEvents;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonAction;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;

public class DaemonStatusAction
extends DaemonAction {
    public DaemonStatusAction(String serviceDirectoryPath) {
        super(serviceDirectoryPath);
    }

    public List<DaemonState> run(DaemonClientFactory daemonClientFactory) {
        ServiceRegistry daemonServices = this.getDaemonServices(daemonClientFactory);
        DaemonConnector daemonConnector = (DaemonConnector)daemonServices.get(DaemonConnector.class);
        DaemonRegistry daemonRegistry = (DaemonRegistry)daemonServices.get(DaemonRegistry.class);
        IdGenerator idGenerator = (IdGenerator)daemonServices.get(IdGenerator.class);
        return new ReportDaemonStatusClient(daemonRegistry, daemonConnector, idGenerator).get();
    }

    static class ReportDaemonStatusClient {
        private final DaemonRegistry daemonRegistry;
        private final DaemonConnector connector;
        private final IdGenerator<?> idGenerator;
        private final ReportStatusDispatcher reportStatusDispatcher;

        ReportDaemonStatusClient(DaemonRegistry daemonRegistry, DaemonConnector connector, IdGenerator<?> idGenerator) {
            this.daemonRegistry = daemonRegistry;
            this.connector = connector;
            this.idGenerator = idGenerator;
            this.reportStatusDispatcher = new ReportStatusDispatcher();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<DaemonState> get() {
            ArrayList<DaemonState> daemons = new ArrayList<DaemonState>();
            for (DaemonInfo daemon : this.daemonRegistry.getAll()) {
                DaemonClientConnection connection = this.connector.maybeConnect((DaemonConnectDetails)daemon);
                if (connection == null) continue;
                DaemonInfo connectionDaemon = connection.getDaemon() instanceof DaemonInfo ? (DaemonInfo)connection.getDaemon() : daemon;
                try {
                    List daemonOpts = connectionDaemon.getContext().getDaemonOpts();
                    File javaHome = connectionDaemon.getContext().getJavaHome();
                    Integer idleTimeout = connectionDaemon.getContext().getIdleTimeout();
                    File registryDir = connectionDaemon.getContext().getDaemonRegistryDir();
                    Object id = this.idGenerator.generateId();
                    byte[] token = daemon.getToken();
                    ReportStatus statusCommand = DaemonAction.createCommand(ReportStatus.class, id, token);
                    Status status = this.reportStatusDispatcher.dispatch((Connection)connection, (Command)statusCommand);
                    if (status != null) {
                        daemons.add(new DaemonState(connectionDaemon.getPid(), connectionDaemon.getToken(), status.getVersion(), status.getStatus(), null, connectionDaemon.getLastBusy().getTime(), null, daemonOpts, javaHome, idleTimeout, registryDir));
                        continue;
                    }
                    daemons.add(new DaemonState(connectionDaemon.getPid(), connectionDaemon.getToken(), "UNKNOWN", "UNKNOWN", null, connectionDaemon.getLastBusy().getTime(), null, daemonOpts, javaHome, idleTimeout, registryDir));
                }
                finally {
                    connection.stop();
                }
            }
            List stopEvents = DaemonStopEvents.uniqueRecentDaemonStopEvents((List)this.daemonRegistry.getStopEvents());
            for (DaemonStopEvent stopEvent : stopEvents) {
                Long stopEventPid;
                String daemonExpirationStatus;
                DaemonExpirationStatus expirationStatus = stopEvent.getStatus();
                String string = daemonExpirationStatus = expirationStatus != null ? expirationStatus.name().replace("_", " ").toLowerCase(DynamicBundle.getLocale()) : "";
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.0")) <= 0) {
                    try {
                        Field pidField = stopEvent.getClass().getDeclaredField("pid");
                        pidField.setAccessible(true);
                        stopEventPid = pidField.getLong(stopEvent);
                    }
                    catch (Exception ignore) {
                        stopEventPid = -1L;
                    }
                } else {
                    stopEventPid = stopEvent.getPid();
                }
                daemons.add(new DaemonState(stopEventPid, null, null, "Stopped", stopEvent.getReason(), stopEvent.getTimestamp().getTime(), daemonExpirationStatus, null, null, null, null));
            }
            return daemons;
        }
    }
}

