/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ContentsUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.LabelUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;

public final class IntersectingLocalChangesPanel {
    @NotNull
    private final BorderLayoutPanel myPanel;
    @NotNull
    private final List<? extends FilePath> myFiles;
    @NotNull
    private final Project myProject;

    public IntersectingLocalChangesPanel(@NotNull Project project, @NotNull List<? extends FilePath> files) {
        if (project == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(0);
        }
        if (files == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFiles = files;
        this.myPanel = this.createPanel((JLabel)IntersectingLocalChangesPanel.createLabel(), (JTree)this.createTree());
    }

    @NotNull
    private BorderLayoutPanel createPanel(@NotNull JLabel label, @NotNull JTree tree) {
        if (label == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(2);
        }
        if (tree == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(3);
        }
        BorderLayoutPanel panel = JBUI.Panels.simplePanel();
        panel.setBackground(UIUtil.getTextFieldBackground());
        panel.addToTop((Component)label).addToCenter((Component)tree);
        new EditSourceAction().registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)panel);
        DataManager.registerDataProvider((JComponent)panel, dataId -> {
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                return ChangesUtil.getNavigatableArray((Project)this.myProject, UtilKt.stream((Object[])tree.getSelectionPaths()).map(TreePath::getLastPathComponent).map(node -> (ChangesBrowserNode)node).flatMap(ChangesBrowserNode::getFilePathsUnderStream).map(FilePath::getVirtualFile).filter(Objects::nonNull).distinct());
            }
            return null;
        });
        BorderLayoutPanel borderLayoutPanel = panel;
        if (borderLayoutPanel == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(4);
        }
        return borderLayoutPanel;
    }

    @NotNull
    private SimpleTree createTree() {
        SimpleTree tree = new SimpleTree(TreeModelBuilder.buildFromFilePaths((Project)this.myProject, (ChangesGroupingPolicyFactory)NoneChangesGroupingFactory.INSTANCE, this.myFiles)){

            protected void configureUiHelper(@NotNull TreeUIHelper helper) {
                if (helper == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.configureUiHelper(helper);
                helper.installEditSourceOnDoubleClick((JTree)((Object)this));
                helper.installEditSourceOnEnterKeyHandler((JTree)((Object)this));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "org/jetbrains/idea/svn/dialogs/IntersectingLocalChangesPanel$1", "configureUiHelper"));
            }
        };
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        tree.setCellRenderer((TreeCellRenderer)new ChangesBrowserNodeRenderer(this.myProject, BooleanGetter.TRUE, false));
        SimpleTree simpleTree = tree;
        if (simpleTree == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(5);
        }
        return simpleTree;
    }

    @NotNull
    private static JBLabel createLabel() {
        JBLabel label = new JBLabel(SvnBundle.message("label.merge.local.changes.intersection", new Object[0])){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width, (int)((double)size.height * 1.7));
            }
        };
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setBackground(UIUtil.getTextFieldBackground());
        label.setVerticalTextPosition(1);
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(6);
        }
        return jBLabel;
    }

    public static void showInVersionControlToolWindow(@NotNull Project project, @NlsContexts.TabTitle @NotNull String title, @NotNull List<? extends FilePath> files) {
        if (project == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(7);
        }
        if (title == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(8);
        }
        if (files == null) {
            IntersectingLocalChangesPanel.$$$reportNull$$$0(9);
        }
        IntersectingLocalChangesPanel intersectingPanel = new IntersectingLocalChangesPanel(project, files);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)intersectingPanel.myPanel, title, true);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        ContentsUtil.addContent((ContentManager)toolWindow.getContentManager(), (Content)content, (boolean)true);
        toolWindow.activate(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/IntersectingLocalChangesPanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/IntersectingLocalChangesPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showInVersionControlToolWindow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

