/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction;", "Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "kotlin.jvm"})
public final class RunScratchAction
extends ScratchAction {
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ScratchFile scratchFile = ScratchUtilsKt.getScratchFileFromSelectedEditor(project2);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        Companion.doAction(scratchFile2, false);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(!ScratchCompilationSupport.INSTANCE.isAnyInProgress());
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        if (presentation2.isEnabled()) {
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            Presentation presentation4 = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"templatePresentation");
            presentation3.setText(presentation4.getText());
        } else {
            Presentation presentation5 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
            presentation5.setText(KotlinJvmBundle.message("other.scratch.file.execution.is.in.progress", new Object[0]));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ScratchFile scratchFile = ScratchUtilsKt.getScratchFileFromSelectedEditor(project2);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        Presentation presentation6 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation6, (String)"e.presentation");
        presentation6.setVisible(!ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile2));
    }

    public RunScratchAction() {
        block0: {
            String string = KotlinJvmBundle.message("scratch.run.button", new Object[0]);
            Icon icon = AllIcons.Actions.Execute;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Actions.Execute");
            super(string, icon);
            KeymapManager keymapManager = KeymapManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
            Object[] objectArray = keymapManager.getActiveKeymap().getShortcuts("Kotlin.RunScratch");
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"KeymapManager.getInstanc\u2026cuts(\"Kotlin.RunScratch\")");
            Shortcut shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])objectArray);
            if (shortcut == null) break block0;
            Shortcut shortcut2 = shortcut;
            boolean bl = false;
            boolean bl2 = false;
            Shortcut it = shortcut2;
            boolean bl3 = false;
            Presentation presentation = this.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
            presentation.setText(presentation.getText() + " (" + KeymapUtil.getShortcutText((Shortcut)it) + ')');
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchAction$Companion;", "", "()V", "doAction", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "isAutoRun", "", "kotlin.jvm"})
    public static final class Companion {
        public final void doAction(@NotNull ScratchFile scratchFile, boolean isAutoRun) {
            Intrinsics.checkNotNullParameter((Object)scratchFile, (String)"scratchFile");
            boolean isRepl = scratchFile.getOptions().isRepl();
            ScratchExecutor scratchExecutor = isRepl ? (ScratchExecutor)scratchFile.getReplScratchExecutor() : scratchFile.getCompilingScratchExecutor();
            if (scratchExecutor == null) {
                return;
            }
            ScratchExecutor executor = scratchExecutor;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isRepl = " + isRepl);
            Function0<Unit> $fun$executeScratch$1 = new Function0<Unit>(isAutoRun, executor){
                final /* synthetic */ boolean $isAutoRun;
                final /* synthetic */ ScratchExecutor $executor;

                public final void invoke() {
                    try {
                        if (this.$isAutoRun && this.$executor instanceof SequentialScratchExecutor) {
                            ((SequentialScratchExecutor)this.$executor).executeNew();
                        } else {
                            this.$executor.execute();
                        }
                    }
                    catch (Throwable ex) {
                        this.$executor.errorOccurs(KotlinJvmBundle.message("exception.occurs.during.run.scratch.action", new Object[0]), ex, true);
                    }
                }
                {
                    this.$isAutoRun = bl;
                    this.$executor = scratchExecutor;
                    super(0);
                }
            };
            boolean isMakeBeforeRun = scratchFile.getOptions().isMakeBeforeRun();
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: isMakeBeforeRun = " + isMakeBeforeRun);
            Module module = scratchFile.getModule();
            Module module2 = module;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Run Action: module = " + (module2 != null ? module2.getName() : null));
            if (!isAutoRun && module != null && isMakeBeforeRun) {
                Project project = scratchFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)ProjectTaskManager.getInstance((Project)project).build(new Module[]{module}).onSuccess((Consumer)new Consumer<ProjectTaskManager.Result>(executor, module, project, $fun$executeScratch$1){
                    final /* synthetic */ ScratchExecutor $executor;
                    final /* synthetic */ Module $module;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ doAction.1 $executeScratch$1;

                    public final void accept(ProjectTaskManager.Result executionResult) {
                        ProjectTaskManager.Result result = executionResult;
                        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"executionResult");
                        if (result.isAborted() || executionResult.hasErrors()) {
                            Object[] objectArray = new Object[1];
                            String string = this.$module.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
                            objectArray[0] = string;
                            ScratchExecutor.errorOccurs$default(this.$executor, KotlinJvmBundle.message("there.were.compilation.errors.in.module.0", objectArray), null, false, 6, null);
                        }
                        if (DumbService.isDumb((Project)this.$project)) {
                            DumbService.getInstance((Project)this.$project).smartInvokeLater(new Runnable(this){
                                final /* synthetic */ doAction.2 this$0;

                                public final void run() {
                                    this.this$0.$executeScratch$1.invoke();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        } else {
                            this.$executeScratch$1.invoke();
                        }
                    }
                    {
                        this.$executor = scratchExecutor;
                        this.$module = module;
                        this.$project = project;
                        this.$executeScratch$1 = var4_4;
                    }
                }), (String)"ProjectTaskManager.getIn\u2026      }\n                }");
            } else {
                $fun$executeScratch$1.invoke();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

