/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.Hash;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.stash.GitStashOperations;
import git4idea.stash.GitStashUtils;
import git4idea.stash.UnstashConflictResolver;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J2\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u001b"}, d2={"Lgit4idea/stash/GitStashOperations;", "", "()V", "clearStashesWithConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentComponent", "Ljava/awt/Component;", "dropStashWithConfirmation", "stash", "Lgit4idea/ui/StashInfo;", "loadStashedChanges", "Lgit4idea/changes/GitCommittedChangeList;", "hash", "Lcom/intellij/vcs/log/Hash;", "unstash", "branch", "", "popStash", "reinstateIndex", "unstashHandler", "Lgit4idea/commands/GitLineHandler;", "viewStash", "", "intellij.vcs.git"})
public final class GitStashOperations {
    public static final GitStashOperations INSTANCE;

    @JvmStatic
    public static final boolean dropStashWithConfirmation(@NotNull Project project, @Nullable Component parentComponent, @NotNull StashInfo stash) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        String string = GitBundle.message("git.unstash.drop.confirmation.title", stash.getStash());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.u\u2026tion.title\", stash.stash)");
        String string2 = GitBundle.message("git.unstash.drop.confirmation.message", stash.getStash(), stash.getMessage());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"git.u\u2026ash.stash, stash.message)");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getQuestionIcon());
        boolean bl = confirmed = parentComponent != null ? dialogBuilder.ask(parentComponent) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h2 = new GitLineHandler(project, stash.getRoot(), GitCommand.STASH);
        h2.addParameters("drop", stash.getStash());
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Unit, VcsException>(h2){
                final /* synthetic */ GitLineHandler $h;

                public final void compute() {
                    Git.getInstance().runCommand(this.$h).throwOnError(new int[0]);
                }
                {
                    this.$h = gitLineHandler;
                }
            }, GitBundle.message("unstash.dialog.remove.stash.progress.indicator.title", stash.getStash()), true, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h2.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final boolean clearStashesWithConfirmation(@NotNull Project project, @NotNull VirtualFile root, @Nullable Component parentComponent) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        String string = GitBundle.message("git.unstash.clear.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.u\u2026lear.confirmation.title\")");
        String string2 = GitBundle.message("git.unstash.clear.confirmation.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"git.u\u2026ar.confirmation.message\")");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getWarningIcon());
        boolean bl = confirmed = parentComponent != null ? dialogBuilder.ask(parentComponent) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.STASH);
        h2.addParameters("clear");
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Unit, VcsException>(h2){
                final /* synthetic */ GitLineHandler $h;

                public final void compute() {
                    Git.getInstance().runCommand(this.$h).throwOnError(new int[0]);
                }
                {
                    this.$h = gitLineHandler;
                }
            }, GitBundle.message("unstash.clearing.stashes", new Object[0]), false, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h2.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final void viewStash(@NotNull Project project, @NotNull StashInfo stash) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        CommittedChangeListImpl emptyChangeList = new CommittedChangeListImpl(stash.getStash(), stash.getMessage(), "", -1L, new Date(0L), (Collection)CollectionsKt.emptyList());
        ChangeListViewerDialog dialog2 = new ChangeListViewerDialog(project, (CommittedChangeList)emptyChangeList, null);
        dialog2.loadChangesInBackground((ThrowableComputable)new ThrowableComputable<ChangeListViewerDialog.ChangelistData, VcsException>(project, stash){
            final /* synthetic */ Project $project;
            final /* synthetic */ StashInfo $stash;

            public final ChangeListViewerDialog.ChangelistData compute() {
                VirtualFile virtualFile = this.$stash.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"stash.root");
                Hash hash = this.$stash.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"stash.hash");
                return new ChangeListViewerDialog.ChangelistData((CommittedChangeList)GitStashOperations.INSTANCE.loadStashedChanges(this.$project, virtualFile, hash), null);
            }
            {
                this.$project = project;
                this.$stash = stashInfo;
            }
        });
        dialog2.setTitle(GitBundle.message("unstash.view.dialog.title", stash.getStash()));
        dialog2.show();
    }

    @RequiresBackgroundThread
    @NotNull
    public final GitCommittedChangeList loadStashedChanges(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        GitCommittedChangeList gitCommittedChangeList = GitChangeUtils.getRevisionChanges(project, GitUtil.getRootForFile(project, root), hash.asString(), true, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitCommittedChangeList), (String)"GitChangeUtils.getRevisi\u2026      true, false, false)");
        return gitCommittedChangeList;
    }

    @JvmStatic
    public static final boolean unstash(@NotNull Project project, @NotNull StashInfo stash, @Nullable String branch, boolean popStash, boolean reinstateIndex) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        Boolean completed2 = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Boolean, Exception>(project, stash, branch, popStash, reinstateIndex){
            final /* synthetic */ Project $project;
            final /* synthetic */ StashInfo $stash;
            final /* synthetic */ String $branch;
            final /* synthetic */ boolean $popStash;
            final /* synthetic */ boolean $reinstateIndex;

            public final Boolean compute() {
                return GitStashUtils.unstash(this.$project, MapsKt.mapOf((Pair)new Pair((Object)this.$stash.getRoot(), (Object)this.$stash.getHash())), (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)new Function1<VirtualFile, GitLineHandler>(this){
                    final /* synthetic */ unstash.completed.1 this$0;

                    @NotNull
                    public final GitLineHandler invoke(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GitStashOperations.access$unstashHandler(GitStashOperations.INSTANCE, this.this$0.$project, this.this$0.$stash, this.this$0.$branch, this.this$0.$popStash, this.this$0.$reinstateIndex);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), new UnstashConflictResolver(this.$project, this.$stash));
            }
            {
                this.$project = project;
                this.$stash = stashInfo;
                this.$branch = string;
                this.$popStash = bl;
                this.$reinstateIndex = bl2;
            }
        }, GitBundle.message("unstash.unstashing", new Object[0]), true, project);
        if (!completed2.booleanValue()) {
            return false;
        }
        VcsNotifier.getInstance((Project)project).notifySuccess("git.unstash.patch.applied", "", VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        return true;
    }

    private final GitLineHandler unstashHandler(Project project, StashInfo stash, String branch, boolean popStash, boolean reinstateIndex) {
        GitLineHandler h2 = new GitLineHandler(project, stash.getRoot(), GitCommand.STASH);
        CharSequence charSequence = branch;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            h2.addParameters(popStash ? "pop" : "apply");
            if (reinstateIndex) {
                h2.addParameters("--index");
            }
        } else {
            h2.addParameters("branch", branch);
        }
        h2.addParameters(stash.getStash());
        return h2;
    }

    private GitStashOperations() {
    }

    static {
        GitStashOperations gitStashOperations;
        INSTANCE = gitStashOperations = new GitStashOperations();
    }

    public static final /* synthetic */ GitLineHandler access$unstashHandler(GitStashOperations $this, Project project, StashInfo stash, String branch, boolean popStash, boolean reinstateIndex) {
        return $this.unstashHandler(project, stash, branch, popStash, reinstateIndex);
    }
}

