/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public class SequenceWrapper
extends SequenceReceiver {
    public static final String RESULT_NS = QueryResult.RESULT_NS;
    private Receiver out;
    private int depth = 0;
    private FingerprintedQName resultDocument;
    private FingerprintedQName resultElement;
    private FingerprintedQName resultAttribute;
    private FingerprintedQName resultText;
    private FingerprintedQName resultComment;
    private FingerprintedQName resultPI;
    private FingerprintedQName resultNamespace;
    private FingerprintedQName resultAtomicValue;
    private FingerprintedQName resultFunction;
    private FingerprintedQName resultArray;
    private FingerprintedQName resultMap;
    private FingerprintedQName resultExternalValue;
    private FingerprintedQName xsiType;

    public SequenceWrapper(Receiver destination) {
        super(destination.getPipelineConfiguration());
        this.out = destination;
    }

    public Receiver getDestination() {
        return this.out;
    }

    @Override
    public void open() throws XPathException {
        FingerprintedQName resultSequence = new FingerprintedQName("result", RESULT_NS, "sequence");
        this.resultDocument = new FingerprintedQName("result", RESULT_NS, "document");
        this.resultElement = new FingerprintedQName("result", RESULT_NS, "element");
        this.resultAttribute = new FingerprintedQName("result", RESULT_NS, "attribute");
        this.resultText = new FingerprintedQName("result", RESULT_NS, "text");
        this.resultComment = new FingerprintedQName("result", RESULT_NS, "comment");
        this.resultPI = new FingerprintedQName("result", RESULT_NS, "processing-instruction");
        this.resultNamespace = new FingerprintedQName("result", RESULT_NS, "namespace");
        this.resultAtomicValue = new FingerprintedQName("result", RESULT_NS, "atomic-value");
        this.resultFunction = new FingerprintedQName("result", RESULT_NS, "function");
        this.resultArray = new FingerprintedQName("result", RESULT_NS, "array");
        this.resultMap = new FingerprintedQName("result", RESULT_NS, "map");
        this.resultExternalValue = new FingerprintedQName("result", RESULT_NS, "external-object");
        this.xsiType = new FingerprintedQName("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type");
        this.out.open();
        this.out.startDocument(0);
        this.out.startElement(resultSequence, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
        this.out.namespace(new NamespaceBinding("result", RESULT_NS), 0);
        this.out.namespace(new NamespaceBinding("xs", "http://www.w3.org/2001/XMLSchema"), 0);
        this.out.namespace(new NamespaceBinding("xsi", "http://www.w3.org/2001/XMLSchema-instance"), 0);
        this.out.startContent();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.out.startElement(this.resultDocument, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
        this.out.startContent();
        ++this.depth;
    }

    @Override
    public void endDocument() throws XPathException {
        this.out.endElement();
        --this.depth;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.depth++ == 0) {
            this.out.startElement(this.resultElement, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.out.startContent();
        }
        this.out.startElement(nameCode, typeCode, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.out.endElement();
        if (--this.depth == 0) {
            this.out.endElement();
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultAttribute, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            if (!attName.hasURI("")) {
                this.out.namespace(attName.getNamespaceBinding(), 0);
            }
            this.out.attribute(attName, typeCode, value, locationId, properties);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.attribute(attName, typeCode, value, locationId, properties);
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultNamespace, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.out.namespace(namespaceBindings, properties);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.namespace(namespaceBindings, properties);
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultText, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.out.startContent();
            this.out.characters(chars, locationId, properties);
            this.out.endElement();
        } else {
            this.out.characters(chars, locationId, properties);
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultComment, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.out.startContent();
            this.out.comment(chars, locationId, properties);
            this.out.endElement();
        } else {
            this.out.comment(chars, locationId, properties);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultPI, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.out.startContent();
            this.out.processingInstruction(target, data, locationId, properties);
            this.out.endElement();
        } else {
            this.out.processingInstruction(target, data, locationId, properties);
        }
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item instanceof AtomicValue) {
            NamePool pool = this.getNamePool();
            this.out.startElement(this.resultAtomicValue, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            AtomicType type = ((AtomicValue)item).getItemType();
            StructuredQName name = type.getStructuredQName();
            String prefix = name.getPrefix();
            String localName = name.getLocalPart();
            String uri = name.getURI();
            if (prefix.isEmpty() && (prefix = pool.suggestPrefixForURI(uri)) == null) {
                prefix = "p" + uri.hashCode();
            }
            String displayName = prefix + ':' + localName;
            this.out.namespace(new NamespaceBinding(prefix, uri), 0);
            this.out.attribute(this.xsiType, BuiltInAtomicType.UNTYPED_ATOMIC, displayName, locationId, 0);
            this.out.startContent();
            this.out.characters(item.getStringValue(), locationId, 0);
            this.out.endElement();
        } else if (item instanceof NodeInfo) {
            ((NodeInfo)item).copy(this, 6, locationId);
        } else if (item instanceof Function) {
            if (item instanceof MapItem) {
                this.out.startElement(this.resultMap, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
                this.out.startContent();
                this.out.characters(item.toShortString(), locationId, 0);
                this.out.endElement();
            } else if (item instanceof ArrayItem) {
                this.out.startElement(this.resultArray, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
                this.out.startContent();
                this.out.characters(item.toShortString(), locationId, 0);
                this.out.endElement();
            } else {
                this.out.startElement(this.resultFunction, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
                this.out.startContent();
                this.out.characters(((Function)item).getDescription(), locationId, 0);
                this.out.endElement();
            }
        } else if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            this.out.startElement(this.resultExternalValue, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.out.attribute(new NoNamespaceName("class"), BuiltInAtomicType.UNTYPED_ATOMIC, obj.getClass().getName(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.out.startContent();
            this.out.characters(obj.toString(), locationId, 0);
            this.out.endElement();
        }
    }

    @Override
    public void startContent() throws XPathException {
        this.out.startContent();
    }

    @Override
    public void close() throws XPathException {
        this.out.endElement();
        this.out.endDocument();
        this.out.close();
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }
}

