/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AbstractAndroidClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AndroidOClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AbstractAndroidClassLoadingAdapter;", "()V", "isApplicable", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "resolveClassLoaderClass", "Lcom/sun/jdi/ClassType;", "kotlin.jvm-debugger.evaluation"})
public final class AndroidOClassLoadingAdapter
extends AbstractAndroidClassLoadingAdapter {
    @Override
    public boolean isApplicable(@NotNull ExecutionContext context, @NotNull ClassLoadingAdapter.Companion.ClassInfoForEvaluator info) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        boolean bl = false;
        boolean bl2 = false;
        ClassLoadingAdapter.Companion.ClassInfoForEvaluator $this$with = info;
        boolean bl3 = false;
        return $this$with.isCompilingEvaluatorPreferred() && NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)((DebugProcess)context.getDebugProcess()));
    }

    private final ClassType resolveClassLoaderClass(ExecutionContext context) {
        ClassType classType;
        try {
            ClassLoaderReference classLoader = context.getClassLoader();
            ReferenceType referenceType = this.tryLoadClass(context, "dalvik.system.InMemoryDexClassLoader", classLoader);
            if (!(referenceType instanceof ClassType)) {
                referenceType = null;
            }
            classType = (ClassType)referenceType;
        }
        catch (EvaluateException e) {
            classType = null;
        }
        return classType;
    }

    @Override
    @NotNull
    public ClassLoaderReference loadClasses(@NotNull ExecutionContext context, @NotNull Collection<ClassToLoad> classes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        ClassType classType = this.resolveClassLoaderClass(context);
        if (classType == null) {
            String string = "InMemoryDexClassLoader class not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ClassType inMemoryClassLoaderClass = classType;
        Method method = inMemoryClassLoaderClass.concreteMethodByName("<init>", "(Ljava/nio/ByteBuffer;Ljava/lang/ClassLoader;)V");
        if (method == null) {
            String string = "Constructor method not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Method constructorMethod = method;
        byte[] byArray = this.dex(context, classes);
        if (byArray == null) {
            String string = "Can't dex classes";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] dexBytes = byArray;
        ArrayReference dexBytesMirror = this.mirrorOfByteArray(dexBytes, context);
        ObjectReference dexByteBuffer = this.wrapToByteBuffer(dexBytesMirror, context);
        ClassLoaderReference classLoader = context.getClassLoader();
        List args = CollectionsKt.listOf((Object[])new ObjectReference[]{dexByteBuffer, classLoader});
        ObjectReference objectReference = context.newInstance(inMemoryClassLoaderClass, constructorMethod, args);
        if (objectReference == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ClassLoaderReference");
        }
        ClassLoaderReference newClassLoader = (ClassLoaderReference)objectReference;
        context.keepReference((ObjectReference)newClassLoader);
        return newClassLoader;
    }
}

