/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaAnnotationUtil {
    private static final TObjectHashingStrategy<PsiClass> HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        public int computeHashCode(PsiClass object) {
            String qualifiedName = object.getQualifiedName();
            return qualifiedName == null ? 0 : qualifiedName.hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            return Objects.equals(o1.getQualifiedName(), o2.getQualifiedName());
        }
    };

    public static Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull Module module, String annotationName, boolean includeTests) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(0);
        }
        Project project = module.getProject();
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(key -> {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)((Boolean)key.getSecond()));
                PsiClass annotationClass = JavaPsiFacade.getInstance(project).findClass((String)key.getFirst(), moduleScope);
                if (annotationClass == null || !annotationClass.isAnnotationType()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope effectiveSearchScope = MetaAnnotationUtil.getAllAnnotationFilesScope(project).intersectWith(moduleScope);
                return MetaAnnotationUtil.getAnnotationTypesWithChildren(annotationClass, effectiveSearchScope);
            });
            return CachedValueProvider.Result.create((Object)factoryMap, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (Collection)map.get(Pair.pair((Object)annotationName, (Object)includeTests));
    }

    public static Set<PsiClass> getChildren(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        if (psiClass == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(2);
        }
        if (AnnotationTargetUtil.findAnnotationTarget(psiClass, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE) == null) {
            return Collections.emptySet();
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(HASHING_STRATEGY);
        AnnotatedElementsSearch.searchPsiClasses(psiClass, (SearchScope)scope).forEach(arg_0 -> MetaAnnotationUtil.lambda$getChildren$2((Set)result, arg_0));
        return result;
    }

    public static Collection<PsiClass> getAnnotatedTypes(@NotNull Module module, @NotNull String annotationName) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(3);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(4);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(key -> MetaAnnotationUtil.findAnnotatedTypes(module, key));
            return new CachedValueProvider.Result((Object)factoryMap, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (Collection)map.get(annotationName);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static Collection<PsiClass> getAnnotatedTypes(@NotNull Module module, @NotNull Key<CachedValue<Collection<PsiClass>>> key, @NotNull String annotationName) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(5);
        }
        if (key == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(6);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(7);
        }
        return MetaAnnotationUtil.getAnnotatedTypes(module, annotationName);
    }

    @NotNull
    private static Collection<PsiClass> findAnnotatedTypes(@NotNull Module module, @NotNull String annotationName) {
        if (module == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(8);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(9);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        PsiClass psiClass = JavaPsiFacade.getInstance(module.getProject()).findClass(annotationName, scope);
        if (psiClass == null || !psiClass.isAnnotationType()) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                MetaAnnotationUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        Set<PsiClass> set = MetaAnnotationUtil.getChildren(psiClass, scope);
        if (set == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    private static Collection<PsiClass> getAnnotationTypesWithChildren(PsiClass annotationClass, GlobalSearchScope scope) {
        THashSet classes = new THashSet(HASHING_STRATEGY);
        MetaAnnotationUtil.collectClassWithChildren(annotationClass, (Set<? super PsiClass>)classes, scope);
        THashSet tHashSet = classes;
        if (tHashSet == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    private static GlobalSearchScope getAllAnnotationFilesScope(Project project) {
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            FileIdScope javaScope = new FileIdScope(project, MetaAnnotationUtil.getJavaAnnotationInheritorIds(project));
            GlobalSearchScope otherScope = MetaAnnotationUtil.searchForAnnotationInheritorsInOtherLanguages(project);
            return CachedValueProvider.Result.createSingleDependency((Object)javaScope.uniteWith(otherScope), (Object)PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    @NotNull
    private static GlobalSearchScope searchForAnnotationInheritorsInOtherLanguages(Project project) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        HashSet allAnnotationFiles = new HashSet();
        for (PsiClass javaLangAnnotation : JavaPsiFacade.getInstance(project).findClasses("java.lang.annotation.Annotation", allScope)) {
            DirectClassInheritorsSearch.SearchParameters parameters = new DirectClassInheritorsSearch.SearchParameters(javaLangAnnotation, (SearchScope)allScope, false, true){

                @Override
                public boolean shouldSearchInLanguage(@NotNull Language language2) {
                    if (language2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return language2 != JavaLanguage.INSTANCE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/MetaAnnotationUtil$2", "shouldSearchInLanguage"));
                }
            };
            DirectClassInheritorsSearch.search(parameters).forEach(annotationClass -> {
                ProgressManager.checkCanceled();
                ContainerUtil.addIfNotNull((Collection)allAnnotationFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)annotationClass));
                return true;
            });
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope((Project)project, allAnnotationFiles);
        if (globalSearchScope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    private static TIntHashSet getJavaAnnotationInheritorIds(Project project) {
        IdIterator iterator = StubIndex.getInstance().getContainingIds(JavaStubIndexKeys.SUPER_CLASSES, (Object)"Annotation", project, GlobalSearchScope.allScope((Project)project));
        TIntHashSet idSet = new TIntHashSet();
        while (iterator.hasNext()) {
            idSet.add(iterator.next());
        }
        TIntHashSet tIntHashSet = idSet;
        if (tIntHashSet == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(14);
        }
        return tIntHashSet;
    }

    private static void collectClassWithChildren(PsiClass psiClass, Set<? super PsiClass> classes, GlobalSearchScope scope) {
        classes.add(psiClass);
        for (PsiClass aClass : MetaAnnotationUtil.getChildren(psiClass, scope)) {
            if (classes.contains(aClass)) continue;
            MetaAnnotationUtil.collectClassWithChildren(aClass, classes, scope);
        }
    }

    public static boolean isMetaAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(15);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(16);
        }
        if (AnnotationUtil.isAnnotated(listOwner, annotations, 0)) {
            return true;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner);
        for (String annotationFQN : annotations) {
            for (PsiClass resolvedAnnotation : resolvedAnnotations) {
                if (MetaAnnotationUtil.metaAnnotationCached(resolvedAnnotation, annotationFQN) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(17);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(18);
        }
        return MetaAnnotationUtil.isMetaAnnotatedInHierarchy(listOwner, annotations, new HashSet());
    }

    public static boolean hasMetaAnnotatedMethods(@NotNull PsiClass psiClass, @NotNull Collection<String> annotations) {
        if (psiClass == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(19);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(20);
        }
        return Stream.of(psiClass.getMethods()).anyMatch(psiMethod -> MetaAnnotationUtil.isMetaAnnotated(psiMethod, annotations));
    }

    private static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, Set<? super PsiMember> visited) {
        block6: {
            block5: {
                if (listOwner == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(21);
                }
                if (annotations == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(22);
                }
                if (MetaAnnotationUtil.isMetaAnnotated(listOwner, annotations)) {
                    return true;
                }
                if (!(listOwner instanceof PsiClass)) break block5;
                for (PsiClass superClass : ((PsiClass)listOwner).getSupers()) {
                    if (!visited.add(superClass) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(superClass, annotations, visited)) continue;
                    return true;
                }
                break block6;
            }
            if (!(listOwner instanceof PsiMethod)) break block6;
            for (PsiMethod method : ((PsiMethod)listOwner).findSuperMethods()) {
                if (!visited.add(method) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(method, annotations, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiAnnotation metaAnnotationCached(PsiClass subjectAnnotation, String annotationToFind) {
        return (PsiAnnotation)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)subjectAnnotation, () -> {
            ConcurrentMap metaAnnotationsMap = ConcurrentFactoryMap.createMap(anno -> MetaAnnotationUtil.findMetaAnnotation(subjectAnnotation, anno, new HashSet()));
            return new CachedValueProvider.Result((Object)metaAnnotationsMap, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        })).get(annotationToFind);
    }

    @Nullable
    private static PsiAnnotation findMetaAnnotation(PsiClass aClass, String annotation, Set<? super PsiClass> visited) {
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, true, annotation);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(aClass);
        for (PsiClass resolvedAnnotation : resolvedAnnotations) {
            PsiAnnotation annotated;
            if (!visited.add(resolvedAnnotation) || (annotated = MetaAnnotationUtil.findMetaAnnotation(resolvedAnnotation, annotation, visited)) == null) continue;
            return annotated;
        }
        return null;
    }

    @NotNull
    public static Stream<PsiAnnotation> findMetaAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(23);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(24);
        }
        Stream<PsiAnnotation> directAnnotations = Stream.of(AnnotationUtil.findAnnotations(listOwner, annotations));
        Stream lazyResolvedAnnotations = Stream.generate(() -> MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner)).limit(1L).flatMap(it -> it.stream());
        Stream<PsiAnnotation> metaAnnotations = lazyResolvedAnnotations.flatMap(psiClass -> annotations.stream().map(annotationFQN -> MetaAnnotationUtil.metaAnnotationCached(psiClass, annotationFQN))).filter(Objects::nonNull);
        Stream<PsiAnnotation> stream = Stream.concat(directAnnotations, metaAnnotations);
        if (stream == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(25);
        }
        return stream;
    }

    private static List<PsiClass> getResolvedClassesInAnnotationsList(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            return ContainerUtil.mapNotNull((Object[])modifierList.getApplicableAnnotations(), annotation -> annotation.resolveAnnotationType());
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ boolean lambda$getChildren$2(Set result, PsiClass processorResult) {
        ProgressManager.checkCanceled();
        if (processorResult.isAnnotationType()) {
            result.add(processorResult);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 15: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotatedTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationTypesWithChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "searchForAnnotationInheritorsInOtherLanguages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaAnnotationInheritorIds";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findMetaAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildren";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedTypes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotatedTypes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotatedInHierarchy";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasMetaAnnotatedMethods";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findMetaAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileIdScope
    extends GlobalSearchScope {
        private final TIntHashSet myIdSet;

        FileIdScope(Project project, TIntHashSet idSet) {
            super(project);
            this.myIdSet = idSet;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FileIdScope.$$$reportNull$$$0(0);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                FileIdScope.$$$reportNull$$$0(1);
            }
            return file instanceof VirtualFileWithId && this.myIdSet.contains(((VirtualFileWithId)file).getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/MetaAnnotationUtil$FileIdScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

