/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteRepositoryDescription {
    public static final RemoteRepositoryDescription MAVEN_CENTRAL = new RemoteRepositoryDescription("central", "Maven Central repository", "https://repo1.maven.org/maven2");
    public static final RemoteRepositoryDescription JBOSS_COMMUNITY = new RemoteRepositoryDescription("jboss.community", "JBoss Community repository", "https://repository.jboss.org/nexus/content/repositories/public/");
    public static final List<RemoteRepositoryDescription> DEFAULT_REPOSITORIES = ContainerUtil.immutableList((Object[])new RemoteRepositoryDescription[]{MAVEN_CENTRAL, JBOSS_COMMUNITY});
    private final String myId;
    private final String myName;
    @NlsSafe
    private final String myUrl;
    private final boolean myAllowSnapshots;

    public RemoteRepositoryDescription(@NonNls @NotNull String id, @NotNull String name, @NotNull String url) {
        if (id == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(1);
        }
        if (url == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(2);
        }
        this(id, name, url, true);
    }

    public RemoteRepositoryDescription(@NotNull String id, @NotNull String name, @NotNull String url, boolean allowSnapshots) {
        if (id == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(3);
        }
        if (name == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(4);
        }
        if (url == null) {
            RemoteRepositoryDescription.$$$reportNull$$$0(5);
        }
        this.myId = id;
        this.myName = name;
        this.myUrl = url;
        this.myAllowSnapshots = allowSnapshots;
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    @NlsSafe
    public String getUrl() {
        return this.myUrl;
    }

    public boolean isAllowSnapshots() {
        return this.myAllowSnapshots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoryDescription that = (RemoteRepositoryDescription)o;
        return this.myAllowSnapshots == that.myAllowSnapshots && this.myId.equals(that.myId) && this.myName.equals(that.myName) && this.myUrl.equals(that.myUrl);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myName, this.myUrl, this.myAllowSnapshots);
    }

    public String toString() {
        return this.myId + ":" + this.myName + ":" + this.myUrl + " (snapshots=" + this.myAllowSnapshots + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "id";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "url";
                break;
            }
        }
        objectArray[1] = "com/intellij/jarRepository/RemoteRepositoryDescription";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

