/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.reference.SoftReference;
import com.intellij.ui.Gray;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.MenuBarIconProvider;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance(IconLoader.class);
    private static final ConcurrentMap<Object, CachedImageIcon> iconCache = new ConcurrentHashMap<Object, CachedImageIcon>(100, 0.9f, 2);
    private static final Cache<Icon, Icon> iconToDisabledIcon = Caffeine.newBuilder().weakKeys().build();
    private static volatile boolean STRICT_GLOBAL;
    private static final ThreadLocal<Boolean> STRICT_LOCAL;
    private static final AtomicReference<IconTransform> pathTransform;
    private static final AtomicInteger pathTransformGlobalModCount;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static <T> T performStrictly(@NotNull Supplier<? extends T> computable) {
        if (computable == null) {
            IconLoader.$$$reportNull$$$0(0);
        }
        STRICT_LOCAL.set(true);
        try {
            T t = computable.get();
            return t;
        }
        finally {
            STRICT_LOCAL.set(false);
        }
    }

    public static void setStrictGlobally(boolean strict) {
        STRICT_GLOBAL = strict;
    }

    private static void updateTransform(@NotNull @NotNull Function<? super IconTransform, @NotNull IconTransform> updater) {
        IconTransform next;
        IconTransform prev;
        if (updater == null) {
            IconLoader.$$$reportNull$$$0(1);
        }
        while (!pathTransform.compareAndSet(prev = pathTransform.get(), next = updater.apply(prev))) {
        }
        pathTransformGlobalModCount.incrementAndGet();
        if (prev != next) {
            iconToDisabledIcon.invalidateAll();
            ImageLoader.clearCache();
        }
    }

    public static void installPathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconLoader.$$$reportNull$$$0(2);
        }
        IconLoader.updateTransform(transform -> transform.withPathPatcher(patcher));
    }

    public static void removePathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconLoader.$$$reportNull$$$0(3);
        }
        IconLoader.updateTransform(transform -> transform.withoutPathPatcher(patcher));
    }

    @Deprecated
    @NotNull
    public static Icon getIcon(@NotNull Image image) {
        if (image == null) {
            IconLoader.$$$reportNull$$$0(4);
        }
        return new JBImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        IconLoader.updateTransform(transform -> transform.withDark(useDarkIcons));
    }

    public static void setFilter(ImageFilter filter) {
        IconLoader.updateTransform(transform -> transform.withFilter(filter));
    }

    public static void clearCache() {
        IconLoader.updateTransform(IconTransform::copy);
    }

    @Deprecated
    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(5);
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        return IconLoader.getIcon(path, callerClass);
    }

    @Nullable
    public static Icon getReflectiveIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(6);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(7);
        }
        try {
            @NonNls String packageName = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> aClass = Class.forName(packageName + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = aClass.getField(path.substring(path.lastIndexOf(46) + 1));
            field.setAccessible(true);
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path) {
        Class callerClass;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(8);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    @Deprecated
    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path, boolean strict) {
        Class callerClass;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(9);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass, callerClass.getClassLoader(), strict ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE, false);
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class<?> aClass) {
        Icon icon;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(10);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(11);
        }
        if ((icon = IconLoader.findIcon(path, aClass, aClass.getClassLoader(), null, true)) == null) {
            throw new IllegalStateException("Icon cannot be found in '" + path + "', class='" + aClass.getName() + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(12);
        }
        return icon2;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static ImageDataLoader loadRasterizedIcon(@NotNull String path, @NotNull ClassLoader classLoader, long cacheKey, int n) {
        void imageFlags;
        String effectivePath;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(13);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(14);
        }
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        Pair<String, ClassLoader> patchedPath = pathTransform.get().patchPath(path, classLoader);
        String string = effectivePath = patchedPath == null ? path : (String)patchedPath.first;
        if (patchedPath != null && patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        RasterizedImageDataLoader resolver = new RasterizedImageDataLoader(effectivePath, classLoader, cacheKey, (int)imageFlags);
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        RasterizedImageDataLoader rasterizedImageDataLoader = resolver;
        if (rasterizedImageDataLoader == null) {
            IconLoader.$$$reportNull$$$0(15);
        }
        return rasterizedImageDataLoader;
    }

    @Nullable
    private static ImageDataLoader createNewResolverIfNeeded(@Nullable ClassLoader originalClassLoader, @NotNull String originalPath, @NotNull IconTransform transform) {
        Pair<String, ClassLoader> patchedPath;
        if (originalPath == null) {
            IconLoader.$$$reportNull$$$0(16);
        }
        if (transform == null) {
            IconLoader.$$$reportNull$$$0(17);
        }
        if ((patchedPath = transform.patchPath(originalPath, originalClassLoader)) == null) {
            return null;
        }
        ClassLoader classLoader = patchedPath.second == null ? originalClassLoader : (ClassLoader)patchedPath.second;
        String path = (String)patchedPath.first;
        if (path != null && path.startsWith("/")) {
            return new FinalImageDataLoader(path.substring(1), classLoader == null ? transform.getClass().getClassLoader() : classLoader);
        }
        if (path != null && path.startsWith("file:/")) {
            try {
                ImageDataResolverImpl resolver = new ImageDataResolverImpl(new URL(path), path.substring(1), classLoader, false);
                resolver.resolve();
                return resolver;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    @TestOnly
    public static void deactivate() {
        ourIsActivated = false;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findLafIcon(@NotNull String key, @NotNull Class<?> aClass, boolean strict) {
        if (key == null) {
            IconLoader.$$$reportNull$$$0(18);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(19);
        }
        return IconLoader.findIcon(key + ".png", aClass, aClass.getClassLoader(), strict ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE, true);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class<?> aClass) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(20);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(21);
        }
        return IconLoader.findIcon(path, aClass, aClass.getClassLoader(), null, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class<?> aClass, boolean deferUrlResolve, boolean strict) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(22);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(23);
        }
        return IconLoader.findIcon(path, aClass, aClass.getClassLoader(), strict ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE, deferUrlResolve);
    }

    private static boolean isReflectivePath(@NotNull String path) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(24);
        }
        if (path.isEmpty() || path.charAt(0) == '/') {
            return false;
        }
        int dotIndex = path.indexOf(46);
        if (dotIndex < 0) {
            return false;
        }
        int suffixLength = "Icons".length();
        return path.regionMatches(dotIndex - suffixLength, "Icons", 0, suffixLength);
    }

    @Nullable
    public static Icon findIcon(@Nullable URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(@Nullable URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        if (useCache) {
            return iconCache.computeIfAbsent(url, url1 -> new CachedImageIcon((URL)url1, true));
        }
        CachedImageIcon icon = (CachedImageIcon)iconCache.get(url);
        return icon == null ? new CachedImageIcon(url, false) : icon;
    }

    @ApiStatus.Internal
    @Nullable
    public static Icon findIcon(@NotNull String originalPath, @Nullable Class<?> clazz, @NotNull ClassLoader classLoader, @Nullable HandleNotFound handleNotFound, boolean deferUrlResolve) {
        Icon icon;
        String path;
        if (originalPath == null) {
            IconLoader.$$$reportNull$$$0(25);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(26);
        }
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        Pair<String, ClassLoader> patchedPath = pathTransform.get().patchPath(originalPath, classLoader);
        String string = path = patchedPath == null ? originalPath : (String)patchedPath.first;
        if (patchedPath != null && patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path)) {
            icon = IconLoader.getReflectiveIcon(path, classLoader);
        } else {
            Pair key = new Pair((Object)originalPath, (Object)classLoader);
            CachedImageIcon cachedIcon = (CachedImageIcon)iconCache.get(key);
            if (cachedIcon == null) {
                cachedIcon = iconCache.computeIfAbsent(key, k -> {
                    ImageDataLoader resolver;
                    ClassLoader classLoader1 = (ClassLoader)((Pair)k).getSecond();
                    if (deferUrlResolve) {
                        resolver = new ImageDataResolverImpl(path, clazz, classLoader1, handleNotFound, true);
                    } else {
                        URL url = IconLoader.doResolve(originalPath, classLoader1, null, HandleNotFound.IGNORE);
                        if (url == null) {
                            return null;
                        }
                        resolver = new ResolvedImageDataResolver(url, classLoader1);
                    }
                    return new CachedImageIcon(originalPath, resolver, null, null);
                });
            } else {
                ScaleContext scaleContext = ScaleContext.create();
                if (!((ScaleContext)cachedIcon.getScaleContext()).equals(scaleContext)) {
                    cachedIcon = cachedIcon.copy();
                    cachedIcon.updateScaleContext(scaleContext);
                }
            }
            icon = cachedIcon;
        }
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        return icon;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(27);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(28);
        }
        return IconLoader.findIcon(path, null, classLoader, HandleNotFound.IGNORE, false);
    }

    @Nullable
    public static Image toImage(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(29);
        }
        return IconLoader.toImage(icon, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Image toImage(@NotNull Icon icon, @Nullable ScaleContext ctx) {
        BufferedImage image;
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(30);
        }
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).getRealIcon(ctx);
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        if (icon.getIconWidth() <= 0 || icon.getIconHeight() <= 0) {
            return null;
        }
        if (GraphicsEnvironment.isHeadless()) {
            image = ImageUtil.createImage(ctx, (double)icon.getIconWidth(), (double)icon.getIconHeight(), 2, PaintUtil.RoundingMode.ROUND);
        } else {
            if (ctx == null) {
                ctx = ScaleContext.create();
            }
            image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(PaintUtil.RoundingMode.ROUND.round(ctx.apply((double)icon.getIconWidth(), DerivedScaleType.DEV_SCALE)), PaintUtil.RoundingMode.ROUND.round(ctx.apply((double)icon.getIconHeight(), DerivedScaleType.DEV_SCALE)), 3);
            if (StartupUiUtil.isJreHiDPI(ctx)) {
                image = (BufferedImage)ImageUtil.ensureHiDPI(image, ctx, icon.getIconWidth(), icon.getIconHeight());
            }
        }
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(null, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null, _, _->null; !null, _, _->!null")
    public static Icon copy(final @Nullable Icon icon, @Nullable Component ancestor, boolean deepCopy) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof CopyableIcon) {
            return deepCopy ? ((CopyableIcon)icon).deepCopy() : ((CopyableIcon)icon).copy();
        }
        BufferedImage image = ImageUtil.createImage(ancestor == null ? null : ancestor.getGraphicsConfiguration(), icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(ancestor, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return new JBImageIcon((Image)image){
            final int originalWidth;
            final int originalHeight;
            {
                super(image);
                this.originalWidth = icon.getIconWidth();
                this.originalHeight = icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return this.originalWidth;
            }

            @Override
            public int getIconHeight() {
                return this.originalHeight;
            }
        };
    }

    @Nullable
    private static ImageIcon checkIcon(@NotNull Image image, @NotNull CachedImageIcon cii) {
        if (image == null) {
            IconLoader.$$$reportNull$$$0(31);
        }
        if (cii == null) {
            IconLoader.$$$reportNull$$$0(32);
        }
        if (image.getHeight(null) < 1) {
            return null;
        }
        JBImageIcon icon = new JBImageIcon(image);
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + cii);
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(33);
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @NotNull
    public static Icon getDisabledIcon(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(34);
        }
        return IconLoader.getDisabledIcon(icon, null);
    }

    @NotNull
    public static Icon getDisabledIcon(@NotNull Icon icon, @Nullable Component ancestor) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(35);
        }
        if (!ourIsActivated) {
            Icon icon2 = icon;
            if (icon2 == null) {
                IconLoader.$$$reportNull$$$0(36);
            }
            return icon2;
        }
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        Icon icon3 = Objects.requireNonNull((Icon)iconToDisabledIcon.get((Object)icon, it -> IconLoader.filterIcon(it, UIUtil::getGrayFilter, ancestor)));
        if (icon3 == null) {
            IconLoader.$$$reportNull$$$0(37);
        }
        return icon3;
    }

    @NotNull
    public static Icon filterIcon(@NotNull Icon icon, @NotNull Supplier<? extends RGBImageFilter> filterSupplier, @Nullable Component ancestor) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(38);
        }
        if (filterSupplier == null) {
            IconLoader.$$$reportNull$$$0(39);
        }
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error((Object)icon);
            ImageIcon imageIcon = EMPTY_ICON;
            if (imageIcon == null) {
                IconLoader.$$$reportNull$$$0(40);
            }
            return imageIcon;
        }
        if (icon instanceof CachedImageIcon) {
            Icon icon2 = ((CachedImageIcon)icon).createWithFilter(filterSupplier);
            if (icon2 == null) {
                IconLoader.$$$reportNull$$$0(41);
            }
            return icon2;
        }
        ScaleContextSupport ctxSupport = IconLoader.getScaleContextSupport(icon);
        double scale = ctxSupport == null ? (JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)null) ? (double)JBUIScale.sysScale(ancestor) : 1.0) : (JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)null) ? ctxSupport.getScale(ScaleType.SYS_SCALE) : 1.0);
        BufferedImage image = new BufferedImage((int)(scale * (double)icon.getIconWidth()), (int)(scale * (double)icon.getIconHeight()), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Gray.TRANSPARENT);
        graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        graphics.scale(scale, scale);
        icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
        graphics.dispose();
        Image img = ImageUtil.filter(image, filterSupplier.get());
        if (StartupUiUtil.isJreHiDPI(ancestor)) {
            img = RetinaImage.createFrom(img, scale, null);
        }
        return new JBImageIcon(img);
    }

    @NotNull
    public static Icon getTransparentIcon(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(42);
        }
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    @NotNull
    public static Icon getTransparentIcon(final @NotNull Icon icon, final float alpha) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(43);
        }
        return new RetrievableIcon(){

            @Override
            @NotNull
            public Icon retrieveIcon() {
                Icon icon2 = icon;
                if (icon2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$4", "retrieveIcon"));
            }
        };
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(44);
        }
        if (icon instanceof CachedImageIcon) {
            ImageIcon imageIcon = ((CachedImageIcon)icon).getRealIcon();
            if (imageIcon == null) {
                IconLoader.$$$reportNull$$$0(45);
            }
            return imageIcon;
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(46);
        }
        return icon2;
    }

    @ApiStatus.Internal
    @NotNull
    public static Icon getMenuBarIcon(@NotNull Icon icon, boolean dark) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(47);
        }
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof MenuBarIconProvider) {
            Icon icon2 = ((MenuBarIconProvider)((Object)icon)).getMenuBarIcon(dark);
            if (icon2 == null) {
                IconLoader.$$$reportNull$$$0(48);
            }
            return icon2;
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            IconLoader.$$$reportNull$$$0(49);
        }
        return icon3;
    }

    @NotNull
    public static Icon getDarkIcon(@NotNull Icon icon, boolean dark) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(50);
        }
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof DarkIconProvider) {
            Icon icon2 = ((DarkIconProvider)icon).getDarkIcon(dark);
            if (icon2 == null) {
                IconLoader.$$$reportNull$$$0(51);
            }
            return icon2;
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            IconLoader.$$$reportNull$$$0(52);
        }
        return icon3;
    }

    public static void detachClassLoader(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(53);
        }
        iconCache.entrySet().removeIf(entry -> {
            CachedImageIcon icon = (CachedImageIcon)entry.getValue();
            icon.detachClassLoader(classLoader);
            Object key = entry.getKey();
            return key instanceof Pair && ((Pair)key).second == classLoader;
        });
        iconToDisabledIcon.asMap().keySet().removeIf(icon -> icon instanceof CachedImageIcon && ((CachedImageIcon)icon).detachClassLoader(classLoader));
    }

    @Nullable
    static URL doResolve(@Nullable String path, @Nullable ClassLoader classLoader, @Nullable Class<?> ownerClass, @NotNull HandleNotFound handleNotFound) {
        if (handleNotFound == null) {
            IconLoader.$$$reportNull$$$0(54);
        }
        URL url = null;
        if (path != null) {
            if (classLoader != null) {
                path = path.charAt(0) == '/' ? path.substring(1) : path;
                url = IconLoader.findUrl(path, classLoader::getResource);
            }
            if (url == null && ownerClass != null) {
                url = IconLoader.findUrl(path, ownerClass::getResource);
            }
        }
        if (url == null) {
            handleNotFound.handle("Can't find icon in '" + path + "' near " + classLoader);
        }
        return url;
    }

    @Nullable
    private static URL findUrl(@NotNull String path, @NotNull Function<? super String, URL> urlProvider) {
        URL url;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(55);
        }
        if (urlProvider == null) {
            IconLoader.$$$reportNull$$$0(56);
        }
        if ((url = urlProvider.apply((String)path)) != null) {
            return url;
        }
        if (((String)path).endsWith(".png")) {
            path = ((String)path).substring(0, ((String)path).length() - 4) + ".svg";
        } else if (((String)path).endsWith(".svg")) {
            path = ((String)path).substring(0, ((String)path).length() - 4) + ".png";
        } else {
            LOG.debug("unexpected path: ", new Object[]{path});
        }
        return urlProvider.apply((String)path);
    }

    @NotNull
    public static Icon createLazy(final @NotNull @NotNull Supplier<? extends @NotNull Icon> producer) {
        if (producer == null) {
            IconLoader.$$$reportNull$$$0(57);
        }
        return new LazyIcon(){

            @Override
            @NotNull
            protected Icon compute() {
                Icon icon = (Icon)producer.get();
                if (icon == null) {
                    5.$$$reportNull$$$0(0);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$5", "compute"));
            }
        };
    }

    @NotNull
    private static Icon getOrigin(@NotNull RetrievableIcon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(58);
        }
        int maxDeep = 10;
        Icon origin = icon.retrieveIcon();
        for (int level = 0; origin instanceof RetrievableIcon && level < 10; ++level) {
            origin = ((RetrievableIcon)origin).retrieveIcon();
        }
        if (origin instanceof RetrievableIcon) {
            LOG.error("can't calculate origin icon (too deep in hierarchy), src: " + icon);
        }
        Icon icon2 = origin;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(59);
        }
        return icon2;
    }

    @Nullable
    private static ScaleContextSupport getScaleContextSupport(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(60);
        }
        if (icon instanceof ScaleContextSupport) {
            return (ScaleContextSupport)((Object)icon);
        }
        if (icon instanceof RetrievableIcon) {
            return IconLoader.getScaleContextSupport(((RetrievableIcon)icon).retrieveIcon());
        }
        if (icon instanceof CompositeIcon) {
            return IconLoader.getScaleContextSupport(Objects.requireNonNull(((CompositeIcon)icon).getIcon(0)));
        }
        return null;
    }

    static {
        STRICT_LOCAL = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }

            @Override
            public Boolean get() {
                return STRICT_GLOBAL || (Boolean)super.get() != false;
            }
        };
        pathTransform = new AtomicReference<IconTransform>(new IconTransform(StartupUiUtil.isUnderDarcula(), new IconPathPatcher[]{new DeprecatedDuplicatesIconPathPatcher()}, null));
        pathTransformGlobalModCount = new AtomicInteger();
        EMPTY_ICON = new ImageIcon(new BufferedImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 4: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 14: 
            case 26: 
            case 28: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 50: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cii";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterSupplier";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handleNotFound";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlProvider";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRasterizedIcon";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIcon";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconSnapshot";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getMenuBarIcon";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDarkIcon";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performStrictly";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateTransform";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installPathPatcher";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removePathPatcher";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReflectiveIcon";
                break;
            }
            case 8: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 59: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadRasterizedIcon";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createNewResolverIfNeeded";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLafIcon";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isReflectivePath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkIcon";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isGoodSize";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDisabledIcon";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getTransparentIcon";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getIconSnapshot";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getMenuBarIcon";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getDarkIcon";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "detachClassLoader";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findUrl";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createLazy";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getOrigin";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getScaleContextSupport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IconTransform {
        private final boolean myDark;
        private final IconPathPatcher @NotNull [] myPatchers;
        @Nullable
        private final ImageFilter myFilter;

        private IconTransform(boolean dark, IconPathPatcher @NotNull [] patchers, @Nullable ImageFilter filter) {
            if (patchers == null) {
                IconTransform.$$$reportNull$$$0(0);
            }
            this.myDark = dark;
            this.myPatchers = patchers;
            this.myFilter = filter;
        }

        boolean isDark() {
            return this.myDark;
        }

        @Nullable
        ImageFilter getFilter() {
            return this.myFilter;
        }

        @NotNull
        IconTransform withPathPatcher(@NotNull IconPathPatcher patcher) {
            if (patcher == null) {
                IconTransform.$$$reportNull$$$0(1);
            }
            return new IconTransform(this.myDark, (IconPathPatcher[])ArrayUtil.append((Object[])this.myPatchers, (Object)patcher), this.myFilter);
        }

        @NotNull
        IconTransform withoutPathPatcher(@NotNull IconPathPatcher patcher) {
            IconPathPatcher[] newPatchers;
            if (patcher == null) {
                IconTransform.$$$reportNull$$$0(2);
            }
            return (newPatchers = (IconPathPatcher[])ArrayUtil.remove((Object[])this.myPatchers, (Object)patcher)) == this.myPatchers ? this : new IconTransform(this.myDark, newPatchers, this.myFilter);
        }

        @NotNull
        public IconTransform withFilter(ImageFilter filter) {
            return filter == this.myFilter ? this : new IconTransform(this.myDark, this.myPatchers, filter);
        }

        @NotNull
        IconTransform withDark(boolean dark) {
            return dark == this.myDark ? this : new IconTransform(dark, this.myPatchers, this.myFilter);
        }

        @Nullable
        public Pair<String, ClassLoader> patchPath(@NotNull String path, @Nullable ClassLoader classLoader) {
            if (path == null) {
                IconTransform.$$$reportNull$$$0(3);
            }
            for (IconPathPatcher patcher : this.myPatchers) {
                Class contextClass;
                String newPath = patcher.patchPath(path, classLoader);
                if (newPath == null) continue;
                LOG.debug("replace '" + path + "' with '" + newPath + "'");
                ClassLoader contextClassLoader = patcher.getContextClassLoader(path, classLoader);
                if (contextClassLoader == null && (contextClass = patcher.getContextClass(path)) != null) {
                    contextClassLoader = contextClass.getClassLoader();
                }
                return new Pair((Object)newPath, (Object)contextClassLoader);
            }
            return null;
        }

        @NotNull
        public IconTransform copy() {
            return new IconTransform(this.myDark, this.myPatchers, this.myFilter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchers";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patcher";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/IconLoader$IconTransform";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withPathPatcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withoutPathPatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patchPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JComponent(){};

        private LabelHolder() {
        }
    }

    @ApiStatus.Internal
    public static abstract class LazyIcon
    extends ScaleContextSupport
    implements CopyableIcon,
    RetrievableIcon {
        private boolean myWasComputed;
        private volatile Icon myIcon;
        private int myTransformModCount = pathTransformGlobalModCount.get();

        @Deprecated
        public LazyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.updateScaleContext(ScaleContext.create((Graphics2D)g))) {
                this.myIcon = null;
            }
            Icon icon = this.getOrComputeIcon();
            icon.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon.getIconHeight();
        }

        @NotNull
        final synchronized Icon getOrComputeIcon() {
            Icon icon = this.myIcon;
            int newTransformModCount = pathTransformGlobalModCount.get();
            if (icon == null || !this.myWasComputed || this.myTransformModCount != newTransformModCount) {
                this.myTransformModCount = newTransformModCount;
                this.myWasComputed = true;
                try {
                    icon = this.compute();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Cannot compute icon", e);
                    icon = AllIcons.Actions.Stub;
                }
                this.myIcon = icon;
            }
            Icon icon2 = icon;
            if (icon2 == null) {
                LazyIcon.$$$reportNull$$$0(0);
            }
            return icon2;
        }

        public final void load() {
            this.getIconWidth();
        }

        @NotNull
        protected abstract Icon compute();

        @Override
        @NotNull
        public Icon retrieveIcon() {
            return this.getOrComputeIcon();
        }

        @Override
        @NotNull
        public Icon copy() {
            Icon icon = IconLoader.copy(this.getOrComputeIcon(), null, false);
            if (icon == null) {
                LazyIcon.$$$reportNull$$$0(1);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/util/IconLoader$LazyIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrComputeIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ImageDataResolverImpl
    implements ImageDataLoader {
        private static final URL UNRESOLVED_URL;
        @Nullable
        protected final Class<?> ownerClass;
        @Nullable
        protected final ClassLoader classLoader;
        @Nullable
        protected final String overriddenPath;
        @NotNull
        private final HandleNotFound handleNotFound;
        private volatile URL url;
        private final boolean useCacheOnLoad;

        ImageDataResolverImpl(@NotNull URL url, @Nullable ClassLoader classLoader, boolean useCacheOnLoad) {
            if (url == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(0);
            }
            this.ownerClass = null;
            this.overriddenPath = null;
            this.classLoader = classLoader;
            this.url = url;
            this.handleNotFound = HandleNotFound.IGNORE;
            this.useCacheOnLoad = useCacheOnLoad;
        }

        ImageDataResolverImpl(@NotNull URL url, @NotNull String path, @Nullable ClassLoader classLoader, boolean useCacheOnLoad) {
            if (url == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(1);
            }
            if (path == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(2);
            }
            this.ownerClass = null;
            this.overriddenPath = path;
            this.classLoader = classLoader;
            this.url = url;
            this.handleNotFound = HandleNotFound.IGNORE;
            this.useCacheOnLoad = useCacheOnLoad;
        }

        ImageDataResolverImpl(@NotNull String path, @Nullable Class<?> clazz, @Nullable ClassLoader classLoader, @Nullable HandleNotFound handleNotFound, boolean useCacheOnLoad) {
            if (path == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(3);
            }
            this.overriddenPath = path;
            this.ownerClass = clazz;
            this.classLoader = classLoader;
            if (handleNotFound == null) {
                handleNotFound = STRICT_LOCAL.get() != false ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE;
            }
            this.handleNotFound = handleNotFound;
            this.useCacheOnLoad = useCacheOnLoad;
            this.url = UNRESOLVED_URL;
        }

        @Override
        @Nullable
        public Image loadImage(@Nullable List<ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
            String path;
            if (scaleContext == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(4);
            }
            int flags = 9;
            if (this.useCacheOnLoad) {
                flags |= 2;
            }
            if (isDark) {
                flags |= 4;
            }
            if ((path = this.overriddenPath) == null || this.ownerClass == null && (this.classLoader == null || path.charAt(0) != '/')) {
                URL url = this.getURL();
                if (url == null) {
                    return null;
                }
                path = url.toString();
            }
            return ImageLoader.load(path, filters, this.ownerClass, this.classLoader, flags, scaleContext, !path.endsWith(".svg"));
        }

        public final void resolve() {
            this.getURL();
        }

        @Override
        @Nullable
        public final URL getURL() {
            URL result = this.url;
            if (result == UNRESOLVED_URL) {
                result = null;
                try {
                    result = IconLoader.doResolve(this.overriddenPath, this.classLoader, this.ownerClass, this.handleNotFound);
                }
                finally {
                    this.url = result;
                }
            }
            return result;
        }

        @Override
        @Nullable
        public final ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform) {
            if (originalPath == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(5);
            }
            if (transform == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(6);
            }
            return IconLoader.createNewResolverIfNeeded(this.classLoader, originalPath, transform);
        }

        @Override
        public final boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
            if (classLoader == null) {
                ImageDataResolverImpl.$$$reportNull$$$0(7);
            }
            return this.classLoader == classLoader;
        }

        public final String toString() {
            return "UrlResolver{ownerClass=" + (this.ownerClass == null ? "null" : this.ownerClass.getName()) + ", classLoader=" + this.classLoader + ", overriddenPath='" + this.overriddenPath + "', url=" + this.url + ", useCacheOnLoad=" + this.useCacheOnLoad + "}";
        }

        static {
            try {
                UNRESOLVED_URL = new URL("file:///unresolved");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPath";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLoader";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/IconLoader$ImageDataResolverImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadImage";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patch";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMyClassLoader";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ResolvedImageDataResolver
    implements ImageDataLoader {
        private final URL url;
        private final ClassLoader classLoader;

        ResolvedImageDataResolver(@NotNull URL url, @Nullable ClassLoader classLoader) {
            if (url == null) {
                ResolvedImageDataResolver.$$$reportNull$$$0(0);
            }
            this.classLoader = classLoader;
            this.url = url;
        }

        @Override
        @Nullable
        public Image loadImage(@Nullable List<ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
            String path;
            if (scaleContext == null) {
                ResolvedImageDataResolver.$$$reportNull$$$0(1);
            }
            int flags = 11;
            if (isDark) {
                flags |= 4;
            }
            return ImageLoader.load(path, filters, null, null, flags, scaleContext, !(path = this.url.toString()).endsWith(".svg"));
        }

        @Override
        @NotNull
        public URL getURL() {
            URL uRL = this.url;
            if (uRL == null) {
                ResolvedImageDataResolver.$$$reportNull$$$0(2);
            }
            return uRL;
        }

        @Override
        @Nullable
        public final ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform) {
            Pair<String, ClassLoader> patchedPath;
            if (originalPath == null) {
                ResolvedImageDataResolver.$$$reportNull$$$0(3);
            }
            if (transform == null) {
                ResolvedImageDataResolver.$$$reportNull$$$0(4);
            }
            if ((patchedPath = transform.patchPath(originalPath, this.classLoader)) == null) {
                return null;
            }
            ClassLoader classLoader = patchedPath.second == null ? null : (ClassLoader)patchedPath.second;
            String path = (String)patchedPath.first;
            if (path != null && path.startsWith("file:/")) {
                try {
                    ImageDataResolverImpl resolver = new ImageDataResolverImpl(new URL(path), path.substring(1), classLoader, true);
                    resolver.resolve();
                    return resolver;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public final boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
            if (classLoader == null) {
                ResolvedImageDataResolver.$$$reportNull$$$0(5);
            }
            return classLoader == this.classLoader;
        }

        public final String toString() {
            return "ResolvedImageDataResolver{, url=" + this.url + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/IconLoader$ResolvedImageDataResolver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/IconLoader$ResolvedImageDataResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadImage";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "patch";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isMyClassLoader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static interface ImageDataLoader {
        @Nullable
        public Image loadImage(@Nullable List<ImageFilter> var1, @NotNull ScaleContext var2, boolean var3);

        @Nullable
        public URL getURL();

        @Nullable
        public ImageDataLoader patch(@NotNull String var1, @NotNull IconTransform var2);

        public boolean isMyClassLoader(@NotNull ClassLoader var1);
    }

    static enum HandleNotFound {
        THROW_EXCEPTION{

            @Override
            void handle(@NotNull String msg) {
                if (msg == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new RuntimeException(msg);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/util/IconLoader$HandleNotFound$1", "handle"));
            }
        }
        ,
        LOG_ERROR{

            @Override
            void handle(@NotNull String msg) {
                if (msg == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.error(msg);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/util/IconLoader$HandleNotFound$2", "handle"));
            }
        }
        ,
        IGNORE;


        void handle(@NotNull String msg) throws RuntimeException {
            if (msg == null) {
                HandleNotFound.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/util/IconLoader$HandleNotFound", "handle"));
        }
    }

    private static final class ScaledIconCache {
        private static final int SCALED_ICONS_CACHE_LIMIT = 5;
        private final CachedImageIcon host;
        private final Map<Long, SoftReference<ImageIcon>> cache;

        private ScaledIconCache(@NotNull CachedImageIcon host) {
            if (host == null) {
                ScaledIconCache.$$$reportNull$$$0(0);
            }
            this.cache = Collections.synchronizedMap(new FixedHashMap(5));
            this.host = host;
        }

        private static long key(@NotNull ScaleContext context) {
            if (context == null) {
                ScaledIconCache.$$$reportNull$$$0(1);
            }
            return (long)Float.floatToIntBits((float)context.getScale(DerivedScaleType.EFF_USR_SCALE)) << 32 | (long)Float.floatToIntBits((float)context.getScale(ScaleType.SYS_SCALE)) & 0xFFFFFFFFL;
        }

        ImageIcon getOrScaleIcon(float scale) {
            long cacheKey;
            ImageIcon icon;
            ScaleContext scaleContext = (ScaleContext)this.host.getScaleContext();
            if (scale != 1.0f) {
                scaleContext = (ScaleContext)scaleContext.copy();
                scaleContext.setScale(ScaleType.OBJ_SCALE.of(scale));
            }
            if ((icon = (ImageIcon)SoftReference.dereference((Reference)((Reference)this.cache.get(cacheKey = ScaledIconCache.key(scaleContext))))) != null && !SVGLoader.isSelectionContext()) {
                return icon;
            }
            Image image = this.host.loadImage(scaleContext, this.host.isDark());
            if (image == null) {
                return null;
            }
            icon = IconLoader.checkIcon(image, this.host);
            if (icon != null && !ImageLoader.isIconTooLargeForCache(icon)) {
                this.cache.put(cacheKey, (SoftReference<ImageIcon>)new SoftReference((Object)icon));
            }
            return icon;
        }

        public void clear() {
            this.cache.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/IconLoader$ScaledIconCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "key";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class CachedImageIcon
    extends ScaleContextSupport
    implements CopyableIcon,
    ScalableIcon,
    DarkIconProvider,
    MenuBarIconProvider {
        @Nullable
        private final String originalPath;
        @Nullable
        private volatile ImageDataLoader resolver;
        @Nullable(value="when not overridden")
        private final @Nullable(value="when not overridden") Boolean isDarkOverridden;
        private int pathTransformModCount;
        @Nullable
        private final Supplier<? extends RGBImageFilter> localFilterSupplier;
        private final ScaledIconCache scaledIconCache;
        private final ScaledIconCache selectedIconCache;
        private volatile CachedImageIcon darkVariant;
        private final Object lock;
        @Nullable
        private volatile Object realIcon;

        public CachedImageIcon(@NotNull URL url) {
            if (url == null) {
                CachedImageIcon.$$$reportNull$$$0(0);
            }
            this(url, true);
        }

        CachedImageIcon(@NotNull URL url, boolean useCacheOnLoad) {
            if (url == null) {
                CachedImageIcon.$$$reportNull$$$0(1);
            }
            this(null, new ImageDataResolverImpl(url, null, useCacheOnLoad), null, null);
            this.pathTransformModCount = pathTransformGlobalModCount.get();
        }

        protected CachedImageIcon(@Nullable String originalPath, @Nullable ImageDataLoader resolver, @Nullable Boolean darkOverridden, @Nullable Supplier<? extends RGBImageFilter> localFilterSupplier) {
            this.pathTransformModCount = -1;
            this.scaledIconCache = new ScaledIconCache(this);
            this.selectedIconCache = new ScaledIconCache(this);
            this.lock = new Object();
            this.originalPath = originalPath;
            this.resolver = resolver;
            this.isDarkOverridden = darkOverridden;
            this.localFilterSupplier = localFilterSupplier;
            ((ScaleContext)this.getScaleContext()).addUpdateListener(new UserScaleContext.UpdateListener(){

                @Override
                public void contextUpdated() {
                    realIcon = null;
                }
            });
        }

        @Nullable
        private static ImageIcon unwrapIcon(Object icon) {
            if (icon == null) {
                return null;
            }
            if (icon instanceof Reference) {
                return (ImageIcon)((Reference)icon).get();
            }
            return (ImageIcon)icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
            ScaleContext scaleContext = ScaleContext.create(g2d);
            if (SVGLoader.isSelectionContext()) {
                ImageIcon result = null;
                Object object = this.lock;
                synchronized (object) {
                    ImageIcon icon = this.selectedIconCache.getOrScaleIcon(1.0f);
                    if (icon != null) {
                        result = icon;
                    }
                }
                if (result == null) {
                    result = EMPTY_ICON;
                }
                result.paintIcon(c, g, x, y);
            } else {
                this.getRealIcon(scaleContext).paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon(null).getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon(null).getIconHeight();
        }

        public float getScale() {
            return 1.0f;
        }

        @ApiStatus.Internal
        @NotNull
        public final ImageIcon getRealIcon() {
            return this.getRealIcon(null);
        }

        @TestOnly
        @Nullable
        public final ImageIcon doGetRealIcon() {
            return CachedImageIcon.unwrapIcon(this.realIcon);
        }

        @Nullable
        public final String getOriginalPath() {
            return this.originalPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private ImageIcon getRealIcon(@Nullable ScaleContext context) {
            Object object;
            Object realIcon = this.realIcon;
            ImageDataLoader resolver = this.resolver;
            if (resolver == null) {
                ImageIcon imageIcon = EMPTY_ICON;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(2);
                }
                return imageIcon;
            }
            if (pathTransformGlobalModCount.get() != this.pathTransformModCount) {
                if (IconLoader.isLoaderDisabled()) {
                    ImageIcon imageIcon = EMPTY_ICON;
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(3);
                    }
                    return imageIcon;
                }
                object = this.lock;
                synchronized (object) {
                    resolver = this.resolver;
                    if (resolver == null) {
                        ImageIcon imageIcon = EMPTY_ICON;
                        // MONITOREXIT @DISABLED, blocks:[18, 6, 15] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                        if (imageIcon == null) {
                            CachedImageIcon.$$$reportNull$$$0(4);
                        }
                        return imageIcon;
                    }
                    realIcon = this.realIcon;
                    if (pathTransformGlobalModCount.get() != this.pathTransformModCount) {
                        this.pathTransformModCount = pathTransformGlobalModCount.get();
                        realIcon = null;
                        this.realIcon = null;
                        this.scaledIconCache.clear();
                        this.selectedIconCache.clear();
                        if (this.originalPath != null && (resolver = resolver.patch(this.originalPath, pathTransform.get())) != null) {
                            this.resolver = resolver;
                        }
                    }
                }
            }
            object = this.lock;
            synchronized (object) {
                ImageIcon icon;
                if (!this.updateScaleContext(context) && (icon = CachedImageIcon.unwrapIcon(realIcon)) != null) {
                    ImageIcon imageIcon = icon;
                    // MONITOREXIT @DISABLED, blocks:[5, 11] lbl37 : MonitorExitStatement: MONITOREXIT : var4_4
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(5);
                    }
                    return imageIcon;
                }
                icon = this.scaledIconCache.getOrScaleIcon(1.0f);
                if (icon != null) {
                    this.realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference((Object)icon);
                    ImageIcon imageIcon = icon;
                    // MONITOREXIT @DISABLED, blocks:[5, 9] lbl45 : MonitorExitStatement: MONITOREXIT : var4_4
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(6);
                    }
                    return imageIcon;
                }
            }
            ImageIcon imageIcon = EMPTY_ICON;
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(7);
            }
            return imageIcon;
        }

        public final String toString() {
            ImageDataLoader resolver = this.resolver;
            if (resolver != null) {
                return resolver.toString();
            }
            return this.originalPath != null ? this.originalPath : "unknown path";
        }

        @NotNull
        public final Icon scale(float scale) {
            if (scale == 1.0f) {
                CachedImageIcon cachedImageIcon = this;
                if (cachedImageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(8);
                }
                return cachedImageIcon;
            }
            this.getRealIcon();
            ImageIcon icon = this.scaledIconCache.getOrScaleIcon(scale);
            Icon icon2 = icon == null ? this : icon;
            if (icon2 == null) {
                CachedImageIcon.$$$reportNull$$$0(9);
            }
            return icon2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Icon getDarkIcon(boolean isDark) {
            ImageDataLoader resolver = this.resolver;
            if (resolver == null) {
                ImageIcon imageIcon = EMPTY_ICON;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(10);
                }
                return imageIcon;
            }
            CachedImageIcon result = this.darkVariant;
            if (result == null) {
                Object object = this.lock;
                synchronized (object) {
                    result = this.darkVariant;
                    if (result == null) {
                        this.darkVariant = result = new CachedImageIcon(this.originalPath, resolver, isDark, this.localFilterSupplier);
                    }
                }
            }
            CachedImageIcon cachedImageIcon = result;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(11);
            }
            return cachedImageIcon;
        }

        @Override
        @NotNull
        public final Icon getMenuBarIcon(boolean isDark) {
            boolean useMRI = MultiResolutionImageProvider.isMultiResolutionImageAvailable() && SystemInfo.isMac;
            ScaleContext ctx = useMRI ? ScaleContext.create() : ScaleContext.createIdentity();
            ctx.setScale(ScaleType.USR_SCALE.of(1.0));
            Image img = this.loadImage(ctx, isDark);
            if (useMRI) {
                img = MultiResolutionImageProvider.convertFromJBImage(img);
            }
            if (img != null) {
                return new ImageIcon(img);
            }
            CachedImageIcon cachedImageIcon = this;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(12);
            }
            return cachedImageIcon;
        }

        @Override
        @NotNull
        public final CachedImageIcon copy() {
            CachedImageIcon result = new CachedImageIcon(this.originalPath, this.resolver, this.isDarkOverridden, this.localFilterSupplier);
            result.pathTransformModCount = this.pathTransformModCount;
            CachedImageIcon cachedImageIcon = result;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(13);
            }
            return cachedImageIcon;
        }

        @NotNull
        private Icon createWithFilter(@NotNull Supplier<? extends RGBImageFilter> filterSupplier) {
            ImageDataLoader resolver;
            if (filterSupplier == null) {
                CachedImageIcon.$$$reportNull$$$0(14);
            }
            if ((resolver = this.resolver) == null) {
                ImageIcon imageIcon = EMPTY_ICON;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(15);
                }
                return imageIcon;
            }
            return new CachedImageIcon(this.originalPath, resolver, this.isDarkOverridden, filterSupplier);
        }

        private boolean isDark() {
            return this.isDarkOverridden == null ? pathTransform.get().isDark() : this.isDarkOverridden.booleanValue();
        }

        @Nullable
        private List<ImageFilter> getFilters() {
            ImageFilter local;
            ImageFilter global = pathTransform.get().getFilter();
            ImageFilter imageFilter = local = this.localFilterSupplier == null ? null : (ImageFilter)this.localFilterSupplier.get();
            if (global != null && local != null) {
                return Arrays.asList(global, local);
            }
            if (global != null) {
                return Collections.singletonList(global);
            }
            return local == null ? null : Collections.singletonList(local);
        }

        @Nullable
        public final URL getURL() {
            ImageDataLoader resolver = this.resolver;
            return resolver == null ? null : resolver.getURL();
        }

        @Nullable
        private Image loadImage(@NotNull ScaleContext scaleContext, boolean isDark) {
            if (scaleContext == null) {
                CachedImageIcon.$$$reportNull$$$0(16);
            }
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            ImageDataLoader resolver = this.resolver;
            if (resolver == null) {
                return null;
            }
            Image image = resolver.loadImage(this.getFilters(), scaleContext, isDark);
            if (start != -1L) {
                IconLoadMeasurer.findIconLoad.end(start);
            }
            return image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean detachClassLoader(@NotNull ClassLoader loader) {
            ImageDataLoader resolver;
            if (loader == null) {
                CachedImageIcon.$$$reportNull$$$0(17);
            }
            if ((resolver = this.resolver) == null) {
                return true;
            }
            Object object = this.lock;
            synchronized (object) {
                resolver = this.resolver;
                if (resolver == null) {
                    return true;
                }
                if (!resolver.isMyClassLoader(loader)) {
                    return false;
                }
                this.resolver = null;
                this.scaledIconCache.clear();
                this.selectedIconCache.clear();
                CachedImageIcon darkVariant = this.darkVariant;
                if (darkVariant != null) {
                    this.darkVariant = null;
                    darkVariant.detachClassLoader(loader);
                }
                return true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filterSupplier";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRealIcon";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDarkIcon";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMenuBarIcon";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createWithFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithFilter";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "loadImage";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "detachClassLoader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class FinalImageDataLoader
    implements ImageDataLoader {
        private final WeakReference<ClassLoader> classLoaderRef;
        private final String path;

        FinalImageDataLoader(@NotNull String path, @NotNull ClassLoader classLoader) {
            if (path == null) {
                FinalImageDataLoader.$$$reportNull$$$0(0);
            }
            if (classLoader == null) {
                FinalImageDataLoader.$$$reportNull$$$0(1);
            }
            this.path = path;
            this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        }

        @Override
        @Nullable
        public Image loadImage(List<ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
            ClassLoader classLoader;
            if (scaleContext == null) {
                FinalImageDataLoader.$$$reportNull$$$0(2);
            }
            int flags = 1;
            if (isDark) {
                flags |= 4;
            }
            if ((classLoader = (ClassLoader)this.classLoaderRef.get()) == null) {
                return null;
            }
            return ImageLoader.load(this.path, filters, null, classLoader, flags, scaleContext, !this.path.endsWith(".svg"));
        }

        @Override
        @Nullable
        public URL getURL() {
            ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
            return classLoader == null ? null : classLoader.getResource(this.path);
        }

        @Override
        @Nullable
        public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform) {
            if (originalPath == null) {
                FinalImageDataLoader.$$$reportNull$$$0(3);
            }
            if (transform == null) {
                FinalImageDataLoader.$$$reportNull$$$0(4);
            }
            return null;
        }

        @Override
        public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
            if (classLoader == null) {
                FinalImageDataLoader.$$$reportNull$$$0(5);
            }
            return this.classLoaderRef.get() == classLoader;
        }

        public String toString() {
            return "FinalImageDataLoader(, classLoader=" + this.classLoaderRef.get() + ", path='" + this.path + "')";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLoader";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/IconLoader$FinalImageDataLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadImage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patch";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMyClassLoader";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RasterizedImageDataLoader
    implements ImageDataLoader {
        private final WeakReference<ClassLoader> classLoaderRef;
        private final long cacheKey;
        private final int imageFlags;
        private final String path;

        /*
         * WARNING - void declaration
         */
        RasterizedImageDataLoader(@NotNull String path, @NotNull ClassLoader classLoader, long cacheKey, int n) {
            void imageFlags;
            if (path == null) {
                RasterizedImageDataLoader.$$$reportNull$$$0(0);
            }
            if (classLoader == null) {
                RasterizedImageDataLoader.$$$reportNull$$$0(1);
            }
            this.path = path;
            this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
            this.cacheKey = cacheKey;
            this.imageFlags = imageFlags;
        }

        @Override
        @Nullable
        public Image loadImage(@Nullable List<ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
            ClassLoader classLoader;
            if (scaleContext == null) {
                RasterizedImageDataLoader.$$$reportNull$$$0(2);
            }
            int flags = 1;
            if (isDark) {
                flags |= 4;
            }
            if ((classLoader = (ClassLoader)this.classLoaderRef.get()) == null) {
                return null;
            }
            return ImageLoader.loadRasterized(this.path, filters, classLoader, flags, scaleContext, this.cacheKey == 0L, this.cacheKey, this.imageFlags);
        }

        @Override
        @Nullable
        public URL getURL() {
            ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
            return classLoader == null ? null : classLoader.getResource(this.path);
        }

        @Override
        @Nullable
        public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform) {
            if (originalPath == null) {
                RasterizedImageDataLoader.$$$reportNull$$$0(3);
            }
            if (transform == null) {
                RasterizedImageDataLoader.$$$reportNull$$$0(4);
            }
            ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
            Object pathWithLeadingSlash = originalPath.charAt(0) == '/' ? originalPath : "/" + originalPath;
            return classLoader == null ? null : IconLoader.createNewResolverIfNeeded(classLoader, (String)pathWithLeadingSlash, transform);
        }

        @Override
        public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
            if (classLoader == null) {
                RasterizedImageDataLoader.$$$reportNull$$$0(5);
            }
            return this.classLoaderRef.get() == classLoader;
        }

        public String toString() {
            return "RasterizedImageDataLoader(, classLoader=" + this.classLoaderRef.get() + ", path='" + this.path + "')";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLoader";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/IconLoader$RasterizedImageDataLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadImage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patch";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMyClassLoader";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

