/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class SmartExpander {
    public static void installOn(final JTree tree) {
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Enumeration<? extends TreeNode> children = ((TreeNode)path.getLastPathComponent()).children();
                while (children.hasMoreElements()) {
                    TreePath childPath = path.pathByAddingChild(children.nextElement());
                    if (!tree.isExpanded(childPath)) continue;
                    tree.collapsePath(childPath);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                TreeNode lastPathComponent = (TreeNode)path.getLastPathComponent();
                if (lastPathComponent.getChildCount() == 1) {
                    TreePath firstChildPath = path.pathByAddingChild(lastPathComponent.getChildAt(0));
                    tree.expandPath(firstChildPath);
                }
            }
        });
    }
}

