/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumValidationRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    private final Collection<String> myEnumValues;

    public EnumValidationRule(@Nullable Collection<String> strings) {
        this.myEnumValues = strings == null ? Collections.emptySet() : ContainerUtil.unmodifiableOrEmptyCollection(strings);
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (data == null) {
            EnumValidationRule.$$$reportNull$$$0(0);
        }
        if (context == null) {
            EnumValidationRule.$$$reportNull$$$0(1);
        }
        if (this.myEnumValues.isEmpty()) {
            ValidationResultType validationResultType = ValidationResultType.INCORRECT_RULE;
            if (validationResultType == null) {
                EnumValidationRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }
        String escaped = StatisticsEventEscaper.escapeEventIdOrFieldValue((String)data);
        if (this.myEnumValues.contains(escaped)) {
            ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
            if (validationResultType == null) {
                EnumValidationRule.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }
        String legacyData = StatisticsEventEscaper.cleanupForLegacyRulesIfNeeded((String)escaped);
        ValidationResultType validationResultType = legacyData != null && this.myEnumValues.contains(legacyData) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        if (validationResultType == null) {
            EnumValidationRule.$$$reportNull$$$0(4);
        }
        return validationResultType;
    }

    @Override
    @NotNull
    public String asRegexp() {
        String string = StringUtil.join((Collection)ContainerUtil.map(this.myEnumValues, s -> RegexpValidationRule.escapeText(s)), (String)"|");
        if (string == null) {
            EnumValidationRule.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String toString() {
        return "EnumValidationRule: myEnumValues=" + this.asRegexp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/EnumValidationRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/EnumValidationRule";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asRegexp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

