/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.actions.MultipleRunLocationsProvider;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationContext {
    private static final Logger LOG = Logger.getInstance(ConfigurationContext.class);
    private final Location<PsiElement> myLocation;
    private RunnerAndConfigurationSettings myConfiguration;
    private boolean myInitialized;
    private boolean myMultipleSelection;
    private Ref<RunnerAndConfigurationSettings> myExistingConfiguration;
    private final Module myModule;
    private final RunConfiguration myRuntimeConfiguration;
    private final Component myContextComponent;
    public static Key<ConfigurationContext> SHARED_CONTEXT = Key.create((String)"SHARED_CONTEXT");
    private List<RuntimeConfigurationProducer> myPreferredProducers;
    private List<ConfigurationFromContext> myConfigurationsFromContext;

    @NotNull
    public static ConfigurationContext getFromContext(DataContext dataContext) {
        DataManager dataManager = DataManager.getInstance();
        ConfigurationContext sharedContext = dataManager.loadFromDataContext(dataContext, SHARED_CONTEXT);
        Pair<Location<PsiElement>, Boolean> calculatedLocation = null;
        Module module = null;
        if (sharedContext == null || sharedContext.getLocation() == null || (calculatedLocation = ConfigurationContext.calcLocation(dataContext, module = (Module)LangDataKeys.MODULE.getData(dataContext))).getFirst() == null || !Comparing.equal(sharedContext.getLocation().getPsiElement(), ((Location)calculatedLocation.getFirst()).getPsiElement())) {
            if (calculatedLocation == null) {
                module = (Module)LangDataKeys.MODULE.getData(dataContext);
                calculatedLocation = ConfigurationContext.calcLocation(dataContext, module);
            }
            sharedContext = new ConfigurationContext(dataContext, (Location)calculatedLocation.getFirst(), module, (Boolean)calculatedLocation.getSecond());
            dataManager.saveInDataContext(dataContext, SHARED_CONTEXT, sharedContext);
        }
        ConfigurationContext configurationContext = sharedContext;
        if (configurationContext == null) {
            ConfigurationContext.$$$reportNull$$$0(0);
        }
        return configurationContext;
    }

    @NotNull
    public static ConfigurationContext createEmptyContextForLocation(@NotNull Location location) {
        if (location == null) {
            ConfigurationContext.$$$reportNull$$$0(1);
        }
        return new ConfigurationContext(location);
    }

    private ConfigurationContext(DataContext dataContext, Location<PsiElement> location, Module module, boolean multipleSelection) {
        ExecutionEnvironment environment;
        RunConfiguration configuration = (RunConfiguration)RunConfiguration.DATA_KEY.getData(dataContext);
        if (configuration == null && (environment = (ExecutionEnvironment)((Object)dataContext.getData(LangDataKeys.EXECUTION_ENVIRONMENT))) != null) {
            this.myConfiguration = environment.getRunnerAndConfigurationSettings();
            if (this.myConfiguration != null) {
                this.myExistingConfiguration = Ref.create((Object)this.myConfiguration);
                configuration = this.myConfiguration.getConfiguration();
            }
        }
        this.myRuntimeConfiguration = configuration;
        this.myContextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        this.myModule = module;
        this.myLocation = location;
        this.myMultipleSelection = multipleSelection;
    }

    @NotNull
    private static Pair<Location<PsiElement>, Boolean> calcLocation(@NotNull DataContext dataContext, Module module) {
        VirtualFile[] files;
        PsiLocation<PsiElement> location;
        if (dataContext == null) {
            ConfigurationContext.$$$reportNull$$$0(2);
        }
        if ((location = (PsiLocation<PsiElement>)Location.DATA_KEY.getData(dataContext)) != null) {
            Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
            boolean myMultipleSelection = locations != null && locations.length > 1;
            Pair pair = Pair.create((Object)location, (Object)myMultipleSelection);
            if (pair == null) {
                ConfigurationContext.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            Pair pair = Pair.create(null, (Object)false);
            if (pair == null) {
                ConfigurationContext.$$$reportNull$$$0(4);
            }
            return pair;
        }
        PsiElement element = ConfigurationContext.getSelectedPsiElement(dataContext, project);
        if (element == null) {
            Pair pair = Pair.create(null, (Object)false);
            if (pair == null) {
                ConfigurationContext.$$$reportNull$$$0(5);
            }
            return pair;
        }
        location = new PsiLocation<PsiElement>(project, module, element);
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        boolean myMultipleSelection = elements != null ? elements.length > 1 : (files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files.length > 1;
        Pair pair = Pair.create(location, (Object)myMultipleSelection);
        if (pair == null) {
            ConfigurationContext.$$$reportNull$$$0(6);
        }
        return pair;
    }

    public ConfigurationContext(PsiElement element) {
        this.myModule = ModuleUtilCore.findModuleForPsiElement(element);
        this.myLocation = new PsiLocation<PsiElement>(element.getProject(), this.myModule, element);
        this.myRuntimeConfiguration = null;
        this.myContextComponent = null;
    }

    private ConfigurationContext(@NotNull Location location) {
        if (location == null) {
            ConfigurationContext.$$$reportNull$$$0(7);
        }
        this.myLocation = location;
        this.myModule = location.getModule();
        this.myRuntimeConfiguration = null;
        this.myContextComponent = null;
    }

    public boolean containsMultipleSelection() {
        return this.myMultipleSelection;
    }

    @Nullable
    public synchronized RunnerAndConfigurationSettings getConfiguration() {
        if (this.myConfiguration == null && !this.myInitialized) {
            this.createConfiguration();
        }
        return this.myConfiguration;
    }

    private void createConfiguration() {
        LOG.assertTrue(this.myConfiguration == null);
        Location location = this.getLocation();
        this.myConfiguration = location != null && !DumbService.isDumb(location.getProject()) ? PreferredProducerFind.createConfiguration(location, this) : null;
        this.myInitialized = true;
    }

    public synchronized void setConfiguration(@NotNull RunnerAndConfigurationSettings configuration) {
        if (configuration == null) {
            ConfigurationContext.$$$reportNull$$$0(8);
        }
        this.myConfiguration = configuration;
        this.myInitialized = true;
    }

    @Deprecated
    @Nullable
    public RunnerAndConfigurationSettings updateConfiguration(RuntimeConfigurationProducer producer) {
        this.myConfiguration = producer.getConfiguration();
        return this.myConfiguration;
    }

    @Nullable
    public Location getLocation() {
        return this.myLocation;
    }

    @Nullable
    public PsiElement getPsiLocation() {
        return this.myLocation != null ? this.myLocation.getPsiElement() : null;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExisting() {
        RunnerAndConfigurationSettings configuration;
        RunnerAndConfigurationSettings configuration2;
        if (this.myExistingConfiguration != null && ((configuration2 = (RunnerAndConfigurationSettings)this.myExistingConfiguration.get()) == null || !Registry.is((String)"suggest.all.run.configurations.from.context") || configuration2.equals(this.myConfiguration))) {
            return configuration2;
        }
        this.myExistingConfiguration = new Ref();
        if (this.myLocation == null) {
            return null;
        }
        PsiElement psiElement = this.myLocation.getPsiElement();
        if (!psiElement.isValid()) {
            return null;
        }
        if (MultipleRunLocationsProvider.findAlternativeLocations(this.myLocation) != null) {
            this.myExistingConfiguration.set(null);
            return null;
        }
        List<RuntimeConfigurationProducer> producers = this.findPreferredProducers();
        ArrayList<ExistingConfiguration> existingConfigurations = new ArrayList<ExistingConfiguration>();
        if (producers != null) {
            for (RuntimeConfigurationProducer runtimeConfigurationProducer : producers) {
                configuration = runtimeConfigurationProducer.findExistingConfiguration(this.myLocation, this);
                if (configuration == null) continue;
                existingConfigurations.add(new ExistingConfiguration(configuration, null));
            }
        }
        for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(this.getProject())) {
            configuration = runConfigurationProducer.findExistingConfiguration(this);
            if (configuration == null) continue;
            existingConfigurations.add(new ExistingConfiguration(configuration, runConfigurationProducer));
        }
        this.myExistingConfiguration.set((Object)this.findPreferredConfiguration(existingConfigurations, psiElement));
        return (RunnerAndConfigurationSettings)this.myExistingConfiguration.get();
    }

    @Nullable
    private RunnerAndConfigurationSettings findPreferredConfiguration(@NotNull List<ExistingConfiguration> existingConfigurations, @NotNull PsiElement psiElement) {
        if (existingConfigurations == null) {
            ConfigurationContext.$$$reportNull$$$0(9);
        }
        if (psiElement == null) {
            ConfigurationContext.$$$reportNull$$$0(10);
        }
        for (ExistingConfiguration configuration2 : existingConfigurations) {
            RunnerAndConfigurationSettings settings = configuration2.getSettings();
            if (settings.equals(this.myConfiguration)) {
                return settings;
            }
            if (this.myRuntimeConfiguration == null || settings.getConfiguration() != this.myRuntimeConfiguration) continue;
            return settings;
        }
        if (Registry.is((String)"suggest.all.run.configurations.from.context")) {
            return null;
        }
        List contexts = ContainerUtil.mapNotNull(existingConfigurations, configuration -> {
            if (configuration.getProducer() == null) {
                return null;
            }
            return new ConfigurationFromContextImpl(configuration.getProducer(), configuration.getSettings(), psiElement);
        });
        if (!contexts.isEmpty()) {
            ConfigurationFromContext min = Collections.min(contexts, ConfigurationFromContext.COMPARATOR);
            return min.getConfigurationSettings();
        }
        ExistingConfiguration first = (ExistingConfiguration)ContainerUtil.getFirstItem(existingConfigurations);
        return first != null ? first.getSettings() : null;
    }

    @Nullable
    private static PsiElement getSelectedPsiElement(DataContext dataContext, Project project) {
        VirtualFile[] files;
        int offset;
        PsiFile psiFile;
        PsiElement element = null;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null && (element = psiFile.findElementAt(offset = editor.getCaretModel().getOffset())) == null && offset > 0 && offset == psiFile.getTextLength()) {
            element = psiFile.findElementAt(offset - 1);
        }
        if (element == null) {
            PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            PsiElement psiElement = element = elements != null && elements.length > 0 ? elements[0] : null;
        }
        if (element == null && (files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files.length > 0) {
            element = PsiManager.getInstance(project).findFile(files[0]);
        }
        return element;
    }

    @NotNull
    public RunManager getRunManager() {
        RunManager runManager = RunManager.getInstance(this.getProject());
        if (runManager == null) {
            ConfigurationContext.$$$reportNull$$$0(11);
        }
        return runManager;
    }

    public Project getProject() {
        return this.myConfiguration == null ? this.myLocation.getProject() : this.myConfiguration.getConfiguration().getProject();
    }

    public Module getModule() {
        return this.myModule;
    }

    public DataContext getDataContext() {
        return DataManager.getInstance().getDataContext(this.myContextComponent);
    }

    @Nullable
    public RunConfiguration getOriginalConfiguration(@Nullable ConfigurationType type) {
        if (type == null || this.myRuntimeConfiguration != null && this.myRuntimeConfiguration.getType() == type) {
            return this.myRuntimeConfiguration;
        }
        return null;
    }

    public boolean isCompatibleWithOriginalRunConfiguration(@NotNull ConfigurationType type) {
        if (type == null) {
            ConfigurationContext.$$$reportNull$$$0(12);
        }
        return this.myRuntimeConfiguration == null || this.myRuntimeConfiguration.getType() == type;
    }

    @Deprecated
    @Nullable
    public List<RuntimeConfigurationProducer> findPreferredProducers() {
        if (this.myPreferredProducers == null) {
            this.myPreferredProducers = PreferredProducerFind.findPreferredProducers(this.myLocation, this, true);
        }
        return this.myPreferredProducers;
    }

    @Nullable
    public List<ConfigurationFromContext> getConfigurationsFromContext() {
        if (this.myConfigurationsFromContext == null) {
            this.myConfigurationsFromContext = PreferredProducerFind.getConfigurationsFromContext(this.myLocation, this, true);
        }
        return this.myConfigurationsFromContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ConfigurationContext";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingConfigurations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromContext";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ConfigurationContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLocation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyContextForLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcLocation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleWithOriginalRunConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ExistingConfiguration {
        private final RunnerAndConfigurationSettings myConfigurationSettings;
        private final RunConfigurationProducer<?> myProducer;

        private ExistingConfiguration(@NotNull RunnerAndConfigurationSettings configurationSettings, @Nullable RunConfigurationProducer<?> producer) {
            if (configurationSettings == null) {
                ExistingConfiguration.$$$reportNull$$$0(0);
            }
            this.myConfigurationSettings = configurationSettings;
            this.myProducer = producer;
        }

        @NotNull
        private RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.myConfigurationSettings;
            if (runnerAndConfigurationSettings == null) {
                ExistingConfiguration.$$$reportNull$$$0(1);
            }
            return runnerAndConfigurationSettings;
        }

        @Nullable
        private RunConfigurationProducer<?> getProducer() {
            return this.myProducer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/actions/ConfigurationContext$ExistingConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/actions/ConfigurationContext$ExistingConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

