/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.plugins.PluginFeatureService;
import com.intellij.ide.plugins.PluginManagerConfigurableService;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnknownRunConfiguration
implements RunConfiguration,
WithoutOwnBeforeRunSteps {
    private final ConfigurationFactory myFactory;
    private Element myStoredElement;
    private String myName;
    private final Project myProject;
    private static final AtomicInteger myUniqueName = new AtomicInteger(1);
    private boolean myDoNotStore;

    public UnknownRunConfiguration(@NotNull ConfigurationFactory factory, @NotNull Project project) {
        if (factory == null) {
            UnknownRunConfiguration.$$$reportNull$$$0(0);
        }
        if (project == null) {
            UnknownRunConfiguration.$$$reportNull$$$0(1);
        }
        this.myFactory = factory;
        this.myProject = project;
    }

    public void setDoNotStore(boolean b) {
        this.myDoNotStore = b;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isDoNotStore() {
        return this.myDoNotStore;
    }

    @Override
    public ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            UnknownRunConfiguration.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new UnknownSettingsEditor();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public RunConfiguration clone() {
        try {
            return (UnknownRunConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            UnknownRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            UnknownRunConfiguration.$$$reportNull$$$0(4);
        }
        @NlsSafe String factoryName = this.getConfigurationTypeId();
        throw new ExecutionException(ExecutionBundle.message("dialog.message.unknown.run.configuration.type", factoryName, StringUtil.isEmpty((String)factoryName) ? 0 : 1));
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            this.myName = String.format("Unknown%s", myUniqueName.getAndAdd(1));
        }
        String string = this.myName;
        if (string == null) {
            UnknownRunConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private String getConfigurationTypeId() {
        if (this.myStoredElement != null) {
            return this.myStoredElement.getAttributeValue("type");
        }
        return null;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        PluginFeatureService.FeaturePluginData plugin;
        String typeId = this.getConfigurationTypeId();
        if (typeId != null && (plugin = PluginFeatureService.getInstance().getPluginForFeature("com.intellij.configurationType", typeId)) != null) {
            RuntimeConfigurationError err = new RuntimeConfigurationError(LangBundle.message("dialog.message.broken.configuration.missing.plugin", plugin.getDisplayName()));
            err.setQuickFix(() -> PluginManagerConfigurableService.getInstance().showPluginConfigurableAndEnable(null, PluginId.getId((String)plugin.getPluginId())));
            throw err;
        }
        throw new RuntimeConfigurationException(LangBundle.message("dialog.message.broken.configuration", new Object[0]));
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            UnknownRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myStoredElement = JDOMUtil.internElement((Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myStoredElement != null) {
            for (Attribute a : this.myStoredElement.getAttributes()) {
                element.setAttribute(a.getName(), a.getValue());
            }
            for (Element child : this.myStoredElement.getChildren()) {
                element.addContent(child.clone());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/UnknownRunConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/UnknownRunConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UnknownSettingsEditor
    extends SettingsEditor<UnknownRunConfiguration> {
        private final JPanel myPanel = new JPanel();

        private UnknownSettingsEditor() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 50, 0));
            this.myPanel.add(new JLabel(ExecutionBundle.message("this.configuration.cannot.be.edited", new Object[0]), 0));
        }

        @Override
        protected void resetEditorFrom(@NotNull UnknownRunConfiguration s) {
            if (s == null) {
                UnknownSettingsEditor.$$$reportNull$$$0(0);
            }
        }

        @Override
        protected void applyEditorTo(@NotNull UnknownRunConfiguration s) {
            if (s == null) {
                UnknownSettingsEditor.$$$reportNull$$$0(1);
            }
        }

        @Override
        @NotNull
        protected JComponent createEditor() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                UnknownSettingsEditor.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/configurations/UnknownRunConfiguration$UnknownSettingsEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/configurations/UnknownRunConfiguration$UnknownSettingsEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resetEditorFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyEditorTo";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

