/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.java;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.ContributedTypeBase;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.java.JavaLanguageRuntimeType;
import com.intellij.execution.target.java.JavaLanguageRuntimeUIFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0002H\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0014\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016R \u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u00058\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006,"}, d2={"Lcom/intellij/execution/target/java/JavaLanguageRuntimeType;", "Lcom/intellij/execution/target/LanguageRuntimeType;", "Lcom/intellij/execution/target/java/JavaLanguageRuntimeConfiguration;", "()V", "configurableDescription", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getConfigurableDescription", "()Ljava/lang/String;", "displayName", "getDisplayName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "launchDescription", "getLaunchDescription", "createConfigurable", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "config", "target", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "targetEnvironmentType", "Lcom/intellij/execution/target/TargetEnvironmentType;", "targetSupplier", "Ljava/util/function/Supplier;", "createDefaultConfig", "createIntrospector", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspector;", "createSerializer", "Lcom/intellij/openapi/components/PersistentStateComponent;", "duplicateConfig", "findLanguageRuntime", "isApplicableTo", "", "runConfig", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "volumeDescriptors", "", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "Companion", "intellij.platform.lang"})
public final class JavaLanguageRuntimeType
extends LanguageRuntimeType<JavaLanguageRuntimeConfiguration> {
    @NotNull
    private final Icon icon;
    @NlsSafe
    @NotNull
    private final String displayName;
    @Nls
    @NotNull
    private final String configurableDescription;
    @Nls
    @NotNull
    private final String launchDescription;
    @NotNull
    private static final String TYPE_ID;
    @NotNull
    private static final LanguageRuntimeType.VolumeDescriptor CLASS_PATH_VOLUME;
    @NotNull
    private static final LanguageRuntimeType.VolumeDescriptor AGENTS_VOLUME;
    public static final Companion Companion;

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public String getConfigurableDescription() {
        return this.configurableDescription;
    }

    @Override
    @NotNull
    public String getLaunchDescription() {
        return this.launchDescription;
    }

    @Override
    public boolean isApplicableTo(@NotNull RunnerAndConfigurationSettings runConfig) {
        Intrinsics.checkNotNullParameter((Object)runConfig, (String)"runConfig");
        return true;
    }

    @Override
    @NotNull
    public JavaLanguageRuntimeConfiguration createDefaultConfig() {
        return new JavaLanguageRuntimeConfiguration();
    }

    @Override
    @NotNull
    public PersistentStateComponent<?> createSerializer(@NotNull JavaLanguageRuntimeConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return config;
    }

    @Override
    @NotNull
    public Configurable createConfigurable(@NotNull Project project, @NotNull JavaLanguageRuntimeConfiguration config, @NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        BoundConfigurable boundConfigurable = ((JavaLanguageRuntimeUIFactory)ApplicationManager.getApplication().getService(JavaLanguageRuntimeUIFactory.class)).create(config, target, project);
        Intrinsics.checkNotNullExpressionValue((Object)boundConfigurable, (String)"ApplicationManager.getAp\u2026(config, target, project)");
        return boundConfigurable;
    }

    @Override
    @NotNull
    public Configurable createConfigurable(@NotNull Project project, @NotNull JavaLanguageRuntimeConfiguration config, @NotNull TargetEnvironmentType<?> targetEnvironmentType, @NotNull Supplier<TargetEnvironmentConfiguration> targetSupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(targetEnvironmentType, (String)"targetEnvironmentType");
        Intrinsics.checkNotNullParameter(targetSupplier, (String)"targetSupplier");
        BoundConfigurable boundConfigurable = ((JavaLanguageRuntimeUIFactory)ApplicationManager.getApplication().getService(JavaLanguageRuntimeUIFactory.class)).create(config, targetEnvironmentType, targetSupplier, project);
        Intrinsics.checkNotNullExpressionValue((Object)boundConfigurable, (String)"ApplicationManager.getAp\u2026 targetSupplier, project)");
        return boundConfigurable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public JavaLanguageRuntimeConfiguration findLanguageRuntime(@NotNull TargetEnvironmentConfiguration target) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ContributedConfigurationsList<LanguageRuntimeConfiguration, LanguageRuntimeType<?>> this_$iv = target.getRuntimes();
        boolean $i$f$findByType = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.resolvedConfigs();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof JavaLanguageRuntimeConfiguration)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (JavaLanguageRuntimeConfiguration)((ContributedConfigurationBase)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv)));
    }

    @Override
    @Nullable
    public LanguageRuntimeType.Introspector<JavaLanguageRuntimeConfiguration> createIntrospector(@NotNull JavaLanguageRuntimeConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        CharSequence charSequence = config.getHomePath();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = config.getJavaVersionString();
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
        }
        return new LanguageRuntimeType.Introspector<JavaLanguageRuntimeConfiguration>(config){
            final /* synthetic */ JavaLanguageRuntimeConfiguration $config;

            @NotNull
            public CompletableFuture<JavaLanguageRuntimeConfiguration> introspect(@NotNull LanguageRuntimeType.Introspectable subject) {
                Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
                CompletableFuture<String> javaHomePromise2 = StringsKt.isBlank((CharSequence)this.$config.getHomePath()) ? subject.promiseEnvironmentVariable("JAVA_HOME").thenApply(new Function<String, Unit>(this){
                    final /* synthetic */ createIntrospector.1 this$0;

                    public final void apply(@Nullable String it) {
                        createIntrospector.1.access$acceptJavaHome(this.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }) : LanguageRuntimeType.Introspector.Companion.getDONE();
                CompletableFuture<String> versionPromise2 = StringsKt.isBlank((CharSequence)this.$config.getJavaVersionString()) ? subject.promiseExecuteScript("java -version").thenApply(new Function<String, Unit>(this){
                    final /* synthetic */ createIntrospector.1 this$0;

                    public final void apply(@Nullable String it) {
                        createIntrospector.1.access$acceptJavaVersionOutput(this.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }) : LanguageRuntimeType.Introspector.Companion.getDONE();
                CompletionStage completionStage = CompletableFuture.allOf(javaHomePromise2, versionPromise2).thenApply(new Function<Void, JavaLanguageRuntimeConfiguration>(this){
                    final /* synthetic */ createIntrospector.1 this$0;

                    public final JavaLanguageRuntimeConfiguration apply(Void it) {
                        return this.this$0.$config;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"CompletableFuture.allOf(\u2026       config\n          }");
                return completionStage;
            }

            private final void acceptJavaHome(String javaHome) {
                block1: {
                    if (!StringsKt.isBlank((CharSequence)this.$config.getHomePath())) break block1;
                    String string = StringKt.nullize(javaHome, true);
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        this.$config.setHomePath(it);
                    }
                }
            }

            private final void acceptJavaVersionOutput(String output) {
                block2: {
                    String[] stringArray = output;
                    if (stringArray == null) break block2;
                    String[] stringArray2 = stringArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    String[] it = stringArray2;
                    boolean bl3 = false;
                    stringArray = StringUtil.splitByLines((String)output, (boolean)true);
                    if (stringArray != null && (stringArray = (String)ArraysKt.firstOrNull((Object[])stringArray)) != null) {
                        stringArray2 = stringArray;
                        bl = false;
                        bl2 = false;
                        it = stringArray2;
                        boolean bl4 = false;
                        stringArray = JavaVersion.parse((String)it);
                        if (stringArray != null) {
                            stringArray2 = stringArray;
                            bl = false;
                            bl2 = false;
                            it = stringArray2;
                            boolean bl5 = false;
                            String string = it.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                            this.$config.setJavaVersionString(string);
                        }
                    }
                }
            }
            {
                this.$config = $captured_local_variable$0;
            }

            public static final /* synthetic */ void access$acceptJavaHome(createIntrospector.1 $this, String javaHome) {
                $this.acceptJavaHome(javaHome);
            }

            public static final /* synthetic */ void access$acceptJavaVersionOutput(createIntrospector.1 $this, String output) {
                $this.acceptJavaVersionOutput(output);
            }
        };
    }

    @Override
    @NotNull
    public List<LanguageRuntimeType.VolumeDescriptor> volumeDescriptors() {
        return CollectionsKt.listOf((Object[])new LanguageRuntimeType.VolumeDescriptor[]{CLASS_PATH_VOLUME, AGENTS_VOLUME});
    }

    @Override
    @NotNull
    public JavaLanguageRuntimeConfiguration duplicateConfig(@NotNull JavaLanguageRuntimeConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (JavaLanguageRuntimeConfiguration)ContributedTypeBase.Companion.duplicatePersistentComponent((ContributedTypeBase)this, (ContributedConfigurationBase)config);
    }

    public JavaLanguageRuntimeType() {
        super(TYPE_ID);
        Icon icon = AllIcons.FileTypes.Java;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.FileTypes.Java");
        this.icon = icon;
        this.displayName = "Java";
        String string = ExecutionBundle.message("JavaLanguageRuntimeType.configurable.description.configure.java", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecutionBundle.message(\u2026cription.configure.java\")");
        this.configurableDescription = string;
        String string2 = ExecutionBundle.message("JavaLanguageRuntimeType.launch.description.run.java.application", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ExecutionBundle.message(\u2026on.run.java.application\")");
        this.launchDescription = string2;
    }

    static {
        Companion = new Companion(null);
        TYPE_ID = "JavaLanguageRuntime";
        String string = Intrinsics.stringPlus((String)Reflection.getOrCreateKotlinClass(JavaLanguageRuntimeType.class).getQualifiedName(), (Object)":classPath");
        String string2 = ExecutionBundle.message("java.language.runtime.classpath.volume.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ExecutionBundle.message(\u2026.classpath.volume.label\")");
        String string3 = ExecutionBundle.message("java.language.runtime.classpath.volume.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ExecutionBundle.message(\u2026path.volume.description\")");
        String string4 = ExecutionBundle.message("java.language.runtime.classpath.volume.browsing.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ExecutionBundle.message(\u2026h.volume.browsing.title\")");
        CLASS_PATH_VOLUME = new LanguageRuntimeType.VolumeDescriptor(string, string2, string3, string4, "");
        String string5 = Intrinsics.stringPlus((String)Reflection.getOrCreateKotlinClass(JavaLanguageRuntimeType.class).getQualifiedName(), (Object)":agents");
        String string6 = ExecutionBundle.message("java.language.runtime.agents.volume.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"ExecutionBundle.message(\u2026ime.agents.volume.label\")");
        String string7 = ExecutionBundle.message("java.language.runtime.agents.volume.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"ExecutionBundle.message(\u2026ents.volume.description\")");
        String string8 = ExecutionBundle.message("java.language.runtime.agents.volume.browsing.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"ExecutionBundle.message(\u2026s.volume.browsing.title\")");
        AGENTS_VOLUME = new LanguageRuntimeType.VolumeDescriptor(string5, string6, string7, string8, "");
    }

    @NotNull
    public static final String getTYPE_ID() {
        Companion companion = Companion;
        return TYPE_ID;
    }

    @NotNull
    public static final LanguageRuntimeType.VolumeDescriptor getCLASS_PATH_VOLUME() {
        Companion companion = Companion;
        return CLASS_PATH_VOLUME;
    }

    @NotNull
    public static final LanguageRuntimeType.VolumeDescriptor getAGENTS_VOLUME() {
        Companion companion = Companion;
        return AGENTS_VOLUME;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/target/java/JavaLanguageRuntimeType$Companion;", "", "()V", "AGENTS_VOLUME", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "getAGENTS_VOLUME$annotations", "getAGENTS_VOLUME", "()Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "CLASS_PATH_VOLUME", "getCLASS_PATH_VOLUME$annotations", "getCLASS_PATH_VOLUME", "TYPE_ID", "", "getTYPE_ID$annotations", "getTYPE_ID", "()Ljava/lang/String;", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getTYPE_ID$annotations() {
        }

        @NotNull
        public final String getTYPE_ID() {
            return TYPE_ID;
        }

        @JvmStatic
        public static /* synthetic */ void getCLASS_PATH_VOLUME$annotations() {
        }

        @NotNull
        public final LanguageRuntimeType.VolumeDescriptor getCLASS_PATH_VOLUME() {
            return CLASS_PATH_VOLUME;
        }

        @JvmStatic
        public static /* synthetic */ void getAGENTS_VOLUME$annotations() {
        }

        @NotNull
        public final LanguageRuntimeType.VolumeDescriptor getAGENTS_VOLUME() {
            return AGENTS_VOLUME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

