/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface ASTBlock
extends Block {
    @Nullable
    public ASTNode getNode();

    @Contract(value="null -> null")
    @Nullable
    public static ASTNode getNode(@Nullable Block block) {
        return block instanceof ASTBlock ? ((ASTBlock)block).getNode() : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static IElementType getElementType(@Nullable Block block) {
        ASTNode node = ASTBlock.getNode(block);
        return node == null ? null : node.getElementType();
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement getPsiElement(@Nullable Block block) {
        ASTNode obj = ASTBlock.getNode(block);
        return obj == null ? null : obj.getPsi();
    }
}

