/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public final class Prefs {
    public static void put(String key, String value) {
        Preferences.userRoot().remove(key);
        Prefs.getPreferences(key).put(Prefs.getNodeKey(key), value);
    }

    public static String get(String key, String def) {
        Prefs.migrate(key, def, Preferences::get, Preferences::put);
        return Prefs.getPreferences(key).get(Prefs.getNodeKey(key), def);
    }

    public static void putInt(String key, int value) {
        Preferences.userRoot().remove(key);
        Prefs.getPreferences(key).putInt(Prefs.getNodeKey(key), value);
    }

    public static int getInt(String key, int def) {
        Prefs.migrate(key, def, Preferences::getInt, Preferences::putInt);
        return Prefs.getPreferences(key).getInt(Prefs.getNodeKey(key), def);
    }

    public static void putLong(String key, long value) {
        Preferences.userRoot().remove(key);
        Prefs.getPreferences(key).putLong(Prefs.getNodeKey(key), value);
    }

    public static long getLong(String key, long def) {
        Prefs.migrate(key, def, Preferences::getLong, Preferences::putLong);
        return Prefs.getPreferences(key).getLong(Prefs.getNodeKey(key), def);
    }

    public static void putBoolean(String key, boolean value) {
        Preferences.userRoot().remove(key);
        Prefs.getPreferences(key).putBoolean(Prefs.getNodeKey(key), value);
    }

    public static boolean getBoolean(String key, boolean def) {
        Prefs.migrate(key, def, Preferences::getBoolean, Preferences::putBoolean);
        return Prefs.getPreferences(key).getBoolean(Prefs.getNodeKey(key), def);
    }

    public static void putFloat(String key, float value) {
        Preferences.userRoot().remove(key);
        Prefs.getPreferences(key).putFloat(Prefs.getNodeKey(key), value);
    }

    public static float getFloat(String key, float def) {
        Prefs.migrate(key, Float.valueOf(def), Preferences::getFloat, Preferences::putFloat);
        return Prefs.getPreferences(key).getFloat(Prefs.getNodeKey(key), def);
    }

    public static void putDouble(String key, double value) {
        Preferences.userRoot().remove(key);
        Prefs.getPreferences(key).putDouble(Prefs.getNodeKey(key), value);
    }

    public static double getDouble(String key, double def) {
        Prefs.migrate(key, def, Preferences::getDouble, Preferences::putDouble);
        return Prefs.getPreferences(key).getDouble(Prefs.getNodeKey(key), def);
    }

    public static void putByteArray(String key, byte[] value) {
        Preferences.userRoot().remove(key);
        Prefs.getPreferences(key).putByteArray(Prefs.getNodeKey(key), value);
    }

    public static byte[] getByteArray(String key, byte[] def) {
        Prefs.migrate(key, def, Preferences::getByteArray, Preferences::putByteArray);
        return Prefs.getPreferences(key).getByteArray(Prefs.getNodeKey(key), def);
    }

    public static void remove(String key) {
        Prefs.getPreferences(key).remove(Prefs.getNodeKey(key));
    }

    public static void flush(String key) throws BackingStoreException {
        Prefs.getPreferences(key).flush();
    }

    private static String getNodeKey(String key) {
        int dotIndex = key.lastIndexOf(46);
        return StringUtil.toLowerCase((String)(dotIndex >= 0 ? key.substring(dotIndex + 1) : key));
    }

    private static Preferences getPreferences(String key) {
        Preferences prefs = Preferences.userRoot();
        int dotIndex = key.lastIndexOf(46);
        if (dotIndex > 0) {
            StringTokenizer tokenizer = new StringTokenizer(key.substring(0, dotIndex), ".", false);
            while (tokenizer.hasMoreElements()) {
                prefs = prefs.node(StringUtil.toLowerCase((String)tokenizer.nextElement()));
            }
        }
        return prefs;
    }

    private static <T> void migrate(String key, T def, Getter<T> getter, Setter<? super T> setter) {
        Preferences prefs = Preferences.userRoot();
        T val = getter.get(prefs, key, def);
        if (!Comparing.equal(val, def)) {
            setter.set(Prefs.getPreferences(key), Prefs.getNodeKey(key), val);
            prefs.remove(key);
        }
    }

    private static interface Setter<T> {
        public void set(Preferences var1, String var2, T var3);
    }

    private static interface Getter<T> {
        public T get(Preferences var1, String var2, T var3);
    }
}

