/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.util.Alarm;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompositeSettingsEditor<Settings>
extends SettingsEditor<Settings> {
    public static final Logger LOG = Logger.getInstance(CompositeSettingsEditor.class);
    protected Collection<SettingsEditor<Settings>> myEditors = Collections.emptyList();
    private SettingsEditorListener<Settings> myChildSettingsListener;
    private SynchronizationController mySyncController;
    private boolean myIsDisposed;

    public CompositeSettingsEditor() {
    }

    public CompositeSettingsEditor(@Nullable Factory<Settings> factory) {
        super(factory);
        if (factory != null) {
            this.mySyncController = new SynchronizationController();
        }
    }

    public abstract CompositeSettingsBuilder<Settings> getBuilder();

    @Override
    public void resetEditorFrom(@NotNull Settings settings) {
        if (settings == null) {
            CompositeSettingsEditor.$$$reportNull$$$0(0);
        }
        for (SettingsEditor<Settings> myEditor : this.myEditors) {
            try {
                myEditor.resetEditorFrom(settings);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void applyEditorTo(@NotNull Settings settings) throws ConfigurationException {
        if (settings == null) {
            CompositeSettingsEditor.$$$reportNull$$$0(1);
        }
        for (SettingsEditor<Settings> myEditor : this.myEditors) {
            try {
                myEditor.applyTo(settings);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void uninstallWatcher() {
        for (SettingsEditor<Settings> editor : this.myEditors) {
            editor.removeSettingsEditorListener(this.myChildSettingsListener);
        }
    }

    @Override
    public void installWatcher(JComponent c) {
        this.myChildSettingsListener = new SettingsEditorListener<Settings>(){

            @Override
            public void stateChanged(@NotNull SettingsEditor<Settings> editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompositeSettingsEditor.this.fireEditorStateChanged();
                if (CompositeSettingsEditor.this.mySyncController != null && !CompositeSettingsEditor.this.myIsDisposed) {
                    CompositeSettingsEditor.this.mySyncController.handleStateChange(editor, CompositeSettingsEditor.this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/options/CompositeSettingsEditor$1", "stateChanged"));
            }
        };
        for (SettingsEditor<Settings> editor : this.myEditors) {
            editor.addSettingsEditorListener(this.myChildSettingsListener);
        }
    }

    @Override
    @NotNull
    protected final JComponent createEditor() {
        CompositeSettingsBuilder<Settings> builder = this.getBuilder();
        this.myEditors = builder.getEditors();
        for (SettingsEditor<Settings> editor : this.myEditors) {
            Disposer.register((Disposable)this, editor);
            editor.setOwner(this);
        }
        JComponent jComponent = builder.createCompoundEditor();
        if (jComponent == null) {
            CompositeSettingsEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Override
    public void disposeEditor() {
        this.myIsDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/CompositeSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/CompositeSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SynchronizationController {
        private final Set<SettingsEditor<?>> myChangedEditors = new HashSet();
        private Alarm mySyncAlarm;
        private boolean myIsInSync;

        private SynchronizationController() {
        }

        public void handleStateChange(@NotNull SettingsEditor<?> editor, @NotNull Disposable parentDisposable) {
            if (editor == null) {
                SynchronizationController.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                SynchronizationController.$$$reportNull$$$0(1);
            }
            if (this.myIsInSync) {
                return;
            }
            this.myChangedEditors.add(editor);
            if (this.mySyncAlarm == null) {
                this.mySyncAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
            } else {
                this.mySyncAlarm.cancelAllRequests();
            }
            this.mySyncAlarm.addRequest(this::sync, 300);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sync() {
            this.myIsInSync = true;
            try {
                Object snapshot = CompositeSettingsEditor.this.getSnapshot();
                for (SettingsEditor editor : CompositeSettingsEditor.this.myEditors) {
                    if (this.myChangedEditors.contains(editor)) continue;
                    editor.resetFrom(snapshot);
                }
            }
            catch (ConfigurationException configurationException) {
            }
            finally {
                this.myChangedEditors.clear();
                this.myIsInSync = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentDisposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/options/CompositeSettingsEditor$SynchronizationController";
            objectArray[2] = "handleStateChange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

